/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.shell.TrayIcon;
import com.jniwrapper.win32.shell.TrayIconListener;
import com.jniwrapper.win32.shell.TrayMessage;
import com.jniwrapper.win32.VersionInfo;
import com.jniwrapper.win32.ui.Msg;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * @author Serge Piletsky
 */
class TrayIconSample extends LazyPanel implements ActionListener
{
    private static final String MENU_ITEM_SHOW_TRAY_ICON = "Show Tray Icon";
    private static final String MENU_ITEM_SHOW_STANDARD_ICON = "Show Stadard System Icon";
    private static final String MENU_ITEM_SHOW_CUSTOM_ICON = "Show Custom Icon";
    private static final String MENU_ITEM_SHOW_CALLOUT = "Show Tray Balloon";
    private static final String MENU_HIDE_TRAY_ICON = "Hide Tray Icon";

    private JLabel lblAdvisoryText;
    private JButton btnShowTrayIcon;
    private JButton btnShowStandardSystemIcon;
    private JButton btnShowCustomIcon;
    private JButton btnShowTrayBallon;
    private JButton btnHideTrayIcon;

    private TrayIcon _trayIcon;
    private PopupMenu _popupMenu;
    private Window _popupMenuInvoker;

    public TrayIconSample(Window parent)
    {
        super(parent);
    }

    public void initialize() throws Exception
    {
        lblAdvisoryText = new HTMLText("This page demonstrates the Tray Icon abilities: misc. icons, menu, balloons.");

        btnShowTrayIcon = new JButton(MENU_ITEM_SHOW_TRAY_ICON);
        btnShowTrayIcon.setActionCommand(MENU_ITEM_SHOW_TRAY_ICON);
        btnShowTrayIcon.addActionListener(this);

        btnShowStandardSystemIcon = new JButton(MENU_ITEM_SHOW_STANDARD_ICON);
        btnShowStandardSystemIcon.setActionCommand(MENU_ITEM_SHOW_STANDARD_ICON);
        btnShowStandardSystemIcon.addActionListener(this);

        btnShowCustomIcon = new JButton(MENU_ITEM_SHOW_CUSTOM_ICON);
        btnShowCustomIcon.setActionCommand(MENU_ITEM_SHOW_CUSTOM_ICON);
        btnShowCustomIcon.addActionListener(this);

        btnShowTrayBallon = new JButton(MENU_ITEM_SHOW_CALLOUT);
        btnShowTrayBallon.setActionCommand(MENU_ITEM_SHOW_CALLOUT);
        btnShowTrayBallon.addActionListener(this);

        btnHideTrayIcon = new JButton(MENU_HIDE_TRAY_ICON);
        btnHideTrayIcon.setActionCommand(MENU_HIDE_TRAY_ICON);
        btnHideTrayIcon.addActionListener(this);

        Dimension buttonSize = btnShowStandardSystemIcon.getPreferredSize();

        btnShowTrayIcon.setPreferredSize(buttonSize);
        btnShowCustomIcon.setPreferredSize(buttonSize);
        btnShowTrayBallon.setPreferredSize(buttonSize);
        btnHideTrayIcon.setPreferredSize(buttonSize);

        setLayout(new GridBagLayout());

        add(lblAdvisoryText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 10, 10), 0, 0));

        add(btnShowTrayIcon, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(btnShowStandardSystemIcon, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(btnShowCustomIcon, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(btnShowTrayBallon, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(btnHideTrayIcon, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 10, 10, 10), 0, 0));

        add(new JPanel(), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0
                , GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

        _trayIcon = new TrayIcon(Icon.SystemIcon.BANG.getIcon());
        _trayIcon.setToolTip("Tray Tooltip");
        _trayIcon.addTrayListener(new TrayIconListener()
        {
            public void trayActionPerformed(long message, int x, int y)
            {
                if (message == Msg.WM_RBUTTONUP)
                {
                    showPopup(x, y);
                }
                else if (message == Msg.WM_LBUTTONDBLCLK)
                {
                    _trayIcon.setIcon(Icon.SystemIcon.HAND.getIcon());
                }
             }
        });

        _popupMenu = new PopupMenu();
        _popupMenu.add(MENU_ITEM_SHOW_STANDARD_ICON);
        _popupMenu.add(MENU_ITEM_SHOW_CUSTOM_ICON);
        _popupMenu.addSeparator();
        _popupMenu.add(MENU_ITEM_SHOW_CALLOUT);
        _popupMenu.addSeparator();
        _popupMenu.add(MENU_HIDE_TRAY_ICON);
        _popupMenu.addActionListener(this);

        _popupMenuInvoker = new JWindow(getParentWindow());
        _popupMenuInvoker.add(_popupMenu);
        _popupMenuInvoker.setVisible(true);

        VersionInfo versionInfo = new VersionInfo();
        if (versionInfo.isWin9x())
        {
            btnShowTrayBallon.setEnabled(false);
            btnHideTrayIcon.setEnabled(false);
        }

        super.initialize();
    }

    private void showPopup(int x, int y)
    {
        _popupMenu.show(_popupMenuInvoker, x, y);
    }

    private void changeIconToQuestion()
    {
        _trayIcon.setIcon(Icon.SystemIcon.QUES.getIcon());
    }

    private void changeIconToCustom()
    {
        Icon customIcon = new Icon();
        customIcon.loadFromFile("jniwrapper.ico");
        _trayIcon.setIcon(customIcon);
    }

    private void showCallout()
    {
        _trayIcon.showMessage(new TrayMessage.Warning("Tray Balloon",
                "This program demonstrates the WinPack for JNIWrapper library abilities:\n" +
                "\t - tray icon\n" +
                "\t - menu for tray icon\n" +
                "\t - balloons from tray icon\n" +
                "etc."));
    }

    public void actionPerformed(ActionEvent e)
    {
        if (e.getActionCommand().equals(MENU_ITEM_SHOW_TRAY_ICON))
        {
            _trayIcon.setVisible(true);
        }
        else if (e.getActionCommand().equals(MENU_ITEM_SHOW_STANDARD_ICON))
        {
            changeIconToQuestion();
        }
        else if (e.getActionCommand().equals(MENU_ITEM_SHOW_CUSTOM_ICON))
        {
            changeIconToCustom();
        }
        else if (e.getActionCommand().equals(MENU_ITEM_SHOW_CALLOUT))
        {
            showCallout();
        }
        else if (e.getActionCommand().equals(MENU_HIDE_TRAY_ICON))
        {
            _trayIcon.setVisible(false);
        }
    }

    public void deactivate()
    {
        _trayIcon.setVisible(false);
    }

    public void activate() throws Exception
    {
        super.activate();
        _trayIcon.setVisible(true);
    }
}
