/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.*;
import com.jniwrapper.win32.Kernel32;

/**
 * This class represents MEMORYSTATUS structure.
 *
 * @author Serge Piletsky
 */
public class MemoryStatus extends Structure
{
    static final String FUNCTION_GET_MEMORY_STATUS = "GlobalMemoryStatus";

    private Int32 _length = new Int32();
    private Int32 _memoryLoad = new Int32();
    private Int32 _totalPhys = new Int32();
    private Int32 _availPhys = new Int32();
    private Int32 _totalPageFile = new Int32();
    private Int32 _availPageFile = new Int32();
    private Int32 _totalVirtual = new Int32();
    private Int32 _availVirtual = new Int32();

    /**
     * Creates instance with information on current memory state.
     */
    public MemoryStatus()
    {
        init(new Parameter[]
        {
            _length,
            _memoryLoad,
            _totalPhys,
            _availPhys,
            _totalPageFile,
            _availPageFile,
            _totalVirtual,
            _availVirtual
        });

        Function function = Kernel32.get(FUNCTION_GET_MEMORY_STATUS);
        function.invoke(null, new Pointer.OutOnly(this));
    }

    public long getMemoryLoad()
    {
        return _memoryLoad.getValue();
    }

    public long getTotalPhys()
    {
        return _totalPhys.getValue();
    }

    public long getAvailPhys()
    {
        return _availPhys.getValue();
    }

    public long getTotalPageFile()
    {
        return _totalPageFile.getValue();
    }

    public long getAvailPageFile()
    {
        return _availPageFile.getValue();
    }

    public long getTotalVirtual()
    {
        return _totalVirtual.getValue();
    }

    public long getAvailVirtual()
    {
        return _availVirtual.getValue();
    }
}
