/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * DBMS: With this tag it is possible to call any SQL statement
 *       and execute those on a specified (DB tag) database
 *
 *       For a normal SQL Select statement use following syntax:
 *       {DBMS::select_statement::output_tag_name[::nbr_of_rows]}
 *
 *       For an Update statement please use this syntax:
 *       {DBMS::UPDATE::update_statement::output_success::output_failed[::nbr_of_affected_rows]}
 *
 * History: - Creation nh
 *          - Removed all sql functionality and extended it of PRePTagDatabase instead of PRePTagCode
 *
 * @author nh
 * @version 2.0
 * @see PRePMain, TagList, PRePTag, PRePTagCode
 */
package com.delec.prep;

public class PRePTagDBMS extends PRePTagDatabase
{
	/**
	 * Constructor
	 */
	public PRePTagDBMS()
	{
		super("DBMS");
	}

	/**
	  * @param Session contains TagList and PrintWriter
	  */
	public void compile(Session session) 
	{
		TagList tagList = session.getTagList();

		PRePTagCount prepTagCount = (PRePTagCount) tagList.find("ARG0");

		if ( prepTagCount != null )
		{
			int iArgs = prepTagCount.getIntValue(); 

			if ( iArgs >= 2 )
			{
				PRePTag prepTagFirstArg = tagList.find("ARG1");

				if ( prepTagFirstArg.getValue().equals("UPDATE") )
				{
					// Update statement
					compileUPDATE(session, iArgs);
				}
				else
				{
					// Select statement
					String strStatement = prepTagFirstArg.getAllValue();
					Store store = executeSQL(strStatement, session);

					if ( store != null )
					{

						PRePTag prepTagOut = tagList.find("ARG2");
						prepTagOut = tagList.find(prepTagOut.getValue());

						if ( prepTagOut != null )
						{

							if ( iArgs > 2 )
							{
								PRePTag prepTagNbrOfRows = tagList.find("ARG3");
								Integer intRows = new Integer(prepTagNbrOfRows.getValue());
								int iRows = intRows.intValue();

								store.compileFields(session, prepTagOut, iRows);                
							}
							else
							{
								store.compileFields(session, prepTagOut);
							}
						}
						else
						{
							session.getExceptionList().addElement(new PRePException(this, "'output tag not valid'"));   
						}
					}
					else
					{
						session.getExceptionList().addElement(new PRePException(this, "'store object is null'", 2));
					}
				}
			}
		}
	}

	public void compileUPDATE(Session session, int iArgs)
	{
		TagList tagList = session.getTagList();

		PRePTag prepTagStmt = tagList.find("ARG2");

		int iRows = executeUPDATE(prepTagStmt.getValue(), session);

		if ( iRows > 0 )
		{

			PRePTag prepTagOutSuccess = tagList.find("ARG3");

			// no output tag name at all
			if ( prepTagOutSuccess != null )
			{
				prepTagOutSuccess = tagList.find(prepTagOutSuccess.getValue());

				// no output tag found in taglist
				if ( prepTagOutSuccess != null )
				{
					int iTagListSize = tagList.size();

					PRePTag prepTagRows = tagList.find("ARG5");

					if ( prepTagRows != null )
					{
						PRePTagText prepTagTextRows = new PRePTagText(prepTagRows.getValue(), ""+iRows);
						tagList.addElement(prepTagTextRows);
					}

					prepTagOutSuccess.compile(session); 

					tagList.setSize(iTagListSize);        
				}
				else
				{
					session.getExceptionList().addElement(new PRePException(this, "'output tag for successful updating not found'"));
				}
			}

			else
			{
				session.getExceptionList().addElement(new PRePException(this, "'no output tag found'"));
			} 
		}

		else
		{
			PRePTag prepTagOutFailed = tagList.find("ARG4");

			// is there an output tag name at all
			if ( prepTagOutFailed != null )
			{
				prepTagOutFailed = tagList.find(prepTagOutFailed.getValue());

				// is there a value for the output tag name?
				if ( prepTagOutFailed != null )
				{
					prepTagOutFailed.compile(session);
				}
				else
				{
					session.getExceptionList().addElement(new PRePException(this, "'output tag for failed updating not found'"));
				}

			}
			session.getExceptionList().addElement(new PRePException(this, "'no output tag found at all'"));
		}
	}
}



