/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
* PReP Version 1.0
*
* PRePTagFILEREADER: reads a file and outputs its contain directly without compiling
*
* History: - Creation 04/28/99 nh
*
* Date: 04/28/99
*
* @author nh
* @version 1.0
*/

package com.delec.prep;

import java.io.*;

public class PRePTagFILEREADER extends PRePTagCode
{
    public PRePTagFILEREADER()
    {
	super("FILEREADER");
    }

    public void compile(Session session)
    {
	TagList tagList = session.getTagList();

	if (getArg(tagList, 1) != null)
	{
	    PRePTag prepTagFile = tagList.find("ARG1");
	  
	    File file = new File(prepTagFile.getValue());
	    FileReader fReader = null;
	    BufferedReader bReader = null;

	    String strFileText = "";

	    try {
		fReader = new FileReader(file);
		bReader = new BufferedReader(fReader);

		String strInput = bReader.readLine();

		while (strInput != null) {
		    strFileText = strFileText+strInput+'\r'+'\n';
		    strInput = bReader.readLine();
		}

		session.getPrintWriter().print(strFileText);
		session.getPrintWriter().flush();
	    }
	    catch (Exception e)
	    {
		exception(session, e, "Exception during working with the file: "+file.toString());
	    }
	}
	else
	{
	    exception(session, "arguments missing");
	}	       
    }
}

