/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * PRePTagNBSP: replaces all spaces into HTML spaces (&NBSP;)
 *
 *              will mainly be used for formatting the output of DBMS tags
 *
 * Histrory: - Creation 12/17/98 nh
 *
 * Date:        12/17/98
 *
 * @author nh
 * @version 1.0
 * @see PRePTagDATE, PRePTagDBMS, PRePTagDEF, PRePTagEXEC, PRePTagFOREACHARG, PRePTagIF, PRePTagIFDEF, PRePTagLIST
 */

package com.delec.prep;

import java.util.Vector;
import java.io.*;

public class PRePTagNBSP extends PRePTagCode
{
	/**
	 * value of the tag
	 */
	protected String value;

	/**
	 * Constructor
	 */
	public PRePTagNBSP()
	{
		super("NBSP");
	}

	public void compile(Session session)
	{
		PRePTagCount prepTagCount = (PRePTagCount)session.getTagList().find("ARG0");
		int iArgs = prepTagCount.getIntValue();
		PRePTag prepTag = session.getTagList().find("ARG1");
		if ( prepTag != null )
		{
			String strNBSP = "&nbsp;";
			String strPrepTag = prepTag.getAllValue();
			String strNewString = strPrepTag;
			String strTab = "";
			int iCount = 1;
			int iTimesTab = 0;
			int iTab = 0;
			if ( iArgs > 1 )
			{
				PRePTag prepTagTab = session.getTagList().find("ARG2");

				if ( prepTagTab != null )
				{
					Integer integer = new Integer(prepTagTab.getValue());
					iTab = integer.intValue();
				}
			}

			for ( int i = 0; i < strPrepTag.length(); i++ )
			{
				if ( strPrepTag.charAt(i) == '\t' )
				{
					if ( iTab > 0 )
					{
						//how many spaces until the next tab stop
						iCount = iCount - 1;
						iTimesTab = iCount%iTab;
						iTimesTab = iTab - iTimesTab;
						for ( int k = 0; k < iTimesTab; k++ )
						{
							strTab = strTab + strNBSP;
						} 
						iCount = iCount - (strTab.length()-1) + iTimesTab;
					}
					strPrepTag = strPrepTag.substring(0, i) + strTab + strPrepTag.substring(i+1);
					//i = i + strTab.length();
					strTab = "";
					//iCount++;
				}
				else if ( strPrepTag.charAt(i) == ' ' )
				{
					strPrepTag = strPrepTag.substring(0, i) + strNBSP + strPrepTag.substring(i+1);
					iCount = iCount - (strNBSP.length()-1);
					//i = i+4; 
					//iCount++;
				}
				else if ( (strPrepTag.charAt(i) == '\r') || (strPrepTag.charAt(i) == '\n') )
				{
					iCount = 0;
				}
				iCount++;
			}     
			prepTag.setValue(strPrepTag);
			session.getPrintWriter().print(strPrepTag);
			session.getPrintWriter().flush();
		}
		else
		{
			session.getExceptionList().addElement(new PRePException(this, "Argument missing!"));
		}
	}
}

