/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
* PReP Version 1.0
*
* PRePTagPARSE: The PARSE tag opens a specified file, parses this file and 
*		compiles a certain tag. After that the taglist is resized to the 
*		normal size.
*
*		Structure:
*
*		{PARSE::file_name::tag_to_execute_name}
*
* History: - Creation 03/02/99 nh
*
* Date:	03/02/99
*
* @author nh
* @version 1.0
*/

package com.delec.prep;

import com.delec.prep.*;
import java.io.*;

public class PRePTagPARSE extends PRePTagCode
{

	public PRePTagPARSE()
	{
		super("PARSE");
	}


	public void compile(Session session)
	{
		TagList tagList = session.getTagList();
		PRePTagCount tagCount = (PRePTagCount)tagList.find("ARG0");

		if ( tagCount != null )
		{
			int iArgs = tagCount.getIntValue();

			if ( iArgs == 2 )
			{
				PRePTag prepTagFile = tagList.find("ARG1");
				PRePTag prepTag = tagList.find("ARG2");
				int iTagListSize = tagList.size();

				File file = new File(prepTagFile.getValue());

				PRePMain prepMain = (PRePMain)session.getPRePMain();

				prepMain.putFile(file);

				prepTag = tagList.find(prepTag.getValue());

				if ( prepTag != null )
				{
					prepTag.compile(session);
				}
				else
				{
					session.getExceptionList().addElement(new PRePException(this, "'tag not valid'"));
				}

				tagList.setSize(iTagListSize);
			}
			else
			{
				session.getExceptionList().addElement(new PRePException(this, "'arguments missing'"));

			}       
		}
		else
		{
			session.getExceptionList().addElement(new PRePException(this, "'no arguments'"));

		}
	}

}
