package MSBMail;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;

	public class RMailServlet extends HttpServlet
    { 
	
     boolean debugMode=true;		 
	 String smtpServer="127.0.0.1"; // localhost
	 String smtpMyComputer="127.0.0.1";
	 String smtpMyemail="RMail@mycompany.com"; // owner of the mailbox used to send messages
	

        /**
         * Handle the HTTP POST method by sending an e-mail
         */
	 
	    public void init() throws ServletException  {
			
			try {
			
			super.init();
			
			String s;
			// get conf parameters
			s=this.getInitParameter("SERVER");  
			if (s!=null)
			     if (s.length()!=0) smtpServer=s;
			
			debugMode=false;
			s=this.getInitParameter("DEBUG");  
			if (s!=null)
			     if (s.compareTo("Y")==0) debugMode=true;			
				
			s=this.getInitParameter("COMPUTER");
			if (s!=null)
			     if (s.length()!=0) smtpMyComputer=s;			
			
			
			s=this.getInitParameter("USER"); 
			if (s!=null)
			     if (s.length()!=0) smtpMyemail=s;	
			
		    
			java.lang.System.out.println("SERVER: "+smtpServer);
			java.lang.System.out.println("USER: "+smtpMyemail);
			java.lang.System.out.println("COMPUTER: "+smtpMyComputer);
			if (debugMode) 
		     	java.lang.System.out.println("DEBUG: yes");
			else
				java.lang.System.out.println("DEBUG: no");
		    			
			
			} catch (Exception e) {java.lang.System.out.println (e.getMessage());}
	    }
	 

        public void doGet (HttpServletRequest request,
                	   HttpServletResponse response)
        throws ServletException, IOException
        {
	    PrintWriter		out;
	    String		title = "RMailServlet";
		

	    // set content type and other response header fields first
        response.setContentType("text/html");

	    // then write the data of the response
	    out = response.getWriter();

            out.println("<HTML><HEAD><TITLE>");
	    out.println(title);
	    out.println("</TITLE></HEAD><BODY>");
	    out.println("<H1>" + title + "</H1>");
	    out.println("<P>RMailServlet does not support GET.");
	    out.println("</BODY></HTML>");
	    out.close();
        }
    	 
		
        public void doPost (HttpServletRequest request,
                	   HttpServletResponse response)
        throws ServletException
        {
	    PrintWriter		out;
		String result="";
		
		try {
		
			
		// get parameters
		String To=request.getParameter("to"); // to
		if (To==null) To="";
		String CC=request.getParameter("cc"); // copy
		if (CC==null) CC="";
		String BCC=request.getParameter("bcc"); // blind copy
		if (BCC==null) BCC=""; 
		String Subject=request.getParameter("subject"); // subject
		if (Subject==null) Subject="";
		String Body=request.getParameter("body"); // text
		if (Body==null) Body="";
		String sendUrl=request.getParameter("sendUrl"); // url to attach
		if (sendUrl==null) sendUrl="";	
		
		if (debugMode) {
			java.lang.System.out.println("Mail to: "+ To);
			java.lang.System.out.println("CC: "+ CC);
			java.lang.System.out.println("BCC: "+ BCC);
			java.lang.System.out.println("Subject: "+ Subject);
			java.lang.System.out.println("Body: "+ Body);
			java.lang.System.out.println("URL: "+ sendUrl);
			
		}		

		// send email
	    MailMsg msg =new MailMsg();
		MailMsgPart attach= new MailMsgPart();
		MailMsgPart body= new MailMsgPart();
		
		msg.smtpServer=smtpServer;
		msg.smtpMyAddress=this.smtpMyComputer;
		msg.from=this.smtpMyemail;
		// to
		String[] to=splitAddress(To);
		for (int i=0;i<to.length;i++) msg.addRecipient(to[i]);
		// bcc
		String[] bcc=splitAddress(BCC);
		for (int i=0;i<bcc.length;i++) msg.addBCC(bcc[i]);
		// cc
		String[] cc=splitAddress(CC);
		for (int i=0;i<cc.length;i++) msg.addCC(cc[i]);	
		
		msg.subject=Subject;
		
		// add body
		body.setData(Body,MimeEncoder.QUOTED);
		msg.addPart(body);
		
		// add html page as attachment
		if (sendUrl.length()>0) {
			
		  // try to load the html page in a string
		   String htmlPage="";
		   
		   try { 
			   
		     // open URL
			 byte[] b=new byte[1]; 
		     InputStream IS = new java.net.URL(sendUrl).openStream();
		     while (IS.available()>0) {
			   IS.read(b); // read 1 byte at a time  
		       htmlPage=htmlPage+ ((char) b[0]);	   
		     }
		     IS.close();
		   
		     // create new part for the e mail message
		   
		    attach.ContentType="Text"; 
		    attach.ContentSubType="html"; // the new part will be html
		    attach.setData(htmlPage,MimeEncoder.QUOTED);
		    msg.addPart(attach);	
		   }
		   catch (Exception e) {}
		   
		}
		
		
		if (msg.mail()!=0) result="disconnected. "+msg.smtpStatus;
		else result="Mail sent OK";	
		
		
	    // set content type and other response header fields first
        response.setContentType("text/plain");

		} catch (Exception e1) {result=e1.getMessage();}		
		
		
		try {	
	    // then write the data of the response
	    out = response.getWriter();
        out.println(result);
	    out.close();
		}
		catch 	(Exception e1) {}
		
		
    }
	  
   // several addresses may be separated by ;  
   private String[] splitAddress(String add) {
		String[] a=new String[100];
		int count=0;
		int p;
					   
	    p=add.indexOf(";");
		while (p>0) {
			if (add.substring(0,p).length()>0) a[count++]=add.substring(0,p);
			add=add.substring(p+1,add.length());
			p=add.indexOf(";");
		}
		
		if (add.length()>0) a[count++]=add;
		
		String[] result=new String[count];
		for (int i=0;i<count;i++) result[i]=a[i];
		
		return result;
	}	  

	}

