/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCComponent;
import jclass.bwt.JCHeader;
import jclass.bwt.JCListComponent;
import jclass.bwt.JCMultiColumnData;
import jclass.bwt.JCMultiColumnInterface;
import jclass.bwt.JCMultiColumnWindow;
import jclass.bwt.MultiColumnConverter;
import jclass.util.JCSortInterface;
import jclass.util.JCUtilConverter;
import jclass.util.JCVector;
import jclass.util.JCqsort;

public class JCMultiColumnListComponent
extends JCListComponent
implements JCMultiColumnInterface {
    protected JCMultiColumnData data = new JCMultiColumnData(this);
    boolean num_columns_set = false;
    int largest_size;
    private static final String base = "multicolumnlist";
    private static int nameCounter;

    public JCMultiColumnListComponent() {
        this(null, null, null);
    }

    public JCMultiColumnListComponent(JCVector jCVector) {
        this(jCVector, null, null);
    }

    public JCMultiColumnListComponent(JCVector jCVector, Applet applet, String string) {
        super(jCVector, applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.spacing = 1;
        this.highlight = 1;
        this.border = 1;
        this.insets.right = 0;
        this.insets.left = 0;
        if (this.getClass().getName().equals("jclass.bwt.JCMultiColumnListComponent")) {
            this.getParameters(applet);
        }
        if (jCVector != null) {
            this.setItems(jCVector);
        }
    }

    public JCMultiColumnListComponent(int n, boolean bl) {
        super(n, bl);
    }

    protected void getParameters() {
        super.getParameters();
        MultiColumnConverter.getParams(this, JCComponent.conv);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.getPeer() == null) {
            return;
        }
        this.calcColumnWidths();
        this.calcSize(false);
        if (this.scrolled_window == null) {
            this.repaint();
        }
    }

    public void setItems(String[] stringArray) {
        JCVector jCVector = new JCVector(stringArray);
        int n = 0;
        while (n < jCVector.size()) {
            jCVector.setElementAt(n, JCComponent.conv.toVector(this, stringArray[n], ',', true));
            ++n;
        }
        this.setItems(jCVector);
    }

    public synchronized String[] getItemsStrings() {
        String[] stringArray = new String[this.items.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = JCUtilConverter.toString(this.items.elementAt(n));
            ++n;
        }
        return stringArray;
    }

    void calcColumnWidths() {
        if (this.batched) {
            this.needs_recalc = true;
            return;
        }
        this.data.calcColumnWidths();
    }

    JCHeader getHeader() {
        if (this.scrolled_window != null && this.scrolled_window instanceof JCMultiColumnWindow) {
            return ((JCMultiColumnWindow)this.scrolled_window).getHeader();
        }
        return null;
    }

    JCMultiColumnWindow getWindow() {
        if (this.scrolled_window != null && this.scrolled_window instanceof JCMultiColumnWindow) {
            return (JCMultiColumnWindow)this.scrolled_window;
        }
        return null;
    }

    public void setColumnLabels(JCVector jCVector) {
        if (this.getWindow() != null) {
            this.getWindow().setColumnLabels(jCVector);
        }
    }

    public void setColumnButtons(JCVector jCVector) {
        if (this.getWindow() != null) {
            this.getWindow().setColumnButtons(jCVector);
        }
    }

    public void setBatched(boolean bl) {
        if (this.batched == bl) {
            return;
        }
        this.batched = bl;
        if (this.getHeader() != null) {
            this.getHeader().batched = bl;
        }
        if (this.batched) {
            return;
        }
        if (this.needs_recalc) {
            this.calcColumnWidths();
            this.calcSize(true);
            if (this.getHeader() != null) {
                this.getHeader().recalc();
            }
        }
        if (this.needs_recalc || this.needs_repaint) {
            this.repaint();
        }
        this.needs_repaint = false;
        this.needs_recalc = false;
    }

    protected void calcSize(int n, boolean bl) {
        boolean bl2;
        int n2;
        JCMultiColumnListComponent jCMultiColumnListComponent = this;
        synchronized (jCMultiColumnListComponent) {
            Object e;
            this.pref_width_internal = 0;
            this.calcColumnWidths();
            if (!this.num_columns_set && n >= 0 && n < this.items.size() && (e = this.items.elementAt(n)) instanceof Vector && !BWTUtil.is_jcstring(e)) {
                this.largest_size = Math.max(this.largest_size, ((Vector)e).size());
            }
            n2 = this.largest_size;
        }
        if (this.getNumColumns() < n2) {
            this.data.setNumColumns(n2);
            if (this.getHeader() != null) {
                this.getHeader().setNumColumns(n2);
            }
        }
        jCMultiColumnListComponent = this;
        synchronized (jCMultiColumnListComponent) {
            bl2 = this.batched;
            if (this.batched) {
                this.needs_recalc = true;
            }
        }
        if (!bl2) {
            super.calcSize(n, bl);
            if (this.getPeer() != null) {
                this.calcColumnWidths();
                this.calcSize(true);
                if (this.getHeader() != null) {
                    this.getHeader().recalc();
                }
            }
        }
    }

    public void addItem(String string, char c) {
        this.addItem(JCComponent.conv.toVector(this, string, c, true));
    }

    public void addItem(Applet applet, String string, char c) {
        this.addItem(JCComponent.conv.toVector(applet, string, c, true));
    }

    protected void draw(Graphics graphics, Object object, int n, Rectangle rectangle) {
        this.data.draw(graphics, object, rectangle);
    }

    protected void drawHighlight(Graphics graphics, boolean bl) {
        super.drawHighlight(graphics, bl);
        if (bl) {
            return;
        }
        graphics.setColor(this.highlight_color != null ? this.highlight_color : Color.black);
        graphics.drawRect(this.highlight - 1, this.highlight - 1, this.size().width - 2 * this.highlight + 1, this.size().height - 2 * this.highlight + 1);
    }

    public void addNotify() {
        super.addNotify();
        if (!this.num_columns_set) {
            int n = 0;
            int n2 = this.items.size();
            while (n < n2) {
                Object e = this.items.elementAt(n);
                if (e instanceof Vector && !BWTUtil.is_jcstring(e)) {
                    this.largest_size = Math.max(this.largest_size, ((Vector)e).size());
                }
                ++n;
            }
            if (this.getNumColumns() < this.largest_size) {
                this.data.setNumColumns(this.largest_size);
                if (this.getHeader() != null) {
                    this.getHeader().data.setNumColumns(this.largest_size);
                }
            }
        }
        this.calcColumnWidths();
        this.pref_width_internal = this.data.preferredWidth();
    }

    protected int preferredWidth() {
        if (this.pref_width_internal == 0) {
            this.calcColumnWidths();
            if (this.getHeader() != null) {
                this.getHeader().recalc();
            }
        }
        this.pref_width_internal = this.data.preferredWidth();
        return this.pref_width_internal;
    }

    public void sortByColumn(int n, JCSortInterface jCSortInterface) {
        this.sortByColumn(n, jCSortInterface, 0);
    }

    public void sortByColumn(int n, JCSortInterface jCSortInterface, int n2) {
        int n3;
        int[] nArray;
        int[] nArray2 = new int[]{};
        int n4 = 0;
        JCMultiColumnListComponent jCMultiColumnListComponent = this;
        synchronized (jCMultiColumnListComponent) {
            int n5;
            Object[] objectArray;
            n4 = this.items.size();
            nArray = new JCqsort(this.items, jCSortInterface).sort(n, n2);
            if (nArray == null) {
                Object var7_8 = null;
                return;
            }
            nArray2 = new int[nArray.length];
            n3 = 0;
            while (n3 < nArray.length) {
                nArray2[nArray[n3]] = n3;
                ++n3;
            }
            if (this.userdata_list != null) {
                this.updateUserdataList();
                objectArray = new Object[n4];
                n5 = 0;
                while (n5 < n4) {
                    objectArray[n5] = this.userdata_list[nArray2[n5]];
                    ++n5;
                }
                this.userdata_list = objectArray;
            }
            if (this.selected != null && this.selected.length == n4) {
                objectArray = new boolean[n4];
                n5 = 0;
                while (n5 < n4) {
                    objectArray[n5] = this.selected[nArray2[n5]];
                    this.last_selected[n5] = false;
                    ++n5;
                }
                this.selected = (boolean[])objectArray;
            }
        }
        if (this.row_height_ext != -998) {
            this.repaint();
            return;
        }
        jCMultiColumnListComponent = this;
        synchronized (jCMultiColumnListComponent) {
            if (this.row_heights.length == n4) {
                nArray = new int[n4];
                n3 = 0;
                while (n3 < n4) {
                    nArray[n3] = this.row_heights[nArray2[n3]];
                    ++n3;
                }
                this.row_heights = nArray;
                int n6 = 1;
                while (n6 < n4) {
                    this.row_pos[n6] = this.row_pos[n6 - 1] + this.row_heights[n6 - 1];
                    ++n6;
                }
            }
        }
        this.repaint();
    }

    public int calcWidth(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.items.size()) {
            Object var4_4 = null;
            Object e = this.items.elementAt(n3);
            if (e instanceof Vector && !BWTUtil.is_jcstring(var4_4)) {
                if (n < ((Vector)e).size()) {
                    var4_4 = ((Vector)e).elementAt(n);
                }
            } else {
                var4_4 = e;
            }
            n2 = Math.max(n2, BWTUtil.getWidth(var4_4, this));
            ++n3;
        }
        return n2 + this.getColumnLeftMargin(n) + this.getColumnRightMargin(n);
    }

    public int[] getColumnWidths() {
        return this.data.getColumnWidths();
    }

    public void setColumnWidths(int[] nArray) {
        this.data.setColumnWidths(nArray);
        this.repaint();
    }

    public int getColumnWidth(int n) {
        return this.data.getColumnWidth(n);
    }

    public void setColumnWidth(int n, int n2) {
        this.data.setColumnWidth(n, n2);
        if (this.getHeader() != null) {
            this.getHeader().setColumnWidth(n, n2);
        }
        this.updateParent();
        this.repaint();
    }

    public int getNumColumns() {
        return this.data.num_columns;
    }

    public void setNumColumns(int n) {
        this.data.setNumColumns(n != -998 ? n : this.largest_size);
        this.num_columns_set = n != -998;
        this.calcColumnWidths();
        this.repaint();
    }

    public int[] getColumnAlignments() {
        return this.data.getColumnAlignments();
    }

    public int getColumnAlignment(int n) {
        return this.data.getColumnAlignment(n);
    }

    public void setColumnAlignment(int n, int n2) {
        this.data.setColumnAlignment(n, n2);
        this.repaint();
    }

    public void setColumnAlignments(int[] nArray) {
        this.data.setColumnAlignments(nArray);
        this.repaint();
    }

    public int getColumnPosition(int n) {
        return this.data.getColumnPosition(n) + this.border + 2 * this.highlight + this.insets.left - this.horiz_origin;
    }

    public int getColumnLeftMargin(int n) {
        return this.data.getColumnLeftMargin(n);
    }

    public void setColumnLeftMargin(int n, int n2) {
        this.data.setColumnLeftMargin(n, n2);
        this.calcColumnWidths();
        this.repaint();
    }

    public int getColumnRightMargin(int n) {
        return this.data.getColumnRightMargin(n);
    }

    public void setColumnRightMargin(int n, int n2) {
        this.data.setColumnRightMargin(n, n2);
        this.calcColumnWidths();
        this.repaint();
    }

    public JCMultiColumnData getMultiColumnData() {
        return this.data;
    }

    public int[] getColumnDisplayWidths() {
        return this.data.getColumnDisplayWidths();
    }

    public void setColumnDisplayWidths(int[] nArray) {
        this.data.setColumnDisplayWidths(nArray);
        this.repaint();
    }

    public int getColumnDisplayWidth(int n) {
        return this.data.getColumnDisplayWidth(n);
    }

    public void setColumnDisplayWidth(int n, int n2) {
        this.data.setColumnDisplayWidth(n, n2);
        if (this.getHeader() != null) {
            this.getHeader().setColumnDisplayWidth(n, n2);
        }
        this.updateParent();
        this.repaint();
    }

    public int getColumnResizePolicy() {
        return this.data.getColumnResizePolicy();
    }

    public void setColumnResizePolicy(int n) {
        this.data.setColumnResizePolicy(n);
    }
}

