/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartDraw;
import jclass.chart.JCCandleChartFormat;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCFillStyle;
import jclass.chart.JCLineStyle;
import jclass.chart.MinMax;
import jclass.chart.PlotPoint;

class CandleChartDraw
extends ChartDraw {
    public static final int NUM_SERIES_PER_DATA = 4;
    static final int HI_PT_INDEX = 0;
    static final int LO_PT_INDEX = 1;
    static final int OPEN_PT_INDEX = 2;
    static final int CLOSE_PT_INDEX = 3;
    static final int CANDLE_PT_ARRAY = 4;
    static final int NUM_PER_PT = 2;
    JCCandleChartFormat cf;
    PlotPoint[][][] pts;
    Point[][] ptsIndex;
    boolean[][] risingCandleIndex;
    boolean inStartEdit = false;
    MinMax xlim = new MinMax();
    MinMax ylim = new MinMax();
    Point start;
    Point end;
    Rectangle r;
    boolean useRubberBand = false;

    public void recalc() {
        this.recalc(-1);
    }

    public void recalc(int n) {
        super.recalc();
        boolean bl = this.inStartEdit;
        this.cachePlotData = this.dataObject.getBufferPlotData();
        if (n == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.cf = this.dataObject.getCandleChartFormat();
        this.holeValue = this.dataObject.holeValue;
        this.xaxis = this.dataObject.xaxis;
        this.yaxis = this.dataObject.yaxis;
        this.inverted = this.xaxis.isVertical;
        int n2 = this.seriesList.length / 4;
        if (!bl && !this.cachePlotData && n == -1) {
            if (this.pts == null) {
                this.pts = new PlotPoint[n2][][];
            }
            return;
        }
        if (n == -1 || n == 0) {
            this.xlim = new MinMax();
            this.ylim = new MinMax();
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
        this.pts = new PlotPoint[n2][][];
        this.risingCandleIndex = new boolean[n2][];
        this.ptsIndex = bl ? new Point[n2][] : null;
        boolean bl2 = this.cf.getIsComplex();
        int n3 = n == -1 ? 0 : n;
        int n4 = n == -1 ? n2 : n + 1;
        int n5 = n3;
        while (n5 < n4) {
            JCChartStyle jCChartStyle;
            this.pts[n5] = null;
            this.risingCandleIndex[n5] = null;
            if (bl) {
                this.ptsIndex[n5] = null;
            }
            int n6 = 0;
            int n7 = 0;
            if (bl2) {
                jCChartStyle = this.cf.getRisingCandleStyle(n5);
                if (jCChartStyle != null) {
                    n6 = jCChartStyle.getSymbolSize();
                }
                if ((jCChartStyle = this.cf.getFallingCandleStyle(n5)) != null) {
                    n7 = jCChartStyle.getSymbolSize();
                }
            } else {
                jCChartStyle = this.cf.getHiloStyle(n5);
                if (jCChartStyle != null) {
                    n7 = n6 = jCChartStyle.getSymbolSize();
                }
            }
            boolean bl3 = true;
            int n8 = Integer.MAX_VALUE;
            int n9 = Integer.MAX_VALUE;
            int n10 = Integer.MAX_VALUE;
            int n11 = 4 * n5;
            int n12 = 0;
            while (n12 < 4) {
                ChartDataViewSeries chartDataViewSeries = this.seriesList[n11];
                if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) {
                    bl3 = false;
                    break;
                }
                n8 = Math.min(n8, chartDataViewSeries.maxXIndex());
                n8 = Math.min(n8, chartDataViewSeries.maxYIndex());
                n9 = Math.min(n9, chartDataViewSeries.getFirstPoint());
                n10 = Math.min(n10, chartDataViewSeries.getLastPoint());
                ++n12;
                ++n11;
            }
            if (bl3) {
                this.pts[n5] = new PlotPoint[n8][];
                this.risingCandleIndex[n5] = new boolean[n8];
                if (bl) {
                    this.ptsIndex[n5] = new Point[n8];
                }
                int n13 = 0;
                int n14 = n9;
                while (n14 <= n10) {
                    boolean bl4;
                    double d;
                    boolean bl5 = false;
                    this.pts[n5][n13] = new PlotPoint[8];
                    int n15 = 4 * n5;
                    ChartDataViewSeries chartDataViewSeries = this.seriesList[n15++];
                    double d2 = chartDataViewSeries.getX(n14);
                    double d3 = chartDataViewSeries.getY(n14);
                    chartDataViewSeries = this.seriesList[n15++];
                    double d4 = chartDataViewSeries.getX(n14);
                    double d5 = chartDataViewSeries.getY(n14);
                    if (d3 < d5) {
                        double d6 = d2;
                        d = d3;
                        d2 = d4;
                        d3 = d5;
                        d4 = d6;
                        d5 = d;
                    }
                    chartDataViewSeries = this.seriesList[n15++];
                    double d7 = chartDataViewSeries.getX(n14);
                    double d8 = chartDataViewSeries.getY(n14);
                    chartDataViewSeries = this.seriesList[n15++];
                    double d9 = chartDataViewSeries.getX(n14);
                    double d10 = chartDataViewSeries.getY(n14);
                    this.risingCandleIndex[n5][n13] = bl4 = d8 < d10;
                    int n16 = 0;
                    d = 0.0;
                    double d11 = this.holeValue;
                    boolean bl6 = false;
                    double d12 = d2;
                    double d13 = d3;
                    bl6 = this.plotClip(d, d11, d12, d13, this.xlim, this.ylim, this.pts[n5][n13], n14, n16, 0, 0, bl6, this.inverted);
                    if (this.pts[n5][n13][n16] != null) {
                        if (bl) {
                            this.ptsIndex[n5][this.pts[n5][n13][n16].point] = new Point(n13, n16);
                        }
                        ++n16;
                        bl5 = true;
                    }
                    d = d12;
                    d11 = d13;
                    d12 = bl4 ? d9 : d7;
                    d13 = bl4 ? d10 : d8;
                    bl6 = this.plotClip(d, d11, d12, d13, this.xlim, this.ylim, this.pts[n5][n13], n14, n16, 0, 0, bl6, this.inverted);
                    if (this.pts[n5][n13][n16] != null) {
                        if (bl) {
                            this.ptsIndex[n5][this.pts[n5][n13][n16].point] = new Point(n13, n16);
                        }
                        ++n16;
                        bl5 = true;
                    }
                    n16 = 2;
                    d = 0.0;
                    d11 = this.holeValue;
                    bl6 = false;
                    d12 = d4;
                    d13 = d5;
                    bl6 = this.plotClip(d, d11, d12, d13, this.xlim, this.ylim, this.pts[n5][n13], n14, n16, 2, 3, bl6, this.inverted);
                    if (this.pts[n5][n13][n16] != null) {
                        if (bl) {
                            this.ptsIndex[n5][this.pts[n5][n13][n16].point] = new Point(n13, n16);
                        }
                        ++n16;
                        bl5 = true;
                    }
                    d = d12;
                    d11 = d13;
                    d12 = bl4 ? d7 : d9;
                    d13 = bl4 ? d8 : d10;
                    bl6 = this.plotClip(d, d11, d12, d13, this.xlim, this.ylim, this.pts[n5][n13], n14, n16, 2, 3, bl6, this.inverted);
                    if (this.pts[n5][n13][n16] != null) {
                        if (bl) {
                            this.ptsIndex[n5][this.pts[n5][n13][n16].point] = new Point(n13, n16);
                        }
                        ++n16;
                        bl5 = true;
                    }
                    n16 = 4;
                    d = 0.0;
                    d11 = this.holeValue;
                    bl6 = false;
                    double d14 = d7;
                    double d15 = d8;
                    int n17 = this.xaxis.toPixel(d14, this.drawFront);
                    int n18 = (bl4 ? n6 : n7) / 2;
                    d12 = this.xaxis.toData(n17 - n18, this.drawFront);
                    d13 = d15;
                    bl6 = this.plotClip(d, d11, d12, d13, this.xlim, this.ylim, this.pts[n5][n13], n14, n16, 4, 6, bl6, this.inverted);
                    if (this.pts[n5][n13][n16] != null) {
                        if (bl) {
                            this.ptsIndex[n5][this.pts[n5][n13][n16].point] = new Point(n13, n16);
                        }
                        ++n16;
                        bl5 = true;
                    }
                    d = d12;
                    d11 = d13;
                    d12 = this.xaxis.toData(n17 + n18, this.drawFront);
                    d13 = d15;
                    bl6 = this.plotClip(d, d11, d12, d13, this.xlim, this.ylim, this.pts[n5][n13], n14, n16, 4, 6, bl6, this.inverted);
                    if (this.pts[n5][n13][n16] != null && this.pts[n5][n13][n16].point == n14) {
                        if (bl) {
                            this.ptsIndex[n5][this.pts[n5][n13][n16].point] = new Point(n13, n16);
                        }
                        ++n16;
                        bl5 = true;
                    }
                    n16 = 6;
                    d = 0.0;
                    d11 = this.holeValue;
                    bl6 = false;
                    d14 = d9;
                    d15 = d10;
                    n17 = this.xaxis.toPixel(d14, this.drawFront);
                    d12 = this.xaxis.toData(n17 - n18, this.drawFront);
                    d13 = d15;
                    bl6 = this.plotClip(d, d11, d12, d13, this.xlim, this.ylim, this.pts[n5][n13], n14, n16, 6, 9, bl6, this.inverted);
                    if (this.pts[n5][n13][n16] != null) {
                        if (bl) {
                            this.ptsIndex[n5][this.pts[n5][n13][n16].point] = new Point(n13, n16);
                        }
                        ++n16;
                        bl5 = true;
                    }
                    d = d12;
                    d11 = d13;
                    d12 = this.xaxis.toData(n17 + n18, this.drawFront);
                    d13 = d15;
                    bl6 = this.plotClip(d, d11, d12, d13, this.xlim, this.ylim, this.pts[n5][n13], n14, n16, 6, 9, bl6, this.inverted);
                    if (this.pts[n5][n13][n16] != null && this.pts[n5][n13][n16].point == n14) {
                        if (bl) {
                            this.ptsIndex[n5][this.pts[n5][n13][n16].point] = new Point(n13, n16);
                        }
                        ++n16;
                        bl5 = true;
                    }
                    if (bl5) {
                        ++n13;
                    }
                    ++n14;
                }
            }
            ++n5;
        }
    }

    public void draw(Graphics graphics) {
        if (this.pts == null) {
            return;
        }
        try {
            if (this.seriesList == null) {
                return;
            }
            boolean bl = this.cf.getIsComplex();
            int n = 0;
            while (n < this.pts.length) {
                block27: {
                    JCChartStyle jCChartStyle;
                    JCChartStyle jCChartStyle2;
                    JCChartStyle jCChartStyle3;
                    JCLineStyle jCLineStyle;
                    block29: {
                        JCChartStyle jCChartStyle4;
                        block28: {
                            if (!this.cachePlotData) {
                                this.recalc(n);
                            }
                            if (this.pts[n] == null) break block27;
                            boolean bl2 = true;
                            int n2 = 4 * n;
                            int n3 = 0;
                            while (n3 < 4) {
                                if (!this.seriesList[n2].isShowing) {
                                    bl2 = false;
                                    break;
                                }
                                ++n3;
                                ++n2;
                            }
                            if (!bl2 || (jCChartStyle4 = this.cf.getHiloStyle(n)) == null) break block27;
                            jCLineStyle = jCChartStyle4.getLineStyle();
                            if (!bl) break block28;
                            jCChartStyle3 = this.cf.getRisingCandleStyle(n);
                            if (jCChartStyle3 != null && (jCChartStyle2 = this.cf.getFallingCandleStyle(n)) != null && (jCChartStyle = this.cf.getCandleOutlineStyle(n)) != null) break block29;
                            break block27;
                        }
                        jCChartStyle3 = jCChartStyle4;
                        jCChartStyle2 = jCChartStyle4;
                        jCChartStyle = jCChartStyle4;
                    }
                    int n4 = 0;
                    while (n4 < this.pts[n].length) {
                        if (this.pts[n][n4] != null) {
                            int n5;
                            int n6;
                            int n7;
                            int n8 = 0;
                            while (n8 < 2) {
                                if (this.pts[n][n4][n8 * 2] != null) {
                                    Point point = null;
                                    n7 = 0;
                                    while (n7 < 2) {
                                        n6 = n8 * 2 + n7;
                                        if (this.pts[n][n4][n6] == null || this.pts[n][n4][n6].px == Integer.MAX_VALUE || this.pts[n][n4][n6].py == Integer.MAX_VALUE) {
                                            point = null;
                                        } else {
                                            Point point2 = new Point(this.pts[n][n4][n6].px, this.pts[n][n4][n6].py);
                                            if (point != null) {
                                                jCLineStyle.draw(graphics, point.x, point.y, point2.x, point2.y);
                                            }
                                            point = point2;
                                        }
                                        ++n7;
                                    }
                                }
                                ++n8;
                            }
                            boolean bl3 = false;
                            n7 = Integer.MAX_VALUE;
                            n6 = Integer.MAX_VALUE;
                            int n9 = Integer.MIN_VALUE;
                            int n10 = Integer.MIN_VALUE;
                            int n11 = 2;
                            while (n11 <= 3) {
                                if (this.pts[n][n4][n11 * 2] == null) {
                                    bl3 = true;
                                } else {
                                    n5 = 0;
                                    while (n5 < 2) {
                                        int n12 = n11 * 2 + n5;
                                        if (this.pts[n][n4][n12] == null || this.pts[n][n4][n12].px == Integer.MAX_VALUE || this.pts[n][n4][n12].py == Integer.MAX_VALUE) {
                                            bl3 = true;
                                        } else {
                                            n7 = Math.min(n7, this.pts[n][n4][n12].px);
                                            n9 = Math.max(n9, this.pts[n][n4][n12].px);
                                            n6 = Math.min(n6, this.pts[n][n4][n12].py);
                                            n10 = Math.max(n10, this.pts[n][n4][n12].py);
                                        }
                                        ++n5;
                                    }
                                }
                                ++n11;
                            }
                            if (!bl3) {
                                n5 = this.risingCandleIndex[n][n4];
                                JCFillStyle jCFillStyle = n5 != 0 ? jCChartStyle3.getFillStyle() : jCChartStyle2.getFillStyle();
                                JCLineStyle jCLineStyle2 = jCChartStyle.getLineStyle();
                                int n13 = Math.max(n9 - n7, 1);
                                int n14 = Math.max(n10 - n6, 1);
                                if (bl) {
                                    jCFillStyle.fillRect(graphics, n7, n6, n13, n14);
                                    jCLineStyle2.drawRect(graphics, n7, n6, n13, n14);
                                } else {
                                    if (n5 == 0) {
                                        jCLineStyle2.fillRect(graphics, n7, n6, n13, n14);
                                    }
                                    jCLineStyle2.drawRect(graphics, n7, n6, n13, n14);
                                }
                            }
                        }
                        ++n4;
                    }
                    if (!this.cachePlotData) {
                        this.pts[n] = null;
                        this.risingCandleIndex[n] = null;
                    }
                }
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    JCDataIndex pick(Point point, int n) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        int n2 = -1;
        int n3 = -1;
        JCDataIndex jCDataIndex = null;
        int n4 = Integer.MAX_VALUE;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        int n5 = 0;
        while (n5 < this.pts.length) {
            if (!this.cachePlotData) {
                this.recalc(n5);
            }
            if (this.pts[n5] != null) {
                boolean bl = true;
                int n6 = 4 * n5;
                int n7 = 0;
                while (n7 < 4) {
                    if (!this.seriesList[n6].isShowing) {
                        bl = false;
                        break;
                    }
                    ++n7;
                    ++n6;
                }
                if (bl) {
                    int n8 = 0;
                    while (n8 < this.pts[n5].length) {
                        if (this.pts[n5][n8] != null) {
                            int n9 = 0;
                            while (n9 < 4) {
                                if (this.pts[n5][n8][n9 * 2] != null) {
                                    int n10 = n9 < 2 ? 1 : 2;
                                    int n11 = 0;
                                    while (n11 < n10) {
                                        int n12 = n9 * 2 + n11;
                                        if (this.pts[n5][n8][n12] != null && this.pts[n5][n8][n12].px != Integer.MAX_VALUE && this.pts[n5][n8][n12].py != Integer.MAX_VALUE && this.pts[n5][n8][n12].drawPoint) {
                                            int n13 = Integer.MAX_VALUE;
                                            switch (n) {
                                                case 1: {
                                                    n13 = Math.abs(this.pts[n5][n8][n12].px - point2.x);
                                                    break;
                                                }
                                                case 2: {
                                                    n13 = Math.abs(this.pts[n5][n8][n12].py - point2.y);
                                                    break;
                                                }
                                                default: {
                                                    n13 = JCChartUtil.distance(point2.x, point2.y, this.pts[n5][n8][n12].px, this.pts[n5][n8][n12].py);
                                                }
                                            }
                                            if (n13 < n4) {
                                                n2 = n5 * 4 + n9;
                                                n3 = this.pts[n5][n8][n12].point;
                                                n4 = n13;
                                            }
                                        }
                                        ++n11;
                                    }
                                }
                                ++n9;
                            }
                        }
                        ++n8;
                    }
                    if (!this.cachePlotData) {
                        this.pts[n5] = null;
                        this.risingCandleIndex[n5] = null;
                    }
                }
            }
            ++n5;
        }
        if (n2 >= 0 && n3 >= 0) {
            jCDataIndex = new JCDataIndex(n3, this.seriesList[n2], n2);
            jCDataIndex.distance = n4;
        }
        return jCDataIndex;
    }

    Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = this.seriesList[n2];
        if (chartDataViewSeries == null) {
            return null;
        }
        double d = chartDataViewSeries.getY(n);
        double d2 = chartDataViewSeries.getX(n);
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            if (this.inverted) {
                n3 = this.yaxis.toPixel(d, this.drawFront);
                n4 = this.xaxis.toPixel(d2, this.drawFront);
            } else {
                n3 = this.xaxis.toPixel(d2, this.drawFront);
                n4 = this.yaxis.toPixel(d, this.drawFront);
            }
            return new Point(n3, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        int n;
        int n2;
        int n3;
        PlotPoint[] plotPointArray;
        boolean bl;
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl2 = jCDataIndex.dataView.xaxis.isVertical;
        int n4 = jCDataIndex.series.drawingOrder / 4;
        this.r = this.chartArea.getDrawingArea();
        this.start = null;
        this.end = null;
        this.useRubberBand = false;
        boolean bl3 = bl = this.ptsIndex == null;
        if (bl) {
            this.inStartEdit = true;
            this.recalc(n4);
        }
        if ((plotPointArray = this.pts[n4][n3 = this.ptsIndex[n4][jCDataIndex.point].x])[n2 = (n = jCDataIndex.seriesIndex - n4 * 4) * 2] != null && plotPointArray[n2].px != Integer.MAX_VALUE && plotPointArray[n2].py != Integer.MAX_VALUE) {
            if (n > 1) {
                this.useRubberBand = true;
            }
            this.start = new Point(plotPointArray[n2].px + this.r.x, plotPointArray[n2].py + this.r.y);
            this.end = bl2 ? new Point(plotPointArray[n2].px + this.r.x, plotPointArray[n2 + 1].py + this.r.y) : new Point(plotPointArray[n2 + 1].px + this.r.x, plotPointArray[n2].py + this.r.y);
        }
        this.inStartEdit = false;
        if (bl) {
            this.ptsIndex = null;
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.xaxis.isVertical;
        if (this.useRubberBand) {
            this.chartArea.drawRubberBand(this.end, this.start);
        } else {
            this.chartArea.drawRubberLine(this.start, this.end);
        }
        if (bl) {
            this.end.x = n;
        } else {
            this.end.y = n2;
        }
        if (this.useRubberBand) {
            this.chartArea.drawRubberBand(this.end, this.start);
            return;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        if (this.useRubberBand) {
            this.chartArea.drawRubberBand(this.end, this.start);
        } else {
            this.chartArea.drawRubberLine(this.start, this.end);
        }
        if (jCDataIndex.dataView.xaxis.isVertical) {
            return n - this.r.x;
        }
        return n2 - this.r.y;
    }

    int getNumSeriesPerData() {
        return 4;
    }
}

