/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.HTMLSaveDriver;
import jclass.chart.JCChartBundle;
import jclass.chart.JCChartConverter;
import jclass.util.JCUtilConverter;

class ChartDataViewHTMLSave {
    ChartDataView source;

    ChartDataViewHTMLSave(ChartDataView chartDataView) {
        this.source = chartDataView;
    }

    void save(String string, HTMLSaveDriver hTMLSaveDriver) {
        ChartDataView chartDataView = new ChartDataView();
        JCChartConverter jCChartConverter = new JCChartConverter();
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".chartType", JCUtilConverter.fromEnum(chartDataView.chartType, ChartDataView.chartType_strings, ChartDataView.chartType_values), JCUtilConverter.fromEnum(this.source.chartType, ChartDataView.chartType_strings, ChartDataView.chartType_values));
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".isShowingInLegend", chartDataView.isShowingInLegend, this.source.isShowingInLegend);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".isShowing", chartDataView.isShowing, this.source.isShowing);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".autoLabel", chartDataView.autoLabel, this.source.autoLabel);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".bufferPlotData", chartDataView.bufferPlotData, this.source.bufferPlotData);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".fastUpdate", chartDataView.fastUpdate, this.source.fastUpdate);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".drawFrontPlane", chartDataView.drawFrontPlane, this.source.drawFrontPlane);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".outlineColor", chartDataView.outlineColor, this.source.outlineColor);
        int n = 0;
        while (n < this.source.series.size()) {
            this.source.getSeries(n).saveParams(String.valueOf(string) + ".series" + (n + 1), hTMLSaveDriver);
            ++n;
        }
        if (!this.source.xaxis.name.equals(JCChartBundle.string("jclass.chart.Key28"))) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".xaxis", jCChartConverter.toAxisName(this.source.getParent(), this.source.xaxis.name, "xaxis"));
        }
        if (!this.source.yaxis.name.equals(JCChartBundle.string("jclass.chart.Key29"))) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".yaxis", jCChartConverter.toAxisName(this.source.getParent(), this.source.yaxis.name, "yaxis"));
        }
        if (chartDataView.isInverted != this.source.isInverted) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".isInverted", this.source.isInverted);
        }
        switch (this.source.chartType) {
            case 5: {
                this.source.getHiloChartFormat().saveParams(String.valueOf(string) + ".Hilo", hTMLSaveDriver);
                break;
            }
            case 6: {
                this.source.getHLOCChartFormat().saveParams(String.valueOf(string) + ".HLOC", hTMLSaveDriver);
                break;
            }
            case 7: {
                this.source.getCandleChartFormat().saveParams(String.valueOf(string) + ".Candle", hTMLSaveDriver);
                break;
            }
            case 9: {
                this.source.getBarChartFormat().saveParams(String.valueOf(string) + ".Bar", hTMLSaveDriver);
                break;
            }
            case 11: {
                this.source.getPieChartFormat().saveParams(String.valueOf(string) + ".Pie", hTMLSaveDriver);
                break;
            }
        }
        hTMLSaveDriver.writeParam(string, "\r\n " + this.getDataString());
    }

    String getDataString() {
        int n;
        boolean bl = false;
        String string = "\r\n ";
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.source.datatype;
        ChartDataViewSeries[] chartDataViewSeriesArray = this.source.getSeries();
        if (chartDataViewSeriesArray == null) {
            return null;
        }
        int n3 = chartDataViewSeriesArray.length;
        if (n3 == 0) {
            return null;
        }
        int n4 = 0;
        String string2 = this.source.getName();
        string2 = string2 == null ? "" : (string2.equals("") ? "''" : "'" + string2 + "' ");
        if (n2 == 0) {
            n4 = chartDataViewSeriesArray[0].getY().length;
            stringBuffer.append("ARRAY " + string2 + " " + n3 + " " + n4 + string);
        } else if (n2 == 1) {
            n = 0;
            while (n < n3) {
                int n5 = chartDataViewSeriesArray[n].getY().length;
                if (n5 > n4) {
                    n4 = n5;
                }
                ++n;
            }
            stringBuffer.append("GENERAL " + string2 + n3 + " " + n4 + string);
        }
        String[] stringArray = this.source.getPointLabels();
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                stringBuffer.append("'" + stringArray[n] + "' ");
                ++n;
            }
            stringBuffer.append(string);
        }
        n = 0;
        while (n < n3) {
            ChartDataViewSeries chartDataViewSeries = this.source.getSeries(n);
            double[] dArray = chartDataViewSeries.getY();
            string2 = chartDataViewSeries.getName();
            string2 = string2 == null || string2.equals("") ? "" : "'" + string2 + "' ";
            if (n2 == 1) {
                stringBuffer.append(String.valueOf(string2) + dArray.length + string);
                if (bl) {
                    stringBuffer.append(" # " + JCChartBundle.string("jclass.chart.Key129") + " " + n + ": " + dArray.length + " " + JCChartBundle.string("jclass.chart.Key121") + "\r\n ");
                }
            }
            if (n2 == 1 || n2 == 0 && n == 0) {
                double[] dArray2 = chartDataViewSeries.getX();
                if (bl) {
                    stringBuffer.append("# X " + JCChartBundle.string("jclass.chart.Key146") + "\r\n ");
                }
                if (n2 == 0) {
                    stringBuffer.append(string2);
                }
                int n6 = 0;
                while (n6 < dArray2.length) {
                    stringBuffer.append(dArray2[n6] + " ");
                    ++n6;
                }
                stringBuffer.append(string);
            }
            if (bl) {
                stringBuffer.append("# " + JCChartBundle.string("jclass.chart.Key129") + " " + n + " Y " + JCChartBundle.string("jclass.chart.Key146") + "\r\n ");
            }
            if (n2 == 0) {
                stringBuffer.append(string2);
            }
            int n7 = 0;
            while (n7 < dArray.length) {
                if (dArray[n7] == this.source.holeValue) {
                    stringBuffer.append("HOLE ");
                } else {
                    stringBuffer.append(dArray[n7] + " ");
                }
                ++n7;
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }
}

