/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.StringTokenizer;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCContainer;
import jclass.bwt.JCTextField;
import jclass.chart.JCChartBundle;
import jclass.chart.JCChartUtil;
import jclass.chart.View3DCube;

public class View3DEditor
extends JCContainer
implements PropertyEditor,
JCActionListener {
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected JCTextField textDepth;
    protected JCTextField textElevation;
    protected JCTextField textRotation;
    protected Checkbox cbDepth;
    protected View3DCube cube;
    String selectedView;

    public View3DEditor() {
        this.init();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.setInsets(new Insets(2, 2, 2, 2));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 6));
        this.textDepth = new JCTextField("", 5);
        this.textElevation = new JCTextField("", 5);
        this.textRotation = new JCTextField("", 5);
        this.textDepth.addActionListener(this);
        this.textElevation.addActionListener(this);
        this.textRotation.addActionListener(this);
        panel.add(new Label(JCChartBundle.string("jclass.chart.Key158")));
        panel.add(this.textDepth);
        panel.add(new Label(JCChartBundle.string("jclass.chart.Key159")));
        panel.add(this.textElevation);
        panel.add(new Label(JCChartBundle.string("jclass.chart.Key160")));
        panel.add(this.textRotation);
        this.add("North", panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(2, 1));
        this.cbDepth = new Checkbox(JCChartBundle.string("jclass.chart.Key161"), null, false);
        if (this.cbDepth != null) {
            panel2.add(this.cbDepth);
        }
        panel2.add(new Label(JCChartBundle.string("jclass.chart.Key162")));
        this.add("South", panel2);
        this.cube = new View3DCube(this);
        this.add(this.cube);
    }

    public void setValue(Object object) {
        this.setSelectedValue((String)object);
    }

    protected void setSelectedValue(String string) {
        this.selectedView = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        while (n < 3) {
            String string2 = null;
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            switch (n) {
                case 0: {
                    this.textDepth.setText(string2);
                    break;
                }
                case 1: {
                    this.textElevation.setText(string2);
                    break;
                }
                case 2: {
                    this.textRotation.setText(string2);
                    break;
                }
            }
            ++n;
        }
        this.support.firePropertyChange("", null, null);
        this.cube.repaint();
    }

    protected void setSelectedValue(boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = JCChartUtil.clamp(Integer.parseInt(this.textDepth.getText()), 0, 500);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        try {
            n2 = JCChartUtil.clamp(Integer.parseInt(this.textElevation.getText()), -45, 45);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
        }
        try {
            n3 = JCChartUtil.clamp(Integer.parseInt(this.textRotation.getText()), -45, 45);
        }
        catch (NumberFormatException numberFormatException) {
            n3 = 0;
        }
        if (bl) {
            if (n > 0 && n2 == 0 && n3 == 0) {
                n2 = 5;
                n3 = 5;
            }
            if (n == 0 && (n2 != 0 || n3 != 0)) {
                n = 5;
            }
        }
        String string = Integer.toString(n) + "," + Integer.toString(n2) + "," + Integer.toString(n3);
        this.setSelectedValue(string);
    }

    public Object getValue() {
        return this.selectedView;
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    public String getAsText() {
        return null;
    }

    public String[] getTags() {
        return null;
    }

    public String getJavaInitializationString() {
        return "\"" + this.selectedView + "\"";
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = JCChartBundle.string("jclass.chart.Key163");
        if (string == null) {
            string = new String("");
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - n);
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Dimension preferredSize() {
        return new Dimension(400, 300);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() instanceof JCTextField) {
            JCTextField jCTextField = (JCTextField)jCActionEvent.getSource();
            if (jCTextField == null) {
                return;
            }
            this.setSelectedValue(false);
        }
    }
}

