/*
 * Decompiled with CFR 0.152.
 */
package cern.lhcias.csgui.Drivers;

import cern.lhcias.csgui.Utils.MyUtils;
import cern.lhcias.csgui.interfaces.AlarmListener;
import cern.lhcias.csgui.interfaces.DataServer;
import cern.lhcias.csgui.interfaces.TagArrays;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

public class SocketDriver
implements Runnable,
DataServer {
    public static final String driverType = "Socket";
    public static final String ONCHANGE = "OnChange";
    public static final String POLLING = "Polling";
    private static final int ONCHANGETYPE = 0;
    private static final int POLLINGTYPE = 1;
    private static final int CHECKDELAY = 4000;
    private int type = 0;
    protected Socket serverConn;
    String host;
    int port;
    long poolingInterval = -1L;
    boolean mask = false;
    String user;
    String password;
    private Thread dataThread;
    private TagArrays c;
    private String processName = "";
    private boolean tagsSubscription = true;
    boolean activeState = false;
    Vector names;
    Thread checkThread;
    checkSubmit Check;

    public void addAlarmListener(AlarmListener alarmListener) {
    }

    public void removeAlarmListener(AlarmListener alarmListener) {
    }

    public SocketDriver() {
    }

    public SocketDriver(String string, int n) {
        this.host = string;
        this.port = n;
    }

    public SocketDriver(String string, String string2) {
        this.host = string;
        this.port = 3000;
        try {
            this.port = Integer.parseInt(string2);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    public void setTagArrays(TagArrays tagArrays) {
        this.c = tagArrays;
    }

    public void setReadHost(String string) {
        this.host = string;
    }

    public String getReadHost() {
        return this.host;
    }

    public void setReadPort(int n) {
        this.port = n;
    }

    public int getReadPort() {
        return this.port;
    }

    public void setWriteHost(String string) {
    }

    public String getWriteHost() {
        return this.host;
    }

    public void setWritePort(int n) {
    }

    public int getWritePort() {
        return this.port;
    }

    public void setPoolingInterval(long l) {
        this.poolingInterval = l;
    }

    public long getPoolingInterval() {
        return this.poolingInterval;
    }

    public void setType(String string) {
        if (string.equalsIgnoreCase(ONCHANGE)) {
            this.type = 0;
        }
        if (string.equalsIgnoreCase(POLLING)) {
            this.type = 1;
        }
    }

    public String getType() {
        if (this.type == 0) {
            return ONCHANGE;
        }
        return POLLING;
    }

    public void setMask(boolean bl) {
        this.mask = bl;
    }

    public boolean getMask() {
        return this.mask;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setParameter(String string, String string2) {
    }

    public String getParameter(String string) {
        return "";
    }

    public boolean isActive() {
        return this.serverConn != null;
    }

    public void setTagsSubscription(boolean bl) {
        this.tagsSubscription = bl;
    }

    public boolean getTagsSubscription() {
        return this.tagsSubscription;
    }

    public void setProcessName(String string) {
        this.processName = string;
    }

    public String getProcessName() {
        return this.processName;
    }

    public boolean doYouImplement(String string) {
        return string.equalsIgnoreCase(driverType);
    }

    public Vector getPossibleProtocols() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(driverType);
        return vector;
    }

    public String getDriverProtocol() {
        return driverType;
    }

    public void setConfig(String string) {
        string = string.trim();
        try {
            this.setProcessName(string.substring(0, string.indexOf(59)));
            string = string.substring(string.indexOf(59) + 1);
            string = string.substring(string.indexOf(59) + 1);
            this.setType(string.substring(0, string.indexOf(59)));
            string = string.substring(string.indexOf(59) + 1);
            this.setReadHost(string.substring(0, string.indexOf(59)));
            string = string.substring(string.indexOf(59) + 1);
            this.setReadPort(new Integer(string.substring(0, string.indexOf(59))));
            string = string.substring(string.indexOf(59) + 1);
            this.setWriteHost(string.substring(0, string.indexOf(59)));
            string = string.substring(string.indexOf(59) + 1);
            this.setWritePort(new Integer(string.substring(0, string.indexOf(59))));
            string = string.substring(string.indexOf(59) + 1);
            this.setPoolingInterval(new Double(string.substring(0, string.indexOf(59))).longValue());
            string = string.substring(string.indexOf(59) + 1);
            this.setTagsSubscription(new Boolean(string.substring(0, string.indexOf(59))));
            string = string.substring(string.indexOf(59) + 1);
            Vector vector = MyUtils.getPropertiesinConfig(string, ';');
            int n = 0;
            while (n < vector.size() - 1) {
                this.setParameter((String)vector.elementAt(n), (String)vector.elementAt(n + 1));
                n += 2;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public String toString() {
        String string = String.valueOf(this.processName) + ";" + this.getDriverProtocol() + ";" + this.getType() + ";" + this.getReadHost() + ";" + this.getReadPort() + ";" + this.getWriteHost() + ";" + this.getWritePort() + ";" + this.getPoolingInterval() + ";" + this.getTagsSubscription();
        return string;
    }

    public void enable() {
        if (this.host != null && this.port > 0) {
            if (this.serverConn == null) {
                this.setup(this.host, this.port);
            }
            this.dataThread = new Thread(this);
            this.dataThread.start();
        }
    }

    public void open() {
        if (this.host != null && this.port > 0) {
            this.setup(this.host, this.port);
        }
    }

    void stopThread() {
        if (this.dataThread != null && this.dataThread.isAlive()) {
            this.dataThread.stop();
            this.dataThread = null;
        }
        if (this.checkThread != null && this.checkThread.isAlive()) {
            this.checkThread.stop();
        }
    }

    public void setup(String string, int n) {
        this.stopThread();
        try {
            this.serverConn = null;
            this.serverConn = new Socket(string, n);
            return;
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Bad host name given.");
            return;
        }
        catch (IOException iOException) {
            System.out.println("SocketDriver: " + iOException);
            return;
        }
    }

    public void disable() {
        this.close();
    }

    public void closeConnection() {
        this.close();
    }

    public void close() {
        if (this.type == 0 && this.dataThread != null && this.dataThread.isAlive()) {
            this.sendCommandNoReturn("UNS");
        }
        try {
            if (this.serverConn != null) {
                this.serverConn.close();
            }
        }
        catch (IOException iOException) {
            System.out.println("SocketDriver: " + iOException);
        }
        this.serverConn = null;
        this.stopThread();
    }

    private void closeFromThread() {
        if (this.type == 0 && this.dataThread != null && this.dataThread.isAlive()) {
            this.sendCommandNoReturn("UNS");
        }
        try {
            if (this.serverConn != null) {
                this.serverConn.close();
            }
        }
        catch (IOException iOException) {
            System.out.println("SocketDriver: " + iOException);
        }
        this.serverConn = null;
        if (this.checkThread != null && this.checkThread.isAlive()) {
            this.checkThread.stop();
        }
    }

    public String sendCommand(String string) {
        if (this.mask) {
            return "";
        }
        if (this.serverConn == null) {
            this.open();
        }
        if (this.serverConn == null) {
            return "";
        }
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(this.serverConn.getOutputStream());
            dataOutputStream.writeBytes(String.valueOf(string) + "\r\n");
            if (!this.dataThread.isAlive() || this.type != 0) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.serverConn.getInputStream()));
                return bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            System.out.println("SocketDriver: " + iOException);
        }
        return "";
    }

    public void sendCommandNoReturn(String string) {
        if (!this.mask) {
            if (this.serverConn == null) {
                this.open();
            }
            if (this.serverConn == null) {
                return;
            }
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(this.serverConn.getOutputStream());
                dataOutputStream.writeBytes(String.valueOf(string) + "\r\n");
                return;
            }
            catch (IOException iOException) {
                System.out.println("SocketDriver: " + iOException);
                return;
            }
        }
    }

    public void write(String string, String string2) {
        if (!this.mask) {
            this.sendCommandNoReturn("SET " + string + "=" + string2);
        }
    }

    public String read(String string) {
        if (this.mask) {
            return "";
        }
        String string2 = this.sendCommand("GET " + string);
        if (string2.length() < 1) {
            return "";
        }
        if (string2 == null) {
            System.out.println("SocketDriver : null returned string ");
            return "";
        }
        int n = string2.indexOf("=");
        if (n < 1) {
            System.out.println("SocketDriver : bad returned string :" + string2);
            return "";
        }
        String string3 = string2.substring(0, n);
        if (!string3.equals(string)) {
            System.out.println("SocketDriver : Inconsistancy: asked for " + string + "an got:" + string2);
            return "";
        }
        return string2.substring(n + 1);
    }

    public boolean read(Vector vector) {
        if (this.mask) {
            return false;
        }
        if (!this.c.beforeRefreshData()) {
            return false;
        }
        String string = "GET ";
        int n = 0;
        while (n < vector.size()) {
            string = String.valueOf(string) + (String)vector.elementAt(n);
            if (n < vector.size() - 1) {
                string = String.valueOf(string) + ",";
            }
            ++n;
        }
        String string2 = this.sendCommand(string);
        if (!this.dataThread.isAlive() || this.type != 0) {
            this.update(string2);
            this.c.afterRefreshData();
        }
        return true;
    }

    public void read() {
        Vector vector;
        if (!this.mask && (vector = this.c.getRemoteTagNames(this)) != null && vector.size() > 0) {
            String string = "GET ";
            if (!this.c.beforeRefreshData()) {
                return;
            }
            int n = 0;
            while (n < vector.size()) {
                string = String.valueOf(string) + (String)vector.elementAt(n);
                if (n < vector.size() - 1) {
                    string = String.valueOf(string) + ",";
                }
                ++n;
            }
            this.update(this.sendCommand(string));
            this.c.afterRefreshData();
        }
    }

    public void sendSubscribeCommand() {
        if (!this.mask) {
            String string = "SUB ";
            this.names = this.c.getRemoteTagNames(this);
            int n = 0;
            while (n < this.names.size()) {
                string = String.valueOf(string) + (String)this.names.elementAt(n);
                if (n < this.names.size() - 1) {
                    string = String.valueOf(string) + ",";
                }
                ++n;
            }
            this.sendCommandNoReturn(string);
        }
    }

    void sendUnSubscribeCommand() {
        if (!this.mask) {
            this.sendCommandNoReturn("UNS");
            if (this.type == 0 && this.dataThread != null) {
                this.dataThread.stop();
                if (this.checkThread != null && this.checkThread.isAlive()) {
                    this.checkThread.stop();
                }
            }
        }
    }

    public boolean newTags() {
        Vector vector = this.c.getRemoteTagNames(this);
        if (vector.size() != this.names.size()) {
            return true;
        }
        int n = 0;
        while (n < vector.size()) {
            if (this.names.indexOf(vector.elementAt(n)) < 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void update(String string) {
        if (string == null) {
            System.out.println("SocketDriver : null returned string ");
            return;
        }
        Vector vector = MyUtils.getPropertiesinConfig(string, ',');
        int n = 0;
        while (n < vector.size() - 1) {
            this.c.updateValue((String)vector.elementAt(n), (String)vector.elementAt(n + 1));
            n += 2;
        }
    }

    public void run() {
        switch (this.type) {
            case 0: {
                try {
                    this.sendSubscribeCommand();
                    this.Check = new checkSubmit();
                    this.listen();
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            {
                this.read();
                try {
                    Thread.sleep(this.poolingInterval);
                }
                catch (Exception exception) {
                    return;
                }
                case 1: {
                    if (this.serverConn != null) continue;
                }
            }
        }
    }

    public void listen() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.serverConn.getInputStream()));
            while (this.serverConn != null) {
                String string = bufferedReader.readLine();
                if (this.mask) continue;
                this.update(string);
                this.c.afterRefreshData();
            }
        }
        catch (IOException iOException) {
            System.out.println("SimpleClient: " + iOException);
            this.closeFromThread();
        }
        if (this.checkThread != null && this.checkThread.isAlive()) {
            this.checkThread.stop();
        }
    }

    public synchronized void finalize() {
        System.out.println("SocketDriver: Closing down connection...");
        try {
            this.serverConn.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println("SocketDriver: " + iOException);
            return;
        }
    }

    static /* synthetic */ int access$0() {
        return 4000;
    }

    class checkSubmit
    implements Runnable {
        public checkSubmit() {
            SocketDriver.this = SocketDriver.this;
            SocketDriver.this.checkThread = new Thread(this);
            SocketDriver.this.checkThread.start();
        }

        public void run() {
            while (true) {
                if (SocketDriver.this.newTags()) {
                    SocketDriver.this.sendSubscribeCommand();
                }
                try {
                    Thread.sleep(4000L);
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
    }
}

