/*
 * Decompiled with CFR 0.152.
 */
package cern.lhcias.csgui.Services;

import cern.lhcias.csgui.Drivers.HTTPDriver;
import cern.lhcias.csgui.Drivers.SocketDriver;
import cern.lhcias.csgui.Utils.MyUtils;
import cern.lhcias.csgui.interfaces.DataServer;
import cern.lhcias.csgui.interfaces.TagArrays;
import java.util.Vector;

public class DataServerManager {
    static int nb_drivers = 3;
    static DataServer[] drivers = new DataServer[nb_drivers];
    static Vector aliases;
    Vector myDataServers = new Vector();
    DataServer currentDataServer;
    static boolean globalRunningStatus;

    public static void loadAlias(String string) {
        try {
            aliases = MyUtils.ReadRemoteValueFile(string);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public DataServer setNewDataServer(String string) {
        String string2 = string.substring(0, string.indexOf(59));
        String string3 = string.substring(string.indexOf(59) + 1);
        String string4 = string3.substring(0, string3.indexOf(59));
        DataServer dataServer = this.getDataServer(string2);
        if (dataServer != null) {
            this.currentDataServer = dataServer;
            return dataServer;
        }
        dataServer = DataServerManager.createDataServer(string4);
        if (dataServer != null) {
            dataServer.setConfig(string);
            this.myDataServers.addElement(dataServer);
            this.currentDataServer = dataServer;
        }
        return dataServer;
    }

    public DataServer setNewDataServer(String string, String string2, String string3, int n) {
        DataServer dataServer = this.getDataServer(string);
        if (dataServer != null) {
            this.currentDataServer = dataServer;
            return dataServer;
        }
        dataServer = DataServerManager.createDataServer(string2);
        if (dataServer != null) {
            dataServer.setProcessName(string);
            dataServer.setReadHost(string3);
            dataServer.setReadPort(n);
            this.myDataServers.addElement(dataServer);
            this.currentDataServer = dataServer;
        }
        return dataServer;
    }

    public DataServer setNewDataServer(String string, String string2, String string3, int n, TagArrays tagArrays, boolean bl, long l) {
        DataServer dataServer = this.getDataServer(string);
        if (dataServer != null) {
            this.currentDataServer = dataServer;
        } else {
            dataServer = DataServerManager.createDataServer(string2);
            if (dataServer != null) {
                dataServer.setProcessName(string);
                dataServer.setReadHost(string3);
                dataServer.setReadPort(n);
                this.myDataServers.addElement(dataServer);
                this.currentDataServer = dataServer;
            }
        }
        if (dataServer != null) {
            dataServer.setTagArrays(tagArrays);
            dataServer.setTagsSubscription(bl);
            dataServer.setPoolingInterval(l);
        }
        return dataServer;
    }

    public DataServer setNewDataServer(String string, String string2, String string3, int n, String string4, int n2, TagArrays tagArrays, boolean bl, long l) {
        DataServer dataServer = this.getDataServer(string);
        if (dataServer != null) {
            this.currentDataServer = dataServer;
        } else {
            dataServer = DataServerManager.createDataServer(string2);
            if (dataServer != null) {
                dataServer.setProcessName(string);
                dataServer.setReadHost(string3);
                dataServer.setReadPort(n);
                dataServer.setWriteHost(string4);
                dataServer.setWritePort(n2);
                this.myDataServers.addElement(dataServer);
                this.currentDataServer = dataServer;
            }
        }
        if (dataServer != null) {
            dataServer.setTagArrays(tagArrays);
            dataServer.setTagsSubscription(bl);
            dataServer.setPoolingInterval(l);
        }
        return dataServer;
    }

    public void setCurrentDataServer(DataServer dataServer) {
        if (dataServer != null) {
            this.currentDataServer = dataServer;
        }
    }

    public Vector getDataServers() {
        return this.myDataServers;
    }

    public void addDataServer(DataServer dataServer) {
        if (dataServer != null) {
            this.myDataServers.addElement(dataServer);
            this.currentDataServer = dataServer;
        }
    }

    public DataServer getDataServer(String string) {
        int n = 0;
        while (n < this.myDataServers.size()) {
            if (((DataServer)this.myDataServers.elementAt(n)).getProcessName().equals(string)) {
                return (DataServer)this.myDataServers.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    public DataServer getCurrentDataServer() {
        return this.currentDataServer;
    }

    public void startAllDataServers() {
        int n = 0;
        while (n < this.myDataServers.size()) {
            ((DataServer)this.myDataServers.elementAt(n)).enable();
            ++n;
        }
        globalRunningStatus = true;
    }

    public void stopAllDataServers() {
        int n = 0;
        while (n < this.myDataServers.size()) {
            ((DataServer)this.myDataServers.elementAt(n)).disable();
            ++n;
        }
        globalRunningStatus = false;
    }

    public static boolean getGlobalRunningStatus() {
        return globalRunningStatus;
    }

    public static void setup() {
        DataServerManager.drivers[0] = new HTTPDriver();
        DataServerManager.drivers[1] = new MD2SDriver();
        DataServerManager.drivers[2] = new SocketDriver();
    }

    public static Vector getPossibleProtocols() {
        Vector vector = new Vector();
        int n = 0;
        while (n < nb_drivers) {
            Vector vector2 = drivers[n].getPossibleProtocols();
            int n2 = 0;
            while (n2 < vector2.size()) {
                vector.addElement(vector2.elementAt(n2));
                ++n2;
            }
            ++n;
        }
        return vector;
    }

    public static boolean isProtocolImplemented(String string) {
        int n = 0;
        while (n < nb_drivers) {
            if (drivers[n].doYouImplement(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static Object loadClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Class not found: " + classNotFoundException);
        }
        if (clazz != null) {
            try {
                return clazz.newInstance();
            }
            catch (Exception exception) {
                System.out.println("FrameMain: error: " + exception);
            }
        }
        return null;
    }

    public static DataServer createDataServer(String string) {
        if (aliases != null) {
            string = MyUtils.getAlias(string, aliases);
        }
        int n = 0;
        while (n < nb_drivers) {
            if (drivers[n].doYouImplement(string)) {
                switch (n) {
                    case 0: {
                        HTTPDriver hTTPDriver = new HTTPDriver();
                        return hTTPDriver;
                    }
                    case 1: {
                        MD2SDriver mD2SDriver = new MD2SDriver();
                        return mD2SDriver;
                    }
                    case 2: {
                        SocketDriver socketDriver = new SocketDriver();
                        return socketDriver;
                    }
                }
            }
            ++n;
        }
        return (DataServer)DataServerManager.loadClass(string);
    }
}

