/*
 * Decompiled with CFR 0.152.
 */
package cern.lhcias.csgui.TagsView;

import cern.lhcias.csgui.Events.AlarmAdapter;
import cern.lhcias.csgui.Events.OpenViewAdapter;
import cern.lhcias.csgui.Events.TagChangeAdapter;
import cern.lhcias.csgui.Events.TagChangeEvent;
import cern.lhcias.csgui.Events.TagClickedAdapter;
import cern.lhcias.csgui.Events.TagClickedEvent;
import cern.lhcias.csgui.Services.configurationMgr;
import cern.lhcias.csgui.Utils.MyUtils;
import cern.lhcias.csgui.interfaces.AlarmListener;
import cern.lhcias.csgui.interfaces.OpenViewListener;
import cern.lhcias.csgui.interfaces.TagArrays;
import cern.lhcias.csgui.interfaces.TagClickedListener;
import cern.lhcias.csgui.interfaces.TagsView;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;

abstract class GraphView
extends Canvas
implements TagsView {
    public static final int MAX_TAG = 18;
    boolean grid_on = false;
    Font textFont;
    Font legendFont;
    TagArrays tc;
    TagChangeAdapter tadapter;
    int x0;
    int y0;
    int canvas_width;
    int canvas_height;
    boolean[] Tag_in_group = new boolean[1];
    long last_date;
    int nb_tag;
    int clicked_tag = -1;
    Vector names;
    Vector myListeners;

    public synchronized void addTagClickedListener(TagClickedListener tagClickedListener) {
        this.myListeners.addElement(tagClickedListener);
    }

    public synchronized void removeTagClickedListener(TagClickedListener tagClickedListener) {
        this.myListeners.removeElement(tagClickedListener);
    }

    void fireTagClickedEvent(String string) {
        TagClickedEvent tagClickedEvent = new TagClickedEvent(this);
        tagClickedEvent.setTagName(string);
        int n = 0;
        while (n < this.myListeners.size()) {
            ((TagClickedListener)this.myListeners.elementAt(n)).receiveTagClicked(tagClickedEvent);
            ++n;
        }
    }

    public void addOpenViewListener(OpenViewListener openViewListener) {
    }

    public void removeOpenViewListener(OpenViewListener openViewListener) {
    }

    public void addAlarmListener(AlarmListener alarmListener) {
    }

    public void removeAlarmListener(AlarmListener alarmListener) {
    }

    abstract void local_setup();

    public void instantiate(TagArrays tagArrays, String string, TagChangeAdapter tagChangeAdapter, TagClickedAdapter tagClickedAdapter, OpenViewAdapter openViewAdapter, configurationMgr configurationMgr2, AlarmAdapter alarmAdapter) {
        this.tc = tagArrays;
        this.tadapter = tagChangeAdapter;
        this.local_setup();
        this.textFont = new Font("Helvetica", 1, 14);
        this.legendFont = new Font("Helvetica", 0, 14);
        this.names = new Vector();
        this.myListeners = new Vector();
        this.clicked_tag = -1;
        this.last_date = 0L;
        this.nb_tag = 0;
    }

    public void setProperty(String string, String string2, String string3) {
    }

    public void removeTag(String string) {
    }

    public void removeTag(Vector vector) {
    }

    public void removeTag(TagsView tagsView) {
    }

    public void addTag(String string) {
        this.repaint();
    }

    public void addTag(Vector vector) {
        this.repaint();
    }

    public void addTag(TagsView tagsView) {
        this.repaint();
    }

    public Vector getTagNames() {
        return this.names;
    }

    public Vector getLocalTagNames() {
        return this.getTagNames();
    }

    public Dimension getPreferredSize() {
        return new Dimension(250, 100);
    }

    void group_draw_vertical_ticks(Graphics graphics, int n, int n2, int n3, int n4, int n5, double d, double d2, int n6) {
        Font font = graphics.getFont();
        graphics.setFont(this.textFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        double d3 = d2 - d;
        double d4 = new Double(n2);
        double d5 = new Double(n4);
        double d6 = new Double(n5);
        int n7 = 0;
        while (n7 <= n5) {
            double d7 = new Double(n7);
            double d8 = d + d7 * d3 / new Double(n5);
            int n8 = new Double(d4 + d5 - d7 * (d5 / d6)).intValue();
            if (this.grid_on) {
                graphics.drawLine(n - n6, n8, n + n3, n8);
            } else {
                graphics.drawLine(n - n6, n8, n, n8);
            }
            if (n7 != 0) {
                graphics.drawString(String.valueOf(d8), 1, n8 + fontMetrics.getAscent() / 2);
            } else {
                graphics.drawString(String.valueOf(d8), 1, n8);
            }
            ++n7;
        }
        graphics.setFont(font);
    }

    void fill_name_array() {
        Vector vector = this.tc.getTagNames();
        int n = vector.size();
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            boolean bl = true;
            while (n3 < this.nb_tag) {
                if (((String)vector.elementAt(n2)).equals(this.names.elementAt(n3))) {
                    blArray[n2] = this.Tag_in_group[n3];
                    bl = false;
                    break;
                }
                ++n3;
            }
            if (bl) {
                blArray[n2] = true;
            }
            ++n2;
        }
        this.nb_tag = n;
        this.names = vector;
        this.Tag_in_group = blArray;
    }

    void group_paint_legend(Graphics graphics) {
        int n = this.canvas_height - 2;
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        graphics.setColor(Color.black);
        int n2 = this.canvas_width - 100 - 2;
        int n3 = 1;
        graphics.drawRect(n2, n3, 100, n);
        graphics.setFont(this.legendFont);
        long l = this.tc.getDefinitionDate();
        if (l > this.last_date) {
            this.fill_name_array();
            this.last_date = l;
        }
        int n4 = 0;
        while (n4 < this.nb_tag && n4 < 18) {
            graphics.setColor(MyUtils.get_indexed_color(n4));
            if (this.Tag_in_group[n4]) {
                graphics.fillRect(n2 + 7, n3 + 10 + 15 * n4, 10, 10);
            } else {
                graphics.drawRect(n2 + 7, n3 + 10 + 15 * n4, 10, 10);
            }
            graphics.drawString((String)this.names.elementAt(n4), n2 + 20, n3 + 20 + 15 * n4);
            ++n4;
        }
        graphics.setColor(color);
        graphics.setFont(font);
    }

    int group_active_number() {
        int n = 0;
        int n2 = 0;
        while (n < this.nb_tag && n < 18) {
            if (this.Tag_in_group[n]) {
                ++n2;
            }
            ++n;
        }
        return n2;
    }

    void setLimits() {
        Rectangle rectangle = this.getBounds();
        this.x0 = 0;
        this.y0 = 0;
        this.canvas_width = rectangle.width;
        this.canvas_height = rectangle.height;
    }

    double[] group_get_minmax() {
        double d;
        double[] dArray = new double[2];
        if (this.nb_tag < 1) {
            dArray[0] = 0.0;
            dArray[1] = 100.0;
            return dArray;
        }
        double[] dArray2 = new double[4];
        boolean bl = false;
        double d2 = 0.0;
        double d3 = 100.0;
        int n = 0;
        while (n < this.nb_tag && n < 18) {
            if (this.Tag_in_group[n]) {
                dArray2 = this.tc.getTag((String)this.tc.getTagNames().elementAt(n)).getLimits();
                if (bl) {
                    if (dArray2[0] < d2) {
                        d2 = dArray2[0];
                    }
                    if (dArray2[1] > d3) {
                        d3 = dArray2[1];
                    }
                } else {
                    d2 = dArray2[0];
                    d3 = dArray2[1];
                    bl = true;
                }
            }
            ++n;
        }
        if (d3 < d2) {
            double d4 = d3;
            d3 = d2;
            d2 = d4;
        }
        if (d3 * d2 < 0.0) {
            d3 = Math.max(d3, Math.abs(d2));
            d2 = -1.0 * d3;
        }
        if ((d = d3 - d2) == 0.0) {
            d = 1.0;
        }
        double d5 = Math.rint(Math.log(d) / Math.log(10.0));
        double d6 = Math.floor(d2 / Math.pow(10.0, d5)) * Math.pow(10.0, d5);
        double d7 = Math.ceil(d3 / Math.pow(10.0, d5)) * Math.pow(10.0, d5);
        dArray[0] = d6;
        dArray[1] = d7;
        return dArray;
    }

    int getComponentIndex(int n, int n2) {
        int n3 = -1;
        if (n < this.canvas_width - 95) {
            return -1;
        }
        n3 = (n2 - 11) / 15;
        if (n3 >= this.nb_tag) {
            return -1;
        }
        return n3;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.clicked_tag = this.getComponentIndex(n, n2);
        if (this.clicked_tag > -1) {
            this.fireTagClickedEvent((String)this.names.elementAt(this.clicked_tag));
        }
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        int n3 = this.getComponentIndex(n, n2);
        if (this.clicked_tag > -1 && this.clicked_tag == n3 && n < this.canvas_width - 84) {
            this.Tag_in_group[n3] = !this.Tag_in_group[n3];
            this.repaint();
            return false;
        }
        if (n < this.canvas_width - 95) {
            this.grid_on = !this.grid_on;
        }
        this.repaint();
        return true;
    }

    public void receiveTagChange(TagChangeEvent tagChangeEvent) {
        this.repaint();
    }

    public int getComponentNb() {
        return 0;
    }

    public Vector getComponentsList() {
        return null;
    }

    GraphView() {
    }

    public abstract void setConfig(String var1);

    public abstract String getType();

    public abstract Vector getPossibleTypes();

    public abstract boolean doYouImplement(String var1);
}

