/*
 * Decompiled with CFR 0.152.
 */
package cern.lhcias.csgui.rtdb;

import cern.lhcias.csgui.Events.AlarmEvent;
import cern.lhcias.csgui.Events.TagChangeEvent;
import cern.lhcias.csgui.Services.DataServerManager;
import cern.lhcias.csgui.interfaces.AlarmListener;
import cern.lhcias.csgui.interfaces.DataServer;
import cern.lhcias.csgui.interfaces.TagArrays;
import cern.lhcias.csgui.interfaces.TagChangeListener;
import cern.lhcias.csgui.rtdb.Tag;
import cern.lhcias.csgui.rtdb.Trend;
import java.util.Date;
import java.util.Vector;

public class TagContainer
implements TagArrays,
Runnable {
    private int nb_tag;
    Vector tag = new Vector();
    private Vector myListeners;
    TagChangeEvent tagevent;
    private long definitionDate;
    private DataServerManager ta;
    Vector myAlarmListeners = new Vector();

    public TagContainer() {
        this.myListeners = new Vector();
    }

    public synchronized void addTagChangeListener(TagChangeListener tagChangeListener) {
        this.myListeners.addElement(tagChangeListener);
    }

    public synchronized void removeTagChangeListener(TagChangeListener tagChangeListener) {
        this.myListeners.removeElement(tagChangeListener);
    }

    public void run() {
        if (this.tagevent != null) {
            int n = 0;
            while (n < this.myListeners.size()) {
                ((TagChangeListener)this.myListeners.elementAt(n)).receiveTagChange(this.tagevent);
                ++n;
            }
        }
    }

    void fireTagChangeEvent() {
        new Thread(this).start();
    }

    void fireTagChangeEvent(String string) {
        this.tagevent = new TagChangeEvent(this);
        this.tagevent.addTag(string);
        this.fireTagChangeEvent();
    }

    void fireTagChangeEvent_AllTags() {
        this.tagevent = new TagChangeEvent(this);
        int n = 0;
        while (n < this.nb_tag) {
            this.tagevent.addTag(((Tag)this.tag.elementAt(n)).getTagName());
            ++n;
        }
        this.fireTagChangeEvent();
    }

    public synchronized void addAlarmListener(AlarmListener alarmListener) {
        this.myAlarmListeners.addElement(alarmListener);
    }

    public synchronized void removeAlarmListener(AlarmListener alarmListener) {
        this.myAlarmListeners.removeElement(alarmListener);
    }

    void fireAlarmEvent(String string, String string2, long l) {
        AlarmEvent alarmEvent = new AlarmEvent(this, string, string2, l);
        int n = 0;
        while (n < this.myAlarmListeners.size()) {
            ((AlarmListener)this.myAlarmListeners.elementAt(n)).receiveAlarm(alarmEvent);
            ++n;
        }
    }

    public boolean beforeRefreshData() {
        this.setAllAcquisitionError();
        this.tagevent = new TagChangeEvent(this);
        return true;
    }

    public boolean onRefreshError(String string) {
        System.out.println(String.valueOf(string) + "\n");
        return true;
    }

    public boolean afterRefreshData() {
        this.fireTagChangeEvent();
        if (this.AcquisitionError()) {
            System.out.println("Load Error: " + this.getNamesOfTagsOnError() + "\n");
        }
        return true;
    }

    public void setDataServerManager(DataServerManager dataServerManager) {
        this.ta = dataServerManager;
    }

    private boolean insideLimits(Tag tag) {
        double[] dArray;
        double d;
        return !tag.isValid() || !((d = tag.doubleValue()) < (dArray = tag.getLimits())[2]) && !(d > dArray[3]);
    }

    public void setValue(String string, String string2) {
        if (string.indexOf(46) > -1) {
            this.setTagProperty(string, string2);
            return;
        }
        int n = 0;
        int n2 = 0;
        if (this.get_tag_index(string) == -1) {
            this.addTag(string);
        }
        while (n >= 0) {
            n = this.get_tag_index(string, n2);
            if (n >= 0) {
                ((Tag)this.tag.elementAt(n)).setValue(string2);
                this.tagevent = new TagChangeEvent(this);
                this.tagevent.addTag(string);
                this.fireTagChangeEvent();
                if (!this.insideLimits((Tag)this.tag.elementAt(n))) {
                    this.fireAlarmEvent("tag " + string + " is outside limits", "[TagContainer]", new Date().getTime());
                }
                try {
                    if (((Tag)this.tag.elementAt(n)).isRemote() && n2 == 0) {
                        DataServer dataServer = ((Tag)this.tag.elementAt(n)).getDataServer();
                        dataServer.write(string, string2);
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }

    public void setValue(String string, String string2, long l) {
        if (string.indexOf(46) > -1) {
            this.setTagProperty(string, string2);
            return;
        }
        int n = 0;
        int n2 = 0;
        if (this.get_tag_index(string) == -1) {
            this.addTag(string);
        }
        while (n >= 0) {
            n = this.get_tag_index(string, n2);
            if (n >= 0) {
                ((Tag)this.tag.elementAt(n)).setValue(string2, l);
                if (!this.insideLimits((Tag)this.tag.elementAt(n))) {
                    this.fireAlarmEvent("tag " + string + " is outside limits", "[TagContainer]", l);
                }
                if (((Tag)this.tag.elementAt(n)).isRemote() && n2 == 0) {
                    DataServer dataServer = ((Tag)this.tag.elementAt(n)).getDataServer();
                    dataServer.write(string, string2);
                }
                this.tagevent = new TagChangeEvent(this);
                this.tagevent.addTag(string);
                this.fireTagChangeEvent();
            }
            ++n2;
        }
    }

    public void setTagProperty(String string, String string2) {
        try {
            Tag tag;
            String string3 = string.substring(0, string.indexOf(46));
            String string4 = string.substring(string.indexOf(46) + 1);
            if (string3 != null && string4 != null && (tag = this.getTag(string3)) != null) {
                tag.setProperty(string4, string2);
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void updateValue(String string, String string2) {
        if (string.indexOf(46) > -1) {
            this.setTagProperty(string, string2);
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n >= 0) {
            n = this.get_tag_index(string, n2);
            if (n >= 0) {
                ((Tag)this.tag.elementAt(n)).setValue(string2);
                if (!this.insideLimits((Tag)this.tag.elementAt(n))) {
                    this.fireAlarmEvent("tag " + string + " is outside limits", "[TagContainer]", new Date().getTime());
                }
                this.tagevent.addTag(string);
            }
            ++n2;
        }
    }

    public void updateInvalidValue(String string) {
        int n = 0;
        int n2 = 0;
        while (n >= 0) {
            n = this.get_tag_index(string, n2);
            if (n >= 0) {
                ((Tag)this.tag.elementAt(n)).setInvalidValue();
                this.tagevent.addTag(string);
            }
            ++n2;
        }
    }

    public void updateValue(String string, String string2, long l) {
        if (string.indexOf(46) > -1) {
            this.setTagProperty(string, string2);
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n >= 0) {
            n = this.get_tag_index(string, n2);
            if (n >= 0) {
                ((Tag)this.tag.elementAt(n)).setValue(string2, l);
                if (!this.insideLimits((Tag)this.tag.elementAt(n))) {
                    this.fireAlarmEvent("tag " + string + " is outside limits", "[TagContainer]", l);
                }
                this.tagevent.addTag(string);
            }
            ++n2;
        }
    }

    public void updateInvalidValue(String string, long l) {
        int n = 0;
        int n2 = 0;
        while (n >= 0) {
            n = this.get_tag_index(string, n2);
            if (n >= 0) {
                ((Tag)this.tag.elementAt(n)).setInvalidValue(l);
                this.tagevent.addTag(string);
            }
            ++n2;
        }
    }

    public void addTag(String string) {
        if (this.get_tag_index(string) < 0) {
            this.tag.addElement(new Tag(string));
            ++this.nb_tag;
            this.definitionDate = new Date().getTime();
            this.fireTagChangeEvent(string);
        }
    }

    public Tag addTagWithoutEvent(String string) {
        if (this.get_tag_index(string) < 0) {
            Tag tag = new Tag(string);
            this.tag.addElement(tag);
            ++this.nb_tag;
            this.definitionDate = new Date().getTime();
            return tag;
        }
        return this.getTag(string);
    }

    public Vector getTagNames() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.nb_tag) {
            vector.addElement(((Tag)this.tag.elementAt(n)).getTagName());
            ++n;
        }
        return vector;
    }

    public Vector getRemoteTagNames() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.nb_tag) {
            if (((Tag)this.tag.elementAt(n)).isRemote()) {
                vector.addElement(((Tag)this.tag.elementAt(n)).getTagName());
            }
            ++n;
        }
        return vector;
    }

    public Vector getRemoteTagNames(DataServer dataServer) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.nb_tag) {
            Tag tag = (Tag)this.tag.elementAt(n);
            if (tag.isRemote() && (tag.getDataServer() == dataServer || tag.getDataServer() == null && dataServer == this.ta)) {
                vector.addElement(((Tag)this.tag.elementAt(n)).getTagName());
            }
            ++n;
        }
        return vector;
    }

    public Vector getRemoteTags(DataServer dataServer) {
        Vector<Tag> vector = new Vector<Tag>();
        int n = 0;
        while (n < this.nb_tag) {
            Tag tag = (Tag)this.tag.elementAt(n);
            if (tag.isRemote() && (tag.getDataServer() == dataServer || tag.getDataServer() == null && dataServer == this.ta)) {
                vector.addElement(tag);
            }
            ++n;
        }
        return vector;
    }

    public Vector getTags() {
        return this.tag;
    }

    public int getNumberOfRemoteTags() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.nb_tag) {
            if (((Tag)this.tag.elementAt(n2)).isRemote()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int getNumberOfRemoteTags(DataServer dataServer) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.nb_tag) {
            Tag tag = (Tag)this.tag.elementAt(n2);
            if (tag.isRemote() && (tag.getDataServer() == dataServer || tag.getDataServer() == null && dataServer == this.ta)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int getNumberOfTags() {
        return this.nb_tag;
    }

    public void deleteTag(String string) {
        int n = this.get_tag_index(string);
        if (n >= 0) {
            this.tag.removeElementAt(n);
            --this.nb_tag;
            this.definitionDate = new Date().getTime();
            this.fireTagChangeEvent(string);
        }
    }

    public void cleanDataBase(Vector vector) {
        int n;
        Vector<String> vector2 = new Vector<String>();
        if (vector != null) {
            n = 0;
            while (n < this.nb_tag) {
                String string;
                String string2 = string = n >= 0 && n < this.nb_tag ? ((Tag)this.tag.elementAt(n)).getTagName() : "";
                if (string != null && string.length() > 0 && !vector.contains(string)) {
                    vector2.addElement(string);
                }
                ++n;
            }
        }
        n = 0;
        while (n < vector2.size()) {
            this.deleteTag((String)vector2.elementAt(n));
            ++n;
        }
    }

    public void clear() {
        this.definitionDate = new Date().getTime();
        this.nb_tag = 0;
        this.tag.removeAllElements();
    }

    public long getDefinitionDate() {
        return this.definitionDate;
    }

    private void setDefinitionDate() {
        this.definitionDate = new Date().getTime();
    }

    private void setDefinitionDate(long l) {
        this.definitionDate = l;
    }

    public boolean tagExist(String string) {
        int n = 0;
        while (n < this.nb_tag) {
            if (string.equals(((Tag)this.tag.elementAt(n)).getTagName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n < this.nb_tag) {
            string = String.valueOf(string) + ((Tag)this.tag.elementAt(n)).toString();
            string = String.valueOf(string) + ",";
            ++n;
        }
        return string;
    }

    public void setAllAcquisitionError() {
        int n = 0;
        while (n < this.nb_tag) {
            ((Tag)this.tag.elementAt(n)).setAcquisitionError();
            ++n;
        }
    }

    public boolean AcquisitionError() {
        int n = 0;
        while (n < this.nb_tag) {
            if (((Tag)this.tag.elementAt(n)).getAcquisitionError()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getNamesOfTagsOnError() {
        String string = "";
        int n = 0;
        while (n < this.nb_tag) {
            if (((Tag)this.tag.elementAt(n)).getAcquisitionError()) {
                string = String.valueOf(string) + " " + ((Tag)this.tag.elementAt(n)).getTagName();
            }
            ++n;
        }
        return string;
    }

    public void setDataServerInTags(String string) {
        DataServer dataServer;
        if (string != null && this.ta != null && (dataServer = this.ta.getDataServer(string)) != null) {
            int n = 0;
            while (n < this.nb_tag) {
                Tag tag = (Tag)this.tag.elementAt(n);
                String string2 = tag.getProcessName();
                if (string2 != null && string2.equals(string)) {
                    tag.setDataServer(dataServer);
                }
                ++n;
            }
        }
    }

    public void setDataServerofTag(String string, String string2) {
        int n = this.get_tag_index(string);
        if (n >= 0) {
            DataServer dataServer;
            Tag tag = (Tag)this.tag.elementAt(n);
            tag.setProcessName(string2);
            if (string2 != null && (dataServer = this.ta.getDataServer(string2)) != null) {
                tag.setDataServer(dataServer);
            }
        }
    }

    public void init(String string) {
        this.clear();
        this.addConfig(string);
    }

    public void addConfig(String string) {
        this.definitionDate = new Date().getTime();
        string.trim();
        if (string.indexOf(44) == -1) {
            string = String.valueOf(string) + ",";
        }
        while (string.length() > 1) {
            try {
                DataServer dataServer;
                Tag tag;
                String string2 = string.substring(0, string.indexOf(59));
                String string3 = string.substring(0, string.indexOf(44));
                string = string.substring(string.indexOf(44) + 1);
                if (string.indexOf(44) == -1) {
                    string = String.valueOf(string) + ",";
                }
                if ((tag = this.getTag(string2)) == null) {
                    tag = new Tag();
                    this.tag.addElement(tag);
                    ++this.nb_tag;
                }
                tag.setConfig(string3);
                String string4 = tag.getProcessName();
                if (string4 == null || (dataServer = this.ta.getDataServer(string4)) == null) continue;
                tag.setDataServer(dataServer);
            }
            catch (Exception exception) {
                string = "";
            }
        }
        this.fireTagChangeEvent_AllTags();
    }

    public Tag getTag(String string) {
        int n = 0;
        while (n < this.nb_tag) {
            String string2 = ((Tag)this.tag.elementAt(n)).getTagName();
            if (string.equals(string2)) {
                return (Tag)this.tag.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    private void global_trend_add_null_point() {
        int n = this.getMaxHistoricalLength() + 1;
        int n2 = 0;
        while (n2 < this.nb_tag) {
            ((Trend)((Tag)this.tag.elementAt(n2)).getTagHistory()).initHistory(n);
            ++n2;
        }
    }

    private int get_tag_index(String string) {
        int n = 0;
        while (n < this.nb_tag) {
            if (string.equals(((Tag)this.tag.elementAt(n)).getTagName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private String get_tag_name(int n) {
        if (n >= 0 && n < this.nb_tag) {
            return ((Tag)this.tag.elementAt(n)).getTagName();
        }
        return "";
    }

    private int get_tag_index(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.nb_tag) {
            if (string.equals(((Tag)this.tag.elementAt(n3)).getTagName())) {
                if (n2 == n) {
                    return n3;
                }
                ++n2;
            }
            ++n3;
        }
        return -1;
    }

    public int getMaxHistoricalLength() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.nb_tag) {
            int n3 = ((Tag)this.tag.elementAt(n2)).getTagHistory().getHistoryDepth();
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }
}

