/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;
import symantec.itools.awt.InvalidTreeNodeException;
import symantec.itools.awt.TreeNode;
import symantec.itools.lang.OS;

public class TreeView
extends Panel
implements ItemSelectable {
    public static final int CHILD = 0;
    public static final int NEXT = 1;
    public static final int LAST = 2;
    public static final int NODE_TOGGLED = 2001;
    public static final int NODE_EXPANDED = 2002;
    public static final int NODE_COLLAPSED = 2003;
    public static final int SEL_CHANGED = 1006;
    int sbVPosition;
    int sbVWidth;
    int sbHPosition;
    int sbHHeight;
    long sbVTimer = -1L;
    int cellSize = 16;
    int clickSize = 8;
    int imageInset = 3;
    int textInset = 6;
    int textBaseLine = 3;
    int doubleClickResolution = 333;
    protected TreeNode rootNode;
    protected TreeNode selectedNode;
    protected TreeNode topVisibleNode;
    protected Scrollbar verticalScrollBar;
    protected boolean sbVShow = false;
    protected int count;
    protected int viewCount;
    protected Scrollbar horizontalScrollBar;
    protected int sbHSize;
    protected int newWidth;
    protected boolean sbHShow = false;
    protected boolean needResetVector;
    protected int sbHLineIncrement = 4;
    protected int viewHeight = 300;
    protected int viewWidth = 300;
    protected int viewWidest;
    protected Key key;
    protected Mouse mouse;
    protected Adjustment adjustment;
    protected ActionListener actionListener;
    protected ItemListener itemListener;
    protected Focus focus;
    protected Vector v;
    protected Vector e;
    protected transient boolean redrawTriggered = false;
    transient boolean hasFocus = false;
    protected transient FontMetrics fm;
    transient long timeMouseDown;
    protected transient Image im1;
    protected transient Graphics g1;
    protected static boolean isSun1_1;
    protected transient ResourceBundle errors;

    public TreeView() {
        super.setLayout(null);
        this.verticalScrollBar = new Scrollbar(1);
        this.verticalScrollBar.hide();
        this.add(this.verticalScrollBar);
        this.horizontalScrollBar = new Scrollbar(0);
        this.horizontalScrollBar.hide();
        this.add(this.horizontalScrollBar);
        this.needResetVector = true;
    }

    public TreeView(TreeNode head) {
        this();
        this.selectedNode = this.rootNode = head;
        this.count = 1;
    }

    public void setTreeStructure(String[] s) {
        if (s == null || s.length == 0) {
            this.clear();
            return;
        }
        this.selectedNode = null;
        this.rootNode = null;
        try {
            this.parseTreeStructure(s);
        }
        catch (InvalidTreeNodeException e) {
            System.err.println(e);
        }
        this.triggerRedraw();
        this.invalidate();
    }

    public String[] getTreeStructure() {
        if (this.rootNode == null) {
            return null;
        }
        Vector nodesVector = new Vector(this.count);
        this.rootNode.depth = 0;
        this.vectorize(this.rootNode, false, false, nodesVector);
        int numNodes = nodesVector.size();
        String[] treeStructure = new String[numNodes];
        int i = 0;
        while (i < numNodes) {
            TreeNode thisNode = (TreeNode)nodesVector.elementAt(i);
            String treeString = "";
            int numBlanks = 0;
            while (numBlanks < thisNode.depth) {
                treeString = String.valueOf(treeString) + ' ';
                ++numBlanks;
            }
            treeStructure[i] = treeString = String.valueOf(treeString) + thisNode.text;
            ++i;
        }
        return treeStructure;
    }

    public Color getFgHilite() {
        return SystemColor.textHighlightText;
    }

    public Color getBgHilite() {
        return SystemColor.textHighlight;
    }

    public Object[] getSelectedObjects() {
        if (this.selectedNode == null) {
            return null;
        }
        Object[] selectedObjects = new TreeNode[]{this.selectedNode};
        return selectedObjects;
    }

    public void insert(TreeNode newNode, TreeNode relativeNode, int position) {
        if (newNode == null || relativeNode == null) {
            return;
        }
        if (!this.exists(relativeNode)) {
            return;
        }
        switch (position) {
            case 0: {
                this.addChild(newNode, relativeNode);
                break;
            }
            case 1: {
                this.addSibling(newNode, relativeNode, false);
                break;
            }
            case 2: {
                this.addSibling(newNode, relativeNode, true);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void clear() {
        this.selectedNode = null;
        this.rootNode = null;
        this.count = 0;
        this.v = new Vector();
        this.e = new Vector();
        this.triggerRedraw();
        this.invalidate();
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public int getCount() {
        return this.count;
    }

    public int getViewCount() {
        return this.viewCount;
    }

    boolean viewable(TreeNode node) {
        int i = 0;
        while (i < this.viewCount) {
            if (node == this.v.elementAt(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean viewable(String s) {
        if (s == null) {
            return false;
        }
        int i = 0;
        while (i < this.viewCount) {
            TreeNode tn = (TreeNode)this.v.elementAt(i);
            if (tn.text != null && s.equals(tn.text)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean exists(TreeNode node) {
        this.recount();
        int i = 0;
        while (i < this.count) {
            if (node == this.e.elementAt(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean exists(String s) {
        this.recount();
        if (s == null) {
            return false;
        }
        int i = 0;
        while (i < this.count) {
            TreeNode tn = (TreeNode)this.e.elementAt(i);
            if (tn.text != null && s.equals(tn.text)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void append(TreeNode newNode) {
        if (this.rootNode == null) {
            this.selectedNode = this.rootNode = newNode;
            this.count = 1;
            this.redrawTriggered = true;
        } else {
            this.recount();
            if (this.e.contains(newNode)) {
                System.err.println(new InvalidTreeNodeException("append: " + this.errors.getString("NodeAlreadyExists")));
            } else {
                this.addSibling(newNode, this.rootNode, true);
            }
        }
    }

    public void addChild(TreeNode newNode, TreeNode relativeNode) {
        if (relativeNode.child == null) {
            relativeNode.child = newNode;
            newNode.parent = relativeNode;
            ++this.count;
            this.redrawTriggered = true;
        } else {
            this.addSibling(newNode, relativeNode.child, true);
        }
        ++relativeNode.numberOfChildren;
    }

    public void addSibling(TreeNode newNode, TreeNode siblingNode) {
        this.addSibling(newNode, siblingNode, true);
    }

    public void addSibling(TreeNode newNode, TreeNode siblingNode, boolean asLastSibling) {
        if (asLastSibling) {
            TreeNode tempNode = siblingNode;
            while (tempNode.sibling != null) {
                tempNode = tempNode.sibling;
            }
            tempNode.sibling = newNode;
        } else {
            newNode.sibling = siblingNode.sibling;
            siblingNode.sibling = newNode;
        }
        newNode.parent = siblingNode.parent;
        ++this.count;
        this.redrawTriggered = true;
    }

    public TreeNode remove(String s) {
        this.recount();
        int i = 0;
        while (i < this.count) {
            TreeNode tn = (TreeNode)this.e.elementAt(i);
            if (tn.text != null && s.equals(tn.text)) {
                this.remove(tn);
                this.redrawTriggered = true;
                return tn;
            }
            ++i;
        }
        return null;
    }

    public void removeSelected() {
        if (this.selectedNode != null) {
            this.remove(this.selectedNode);
        }
    }

    public void remove(TreeNode node) {
        if (!this.exists(node)) {
            return;
        }
        if (node == this.selectedNode) {
            int index = this.v.indexOf(this.selectedNode);
            if (index == -1) {
                index = this.e.indexOf(this.selectedNode);
            }
            if (index > this.viewCount - 1) {
                index = this.viewCount - 1;
            }
            if (index > 0) {
                this.setSelectedNode((TreeNode)this.v.elementAt(index - 1));
            } else if (this.viewCount > 1) {
                this.setSelectedNode((TreeNode)this.v.elementAt(1));
            }
        }
        if (node.parent != null) {
            if (node.parent.child == node) {
                if (node.sibling != null) {
                    node.parent.child = node.sibling;
                } else {
                    node.parent.child = null;
                    node.parent.collapse();
                }
            } else {
                TreeNode tn = node.parent.child;
                while (tn.sibling != node) {
                    tn = tn.sibling;
                }
                tn.sibling = node.sibling != null ? node.sibling : null;
            }
        } else if (node == this.rootNode) {
            this.rootNode = node.sibling == null ? null : node.sibling;
        } else {
            TreeNode tn = this.rootNode;
            while (tn.sibling != node) {
                tn = tn.sibling;
            }
            tn.sibling = node.sibling != null ? node.sibling : null;
        }
        this.recount();
        this.redrawTriggered = true;
    }

    public void printTree(TreeNode node) {
        this.printTree(node, false);
    }

    public void printTree(TreeNode node, boolean isIndented) {
        if (node == null) {
            return;
        }
        String padding = new String();
        if (isIndented) {
            int i = 0;
            while (i < node.depth) {
                padding = "  " + padding;
                ++i;
            }
        }
        System.out.println(String.valueOf(padding) + node.text);
        this.printTree(node.child, isIndented);
        this.printTree(node.sibling, isIndented);
    }

    public TreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public String getSelectedText() {
        if (this.selectedNode == null) {
            return null;
        }
        return this.selectedNode.getText();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension d = this.size();
        if (this.redrawTriggered || d.width != this.viewWidth || d.height != this.viewHeight) {
            this.redraw(g);
        }
        g.translate(-this.sbHPosition, 0);
        g.clearRect(this.sbHPosition, 0, d.width - this.sbVWidth, d.height - this.sbHHeight);
        if (this.sbVShow && this.sbHShow) {
            g.setColor(Color.lightGray);
            g.fillRect(this.sbHPosition + d.width - this.sbVWidth, d.height - this.sbHHeight, this.sbVWidth, this.sbHHeight);
        }
        g.clipRect(this.sbHPosition, 0, d.width - this.sbVWidth, d.height - this.sbHHeight);
        g.drawImage(this.im1, 0, 0, this);
        g.setColor(Color.black);
        g.drawRect(this.sbHPosition, 0, d.width - this.sbVWidth - 1, d.height - this.sbHHeight - 1);
    }

    public void redraw() {
        this.triggerRedraw();
    }

    public void repaint(boolean f) {
        if (f) {
            this.needResetVector = true;
        }
        this.triggerRedraw();
    }

    public void redraw(Graphics g) {
        Dimension d = this.size();
        this.redrawTriggered = false;
        if (this.needResetVector) {
            this.resetVector();
        } else {
            this.needResetVector = true;
        }
        this.newWidth = this.compWidth(g);
        int inRectCount = (d.height - this.sbHHeight) / this.cellSize;
        if (this.viewCount > inRectCount) {
            this.sbVShow = true;
            this.sbVWidth = this.verticalScrollBar.preferredSize().width;
        } else {
            this.sbVShow = false;
            this.sbVWidth = 0;
            this.sbVPosition = 0;
        }
        if (this.newWidth > d.width - this.sbVWidth) {
            this.sbHShow = true;
            this.sbHHeight = this.horizontalScrollBar.preferredSize().height;
        } else {
            this.sbHShow = false;
            this.sbHHeight = 0;
            this.sbHPosition = 0;
        }
        this.drawTree();
        if (this.sbVShow) {
            this.verticalScrollBar.reshape(d.width - this.sbVWidth, 0, this.sbVWidth, d.height - this.sbHHeight);
            this.verticalScrollBar.setValues(this.sbVPosition, inRectCount, 0, this.viewCount - (isSun1_1 ? 0 : inRectCount));
            this.verticalScrollBar.setPageIncrement(inRectCount - 1);
            this.verticalScrollBar.show();
        } else {
            this.verticalScrollBar.hide();
        }
        if (this.sbHShow) {
            this.horizontalScrollBar.reshape(0, d.height - this.sbHHeight, d.width - this.sbVWidth, this.sbHHeight);
            this.horizontalScrollBar.setValues(this.sbHPosition, d.width - this.sbVWidth, 0, this.sbHSize - (isSun1_1 ? 0 : d.width - this.sbVWidth));
            this.horizontalScrollBar.setPageIncrement(d.width - this.sbVWidth);
            this.horizontalScrollBar.setLineIncrement(this.sbHLineIncrement);
            this.horizontalScrollBar.show();
        } else {
            this.horizontalScrollBar.hide();
        }
    }

    public void drawTree() {
        Font f;
        Dimension d = this.size();
        if (this.needResetVector) {
            this.resetVector();
        }
        if (d.width != this.viewWidth || d.height != this.viewHeight || this.g1 == null || this.sbHSize != this.newWidth) {
            this.sbHSize = this.newWidth;
            this.im1 = this.createImage(Math.max(this.sbHSize, d.width), d.height);
            if (this.g1 != null) {
                this.g1.dispose();
            }
            this.g1 = this.im1.getGraphics();
            this.viewWidth = d.width;
            this.viewHeight = d.height;
        }
        if ((f = this.getFont()) == null) {
            f = new Font("Serif", 0, 13);
            this.g1.setFont(f);
            ((Component)this).setFont(f);
        }
        if (this.g1.getFont() == null) {
            this.g1.setFont(f);
        }
        this.fm = this.g1.getFontMetrics();
        this.g1.setColor(this.getBackground());
        this.g1.fillRect(0, 0, this.im1.getWidth(this), d.height);
        int lastOne = this.sbVPosition + this.viewHeight / this.cellSize + 1;
        if (lastOne > this.viewCount) {
            lastOne = this.viewCount;
        }
        TreeNode outerNode = null;
        if (!this.v.isEmpty()) {
            outerNode = (TreeNode)this.v.elementAt(this.sbVPosition);
        }
        int i = this.sbVPosition;
        while (i < lastOne) {
            TreeNode node = (TreeNode)this.v.elementAt(i);
            int x = this.cellSize * (node.depth + 1);
            int y = (i - this.sbVPosition) * this.cellSize;
            this.g1.setColor(this.getForeground());
            if (node.sibling != null && node.isASiblingVisible()) {
                int k = this.v.indexOf(node.sibling) - i;
                if (k > lastOne) {
                    k = lastOne;
                }
                this.drawDotLine(x - this.cellSize / 2, y + this.cellSize / 2, x - this.cellSize / 2, y + this.cellSize / 2 + k * this.cellSize);
            }
            int m = 0;
            while (m < i) {
                TreeNode sib = (TreeNode)this.v.elementAt(m);
                if (sib.sibling == node && m < this.sbVPosition) {
                    this.drawDotLine(x - this.cellSize / 2, 0, x - this.cellSize / 2, y + this.cellSize / 2);
                }
                ++m;
            }
            if (node.isExpanded() && node.isAChildVisible()) {
                this.drawDotLine(x + this.cellSize / 2, y + this.cellSize - 2, x + this.cellSize / 2, y + this.cellSize + this.cellSize / 2);
            }
            this.g1.setColor(this.getForeground());
            this.drawDotLine(x - this.cellSize / 2, y + this.cellSize / 2, x + this.cellSize / 2, y + this.cellSize / 2);
            this.drawNodeToggle(node, x, y);
            Image nodeImage = node.getImage();
            if (nodeImage != null) {
                this.g1.drawImage(nodeImage, x + this.imageInset, y, this);
            }
            if (node.text != null) {
                this.drawNodeText(node, y, node == this.selectedNode, false);
            }
            if (outerNode.depth > node.depth) {
                outerNode = node;
            }
            ++i;
        }
        if (outerNode != null) {
            while ((outerNode = outerNode.parent) != null) {
                if (outerNode.sibling == null || !outerNode.isASiblingVisible()) continue;
                this.drawDotLine(this.cellSize * (outerNode.depth + 1) - this.cellSize / 2, 0, this.cellSize * (outerNode.depth + 1) - this.cellSize / 2, d.height);
            }
        }
        this.needResetVector = true;
    }

    protected void drawNodeToggle(TreeNode node, int x, int y) {
        if (node.isExpandable() && node.isAChildVisible()) {
            this.g1.setColor(this.getBackground());
            this.g1.fillRect(this.cellSize * node.depth + this.cellSize / 4, y + this.clickSize / 2, this.clickSize, this.clickSize);
            this.g1.setColor(this.getForeground());
            this.g1.drawRect(this.cellSize * node.depth + this.cellSize / 4, y + this.clickSize / 2, this.clickSize, this.clickSize);
            this.g1.drawLine(this.cellSize * node.depth + this.cellSize / 4 + 2, y + this.cellSize / 2, this.cellSize * node.depth + this.cellSize / 4 + this.clickSize - 2, y + this.cellSize / 2);
            if (!node.isExpanded()) {
                this.g1.drawLine(this.cellSize * node.depth + this.cellSize / 2, y + this.clickSize / 2 + 2, this.cellSize * node.depth + this.cellSize / 2, y + this.clickSize / 2 + this.clickSize - 2);
            }
        }
    }

    public synchronized Dimension getPreferredSize() {
        Dimension p = this.size();
        Dimension m = this.getMinimumSize();
        return new Dimension(Math.max(p.width, m.width), Math.max(p.height, m.height));
    }

    public synchronized Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public synchronized Dimension getMinimumSize() {
        return new Dimension(20, 40);
    }

    public synchronized Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void setLayout(LayoutManager lm) {
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public synchronized void addNotify() {
        super.addNotify();
        this.errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.key == null) {
            this.key = new Key();
            this.addKeyListener(this.key);
        }
        if (this.adjustment == null) {
            this.adjustment = new Adjustment();
            this.verticalScrollBar.addAdjustmentListener(this.adjustment);
            this.horizontalScrollBar.addAdjustmentListener(this.adjustment);
        }
        if (this.focus == null) {
            this.focus = new Focus();
            this.addFocusListener(this.focus);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.key != null) {
            this.removeKeyListener(this.key);
            this.key = null;
        }
        if (this.adjustment != null) {
            this.verticalScrollBar.removeAdjustmentListener(this.adjustment);
            this.horizontalScrollBar.removeAdjustmentListener(this.adjustment);
            this.adjustment = null;
        }
        if (this.focus != null) {
            this.removeFocusListener(this.focus);
            this.focus = null;
        }
        super.removeNotify();
    }

    public void triggerRedraw() {
        this.redrawTriggered = true;
        this.repaint();
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public synchronized void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    public synchronized void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    protected void handleMousePressed(MouseEvent event) {
        this.requestFocus();
        int x = event.getX();
        int y = event.getY();
        int index = y / this.cellSize + this.sbVPosition;
        if (index > this.viewCount - 1) {
            return;
        }
        TreeNode oldNode = this.selectedNode;
        TreeNode newNode = (TreeNode)this.v.elementAt(index);
        int newDepth = newNode.getDepth();
        Rectangle toggleBox = new Rectangle(this.cellSize * newDepth + this.cellSize / 4, (index - this.sbVPosition) * this.cellSize + this.clickSize / 2, this.clickSize, this.clickSize);
        if (toggleBox.inside(x, y)) {
            newNode.toggle();
            this.resetVector();
            if (!newNode.isExpanded() && !this.v.contains(this.selectedNode)) {
                this.setSelectedNode(newNode);
            }
            this.triggerRedraw();
            this.invalidate();
            this.sendActionEvent();
            if (this.itemListener != null) {
                this.itemListener.itemStateChanged(new ItemEvent(this, 2001, newNode, newNode.isExpanded ? 2002 : 2003));
            }
        } else {
            this.setSelectedNode(newNode);
            long currentTime = event.getWhen();
            if (newNode == oldNode && event.getWhen() - this.timeMouseDown < (long)this.doubleClickResolution) {
                newNode.toggle();
                this.resetVector();
                this.triggerRedraw();
                this.invalidate();
                this.sendActionEvent();
                if (this.itemListener != null) {
                    this.itemListener.itemStateChanged(new ItemEvent(this, 2001, newNode, newNode.isExpanded ? 2002 : 2003));
                }
                return;
            }
            this.timeMouseDown = event.getWhen();
        }
    }

    protected void handleMouseReleased(MouseEvent event) {
    }

    protected void handleAdjustmentEvent(AdjustmentEvent event) {
        if (event.getAdjustable() == this.verticalScrollBar) {
            if (this.sbVPosition != this.verticalScrollBar.getValue()) {
                this.sbVPosition = this.verticalScrollBar.getValue();
                this.triggerRedraw();
            }
        } else if (event.getAdjustable() == this.horizontalScrollBar && this.sbHPosition != this.horizontalScrollBar.getValue()) {
            this.sbHPosition = this.horizontalScrollBar.getValue();
            this.triggerRedraw();
        }
    }

    protected void handleKeyPressed(KeyEvent event) {
        int index = this.v.indexOf(this.selectedNode);
        switch (event.getKeyCode()) {
            case 10: 
            case 13: {
                this.sendActionEvent();
                this.requestFocus();
                break;
            }
            case 37: {
                if (event.isControlDown()) {
                    if (this.sbHPosition <= 0) break;
                    this.horizontalScrollBar.setValue(Math.max(this.sbHPosition -= this.sbHLineIncrement, 0));
                    this.repaint();
                    break;
                }
                if (this.selectedNode.isExpanded()) {
                    this.selectedNode.toggle();
                    if (this.itemListener == null) break;
                    this.itemListener.itemStateChanged(new ItemEvent(this, 2001, this.selectedNode, this.selectedNode.isExpanded ? 2002 : 2003));
                    this.triggerRedraw();
                    break;
                }
            }
            case 38: {
                if (index <= 0) break;
                this.setSelectedNode((TreeNode)this.v.elementAt(--index));
                this.requestFocus();
                break;
            }
            case 39: {
                if (event.isControlDown()) {
                    int max = this.horizontalScrollBar.getMaximum() - (isSun1_1 ? this.size().width - this.sbVWidth : 0);
                    if (!this.sbHShow || this.sbHPosition >= max) break;
                    this.horizontalScrollBar.setValue(Math.min(this.sbHPosition += this.sbHLineIncrement, max));
                    this.repaint();
                    break;
                }
                if (this.selectedNode.isExpandable() && !this.selectedNode.isExpanded()) {
                    this.selectedNode.toggle();
                    this.sendActionEvent();
                    if (this.itemListener == null) break;
                    this.itemListener.itemStateChanged(new ItemEvent(this, 2001, this.selectedNode, this.selectedNode.isExpanded ? 2002 : 2003));
                    this.triggerRedraw();
                    break;
                }
                if (!this.selectedNode.isExpandable()) break;
            }
            case 40: {
                if (index >= this.viewCount - 1) break;
                this.setSelectedNode((TreeNode)this.v.elementAt(++index));
                this.requestFocus();
                break;
            }
        }
    }

    protected void handleFocusGained(FocusEvent event) {
        this.hasFocus = true;
        if (this.selectedNode != null && this.v != null) {
            this.drawNodeText(this.selectedNode, (this.v.indexOf(this.selectedNode) - this.sbVPosition) * this.cellSize, true, false);
        }
    }

    protected void handleFocusLost(FocusEvent event) {
        this.hasFocus = false;
        if (this.selectedNode != null && this.v != null) {
            this.drawNodeText(this.selectedNode, (this.v.indexOf(this.selectedNode) - this.sbVPosition) * this.cellSize, true, false);
        }
    }

    protected void drawNodeText(TreeNode node, int yPosition, boolean eraseBackground, boolean eraseLines) {
        Color bg;
        Color fg;
        if (node == null) {
            return;
        }
        int depth = node.depth;
        Image nodeImage = node.getImage();
        int textOffset = (depth + 1) * this.cellSize + this.cellSize + this.textInset - (nodeImage == null ? 12 : 0);
        if (node == this.selectedNode && this.hasFocus) {
            fg = OS.isMacintosh() ? Color.white : SystemColor.textHighlightText;
            bg = OS.isMacintosh() ? new Color(0, 0, 128) : SystemColor.textHighlight;
        } else {
            fg = this.getForeground();
            bg = this.getBackground();
        }
        if (eraseBackground) {
            this.g1.setColor(bg);
            this.g1.fillRect(textOffset - 1, yPosition + 1, this.fm.stringWidth(node.text) + 4, this.cellSize - 1);
        }
        if (node == this.selectedNode) {
            this.g1.setColor(this.getForeground());
            this.g1.drawRect(textOffset - 1, yPosition + 1, this.fm.stringWidth(node.text) + 3, this.cellSize - 2);
            this.repaint(Math.max(0, textOffset - 1 - this.sbHPosition), yPosition + 1, this.fm.stringWidth(node.text) + 4, this.cellSize - 1);
        }
        if (eraseLines) {
            this.g1.setColor(this.getBackground());
            this.g1.drawRect(textOffset - 1, yPosition + 1, this.fm.stringWidth(node.text) + 3, this.cellSize - 2);
            this.repaint(Math.max(0, textOffset - 1 - this.sbHPosition), yPosition + 1, this.fm.stringWidth(node.text) + 4, this.cellSize - 1);
        }
        this.g1.setColor(fg);
        this.g1.drawString(node.text, textOffset, yPosition + this.cellSize - this.textBaseLine);
    }

    protected void sendActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, new String(this.selectedNode.getText())));
        }
    }

    protected int compWidth(Graphics gg) {
        int size = 0;
        Font f = this.getFont();
        if (f == null) {
            f = new Font("Serif", 0, 13);
            if (gg != null) {
                gg.setFont(f);
            }
            ((Component)this).setFont(f);
        }
        this.fm = gg == null ? null : gg.getFontMetrics();
        if (this.fm == null) {
            this.fm = this.getFontMetrics(f);
        }
        if (this.fm == null || this.v == null) {
            size = 100;
        } else {
            int i = 0;
            while (i < this.v.size()) {
                TreeNode node = (TreeNode)this.v.elementAt(i);
                int textOffset = (node.depth + 1) * this.cellSize + this.cellSize + this.textInset - (node.getImage() == null ? 12 : 0);
                if (size < textOffset + this.fm.stringWidth(node.text) + 6) {
                    size = textOffset + this.fm.stringWidth(node.text) + 6;
                }
                ++i;
            }
        }
        return size;
    }

    protected void drawDotLine(int x0, int y0, int x1, int y1) {
        if (y0 == y1) {
            int i = x0;
            while (i < x1) {
                this.g1.drawLine(i, y0, i, y1);
                i += 2;
            }
        } else {
            int i = y0;
            while (i < y1) {
                this.g1.drawLine(x0, i, x1, i);
                i += 2;
            }
        }
    }

    protected void changeSelection(TreeNode node) {
        this.setSelectedNode(node);
    }

    public void setSelectedNode(TreeNode node) {
        if (node == null) {
            if (this.selectedNode != null) {
                this.drawNodeText(this.selectedNode, (this.v.indexOf(this.selectedNode) - this.sbVPosition) * this.cellSize, true, true);
                if (this.itemListener != null) {
                    this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.selectedNode, 2));
                }
                this.selectedNode = null;
            }
            return;
        }
        if (node == this.selectedNode) {
            return;
        }
        TreeNode oldNode = this.selectedNode;
        this.selectedNode = node;
        if (oldNode != null) {
            this.drawNodeText(oldNode, (this.v.indexOf(oldNode) - this.sbVPosition) * this.cellSize, true, false);
        }
        this.drawNodeText(node, (this.v.indexOf(node) - this.sbVPosition) * this.cellSize, true, false);
        int index = this.v.indexOf(this.selectedNode);
        if (this.itemListener != null) {
            if (oldNode != null) {
                this.itemListener.itemStateChanged(new ItemEvent(this, 701, oldNode, 2));
            }
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.selectedNode, 1));
        }
        if (index < this.sbVPosition) {
            --this.sbVPosition;
            this.verticalScrollBar.setValue(this.sbVPosition);
            this.triggerRedraw();
            return;
        }
        if (index >= this.sbVPosition + (this.viewHeight - this.cellSize / 2) / this.cellSize) {
            ++this.sbVPosition;
            this.verticalScrollBar.setValue(this.sbVPosition);
            this.triggerRedraw();
            return;
        }
        this.repaint();
    }

    protected TreeNode newTreeNode(String text, TreeView treeView) {
        return new TreeNode(text, treeView);
    }

    protected void parseTreeStructure(String[] tempStructure) throws InvalidTreeNodeException {
        int i = 0;
        while (i < tempStructure.length) {
            String entry = tempStructure[i];
            int indentLevel = this.findLastPreSpace(entry);
            if (indentLevel == -1) {
                throw new InvalidTreeNodeException("parseTreeStructure: " + this.errors.getString("EmptyStrings"));
            }
            TreeNode node = this.newTreeNode(entry.trim(), this);
            node.setDepth(indentLevel);
            if (this.rootNode == null) {
                if (indentLevel != 0) {
                    throw new InvalidTreeNodeException("parseTreeStructure: " + this.errors.getString("NoRootLevelNode"));
                }
                this.append(node);
            } else {
                int diff;
                TreeNode currentNode = this.rootNode;
                while (currentNode.sibling != null) {
                    currentNode = currentNode.sibling;
                }
                int j = 1;
                while (j < indentLevel) {
                    int numberOfChildren = currentNode.numberOfChildren;
                    TreeNode tempNode = null;
                    if (numberOfChildren > 0) {
                        tempNode = currentNode.child;
                        while (tempNode.sibling != null) {
                            tempNode = tempNode.sibling;
                        }
                    }
                    if (tempNode == null) break;
                    currentNode = tempNode;
                    ++j;
                }
                if ((diff = indentLevel - currentNode.getDepth()) > 1) {
                    throw new InvalidTreeNodeException("parseTreeStructure: " + this.errors.getString("NoParent") + entry.trim());
                }
                if (diff == 1) {
                    this.insert(node, currentNode, 0);
                } else {
                    this.insert(node, currentNode, 1);
                }
            }
            ++i;
        }
    }

    protected void recount() {
        this.count = 0;
        this.e = new Vector();
        if (this.rootNode != null) {
            this.rootNode.depth = 0;
            this.traverse(this.rootNode);
        }
    }

    protected void traverse(TreeNode node) {
        ++this.count;
        if (!node.isHidden()) {
            this.e.addElement(node);
            if (node.child != null) {
                node.child.depth = node.depth + 1;
                this.traverse(node.child);
            }
        }
        if (node.sibling != null) {
            node.sibling.depth = node.depth;
            this.traverse(node.sibling);
        }
    }

    protected void resetVector() {
        this.v = new Vector(this.count);
        this.viewWidest = 30;
        if (this.count < 1) {
            this.viewCount = 0;
            return;
        }
        this.rootNode.depth = 0;
        this.vectorize(this.rootNode, true, true, this.v);
        this.viewCount = this.v.size();
        this.needResetVector = false;
    }

    protected void vectorize(TreeNode node, boolean respectExpanded, boolean repectHidden, Vector nodeVector) {
        if (node == null) {
            return;
        }
        if (!repectHidden || !node.isHidden()) {
            nodeVector.addElement(node);
            if (!respectExpanded && node.child != null || node.isExpanded()) {
                node.child.depth = node.depth + 1;
                this.vectorize(node.child, respectExpanded, repectHidden, nodeVector);
            }
        }
        if (node.sibling != null) {
            node.sibling.depth = node.depth;
            this.vectorize(node.sibling, respectExpanded, repectHidden, nodeVector);
        }
    }

    protected void debugVector() {
        int vSize = this.v.size();
        int i = 0;
        while (i < this.count) {
            TreeNode node = (TreeNode)this.v.elementAt(i);
            System.out.println(node.text);
            ++i;
        }
    }

    protected int findLastPreSpace(String s) {
        if (s != null && s.length() > 0) {
            int length = s.length();
            if (s.charAt(0) != ' ' && s.charAt(0) != '\t') {
                return 0;
            }
            int i = 1;
            while (i < length) {
                if (s.charAt(i) != ' ' && s.charAt(i) != '\t') {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    static {
        String vendor = System.getProperty("java.vendor");
        String version = System.getProperty("java.version");
        isSun1_1 = !(!vendor.startsWith("Sun Microsystems Inc.") && !vendor.startsWith("Apple") && !vendor.startsWith("Symantec Corporation") && !vendor.startsWith("Netscape") || !version.startsWith("11") && !version.startsWith("1.1"));
    }

    class Adjustment
    implements AdjustmentListener,
    Serializable {
        public void adjustmentValueChanged(AdjustmentEvent event) {
            TreeView.this.handleAdjustmentEvent(event);
        }

        Adjustment() {
            TreeView.this = TreeView.this;
        }
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent event) {
            TreeView.this.handleMousePressed(event);
        }

        public void mouseReleased(MouseEvent event) {
            TreeView.this.handleMouseReleased(event);
        }

        Mouse() {
            TreeView.this = TreeView.this;
        }
    }

    class Key
    extends KeyAdapter
    implements Serializable {
        public void keyPressed(KeyEvent event) {
            TreeView.this.handleKeyPressed(event);
        }

        Key() {
            TreeView.this = TreeView.this;
        }
    }

    class Focus
    extends FocusAdapter
    implements Serializable {
        public void focusGained(FocusEvent event) {
            TreeView.this.handleFocusGained(event);
        }

        public void focusLost(FocusEvent event) {
            TreeView.this.handleFocusLost(event);
        }

        Focus() {
            TreeView.this = TreeView.this;
        }
    }
}

