/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.shape;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import symantec.itools.awt.BevelStyle;
import symantec.itools.awt.util.ColorUtils;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public abstract class Shape
extends Component
implements BevelStyle {
    protected int width;
    protected int height;
    protected int style = 2;
    protected boolean fill;
    protected Color fillColor = Color.black;
    protected Color bevelLighterColor;
    protected Color bevelDarkerColor;
    protected Color cachedBackground;
    protected VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    protected PropertyChangeSupport changes = new PropertyChangeSupport(this);

    protected Shape() {
        this.cachedBackground = this.getBackground();
    }

    public void setBevelStyle(int s) throws PropertyVetoException {
        if (this.style != s) {
            Integer oldValue = new Integer(this.style);
            Integer newValue = new Integer(s);
            this.vetos.fireVetoableChange("BevelStyle", oldValue, newValue);
            this.style = s;
            this.repaint();
            this.changes.firePropertyChange("BevelStyle", oldValue, newValue);
        }
    }

    public int getBevelStyle() {
        return this.style;
    }

    public void setFillMode(boolean f) throws PropertyVetoException {
        if (this.fill != f) {
            Boolean oldValue = new Boolean(this.fill);
            Boolean newValue = new Boolean(f);
            this.vetos.fireVetoableChange("FillMode", oldValue, newValue);
            this.fill = f;
            this.repaint();
            this.changes.firePropertyChange("FillMode", oldValue, newValue);
        }
    }

    public boolean isFillMode() {
        return this.fill;
    }

    public boolean getFillMode() {
        return this.isFillMode();
    }

    public void setFillColor(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.fillColor, color)) {
            Boolean oldValue = new Boolean(this.fill);
            this.vetos.fireVetoableChange("FillColor", oldValue, color);
            this.fillColor = color;
            this.repaint();
            this.changes.firePropertyChange("FillColor", oldValue, color);
        }
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void reshape(int x, int y, int width, int height) {
        this.width = width;
        this.height = height;
        super.reshape(x, y, width, height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    public Dimension getPreferredSize() {
        Dimension dim = this.size();
        Dimension min = this.getMinimumSize();
        return new Dimension(Math.max(dim.width, min.width), Math.max(dim.height, min.height));
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public synchronized void paint(Graphics g) {
        Color curBackground = this.getBackground();
        if (!GeneralUtils.objectsEqual(curBackground, this.cachedBackground)) {
            this.cachedBackground = curBackground;
            this.updateBevelColors(curBackground);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    protected void updateBevelColors(Color c) {
        this.bevelDarkerColor = ColorUtils.calculateShadowColor(c);
        this.bevelLighterColor = ColorUtils.calculateHilightColor(c);
    }
}

