package cern.lhcias.csgui.Events;

import java.util.*;
import cern.lhcias.csgui.interfaces.*;

/**
This class is an event adapter which centrally manages the Alarm events. 
We prevent sending the same event with a frequency higher than 1 s.
*/
public class AlarmAdapter implements AlarmListener
{
    Vector myListeners;
    
    Object previousSender;
    AlarmEvent previousAlarm;
    long   previousTime;

    //----------------------------------------------------------------------
    //          CONSTRUCTOR
    //----------------------------------------------------------------------
    public AlarmAdapter() {
        myListeners = new Vector();
    }
    
    //----------------------------------------------------------------------
    //          PUBLIC METHODS
    //----------------------------------------------------------------------
    public synchronized void addAlarmListener( AlarmListener listener) {
        myListeners.addElement(listener);
    }
    
    public synchronized void removeAlarmListener(AlarmListener listener) {
        myListeners.removeElement(listener);
    }
    
     public void receiveAlarm(AlarmEvent alarmevent)
    {
        Object newSender = alarmevent.getSource();
        AlarmEvent newAlarm = alarmevent;
        long   newTime = (new Date()).getTime();

        // We prevent sending the same event with a frequency higher
        // than 1 s
        if (previousAlarm == null || previousSender == null) {
            previousAlarm = newAlarm;
            previousSender = newSender;
            previousTime = newTime - 2000;
        }
        if ((!newAlarm.text.equals(previousAlarm.text))    ||
 	      (!newAlarm.group.equals(previousAlarm.group)) ||   
          ((newTime-previousTime) > 1000)) {
            previousSender = newSender;
            previousTime = newTime;
            previousAlarm = newAlarm;
        
            for (int i=0; i<myListeners.size(); i++) {
                if (previousSender != myListeners.elementAt(i))
                    ((AlarmListener) myListeners.elementAt(i)).receiveAlarm(alarmevent);
           }
        }
     }
}