package cern.lhcias.csgui.Events;

import java.util.*;
import cern.lhcias.csgui.interfaces.*;

/**
This class is an event adapter which centrally manages the OpenViewEvents. 
* @see cern.lhcias.csgui.Events.OpenViewEvent
*/
public class OpenViewAdapter implements OpenViewListener,Runnable
{
    Vector myListeners;
    OpenViewEvent openVEvent;

    public OpenViewAdapter() {
        myListeners = new Vector();
    }
    
    public synchronized void addOpenViewListener( OpenViewListener listener) {
        myListeners.addElement(listener);
    }
    
    public synchronized void removeOpenViewListener(OpenViewListener listener) {
        myListeners.removeElement(listener);
    }
    
    public void receiveOpenView(OpenViewEvent openViewEvent)
    {
        openVEvent = openViewEvent;
        (new Thread(this)).start();
    }
    
    public void run() {
        OpenViewEvent openViewEvent = openVEvent;
        for (int i=0; i<myListeners.size(); i++) {
            ((OpenViewListener) myListeners.elementAt(i)).receiveOpenView(openViewEvent);
        }
    }
}