package cern.lhcias.csgui.Events;

import java.util.*;
/**
This event is usually sent by TagsViews that wish to open a new window 
containing a TagsView.
*/
public class OpenViewEvent extends java.util.EventObject
{
    String viewType;
    boolean newWindowFlag;
    String config;
    int width;
    int height;

    public OpenViewEvent( Object sourceObject) {
        super(sourceObject);
        viewType="";
        newWindowFlag=false;
        config="";
        width = 0;
        height = 0;
    }
    
    OpenViewEvent( Object sourceObject, String ViewType, boolean NewWindowFlag,
                   String Config, int Width, int Height) {
        super(sourceObject);
        viewType=ViewType;
        newWindowFlag=NewWindowFlag;
        config=Config;
        width = Width;
        height = Height;
    }
    
    public void setViewType(String type) {
        viewType = type;
    }
    
    public String getViewType() {
        return(viewType);
    }
    
    public void setNewWindowFlag(boolean flag){
        newWindowFlag = flag;
    }
    
    public boolean getNewWindowFlag() {
        return(newWindowFlag);
    }
    
    public void setConfig(String conf){
        config = conf;
    }
    
    public String getConfig() {
        return(config);
    }

    public void setWidth(int w){
        width = w;
    }
    
    public int getWidth() {
        return(width);
    }
    public void setHeight(int h){
        height = h;
    }
    
    public int getHeight() {
        return(height);
    }
}