package cern.lhcias.csgui.Events;

import java.util.*;
import cern.lhcias.csgui.interfaces.*;

/**  This class is an event adapter which centrally manages the TagClickedEvents. 
It prevents to send the same event with a frequency higher than 500 ms.
* @see cern.lhcias.csgui.Events.TagClickedEvent
*/
public class TagClickedAdapter implements TagClickedListener
{
    Vector myListeners;
    
    Object previousSender;
    String previousTag;
    long   previousTime;

    //----------------------------------------------------------------------
    //          CONSTRUCTOR
    //----------------------------------------------------------------------
    public TagClickedAdapter() {
        myListeners = new Vector();
    }
    
    //----------------------------------------------------------------------
    //          PUBLIC METHODS
    //----------------------------------------------------------------------
    public synchronized void addTagClickedListener( TagClickedListener listener) {
        myListeners.addElement(listener);
    }
    
    public synchronized void removeTagClickedListener(TagClickedListener listener) {
        myListeners.removeElement(listener);
    }
    
     public void receiveTagClicked(TagClickedEvent tagevent)
    {
        Object newSender = tagevent.getSource();
        String newTag = tagevent.TagName;
        long   newTime = (new Date()).getTime();

        // We prevent sending the same event with a frequency higher
        // than 500 ms
        if ((newSender != previousSender) ||
            (newTag    != previousTag)    ||
            ((newTime-previousTime) > 500)) {
            previousSender = newSender;
            previousTime = newTime;
            previousTag = newTag;
        
            for (int i=0; i<myListeners.size(); i++) {
                if (previousSender != myListeners.elementAt(i))
                    ((TagClickedListener) myListeners.elementAt(i)).receiveTagClicked(tagevent);
            }
        }
     }
}