/*
 * Decompiled with CFR 0.152.
 */
package winicon;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.util.Vector;

class ImagePanel
extends Panel {
    Image Album = null;
    int preIndex = -1;
    int imgH;
    int imgW;
    int startX = 0;
    int startY = 0;
    int row = 0;
    int column = 0;
    int maxScroll;
    Vector ImageSet = null;

    public ImagePanel() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ImagePanel.this.this_mouseClicked(mouseEvent);
            }
        });
    }

    public void setStart(int n) {
        this.startY = this.maxScroll > n ? n : this.maxScroll;
        Graphics graphics = this.getGraphics();
        this.paint(graphics);
        graphics.dispose();
    }

    public int getStart() {
        return this.startY;
    }

    public void reset() {
        this.Album = null;
        this.ImageSet = null;
        this.column = 0;
        this.row = 0;
        this.preIndex = -1;
        this.startY = 0;
        this.startX = 0;
        this.repaint();
    }

    public int getImageIndex(int n, int n2) {
        if (this.Album == null || this.ImageSet == null) {
            return -1;
        }
        int n3 = this.getSize().width;
        int n4 = this.getSize().height;
        if (n < 1 || n >= n3 - 1 || n2 < 1 || n2 >= n4 - 1) {
            return -1;
        }
        int n5 = (n - 1) / 48;
        int n6 = (n2 - 1 + this.startY) / 48;
        if (n5 >= this.column || n6 >= this.row) {
            return -1;
        }
        int n7 = n6 * this.column + n5;
        if (n7 >= this.ImageSet.size()) {
            return -1;
        }
        n5 = n - 1 - n5 * 48;
        n6 = n2 - 1 + this.startY - n6 * 48;
        if (n5 < 8 || n6 < 8 || n5 > 40 || n6 > 40) {
            return -1;
        }
        return n7;
    }

    public int setImageAlbum(Vector vector) {
        this.ImageSet = vector;
        if (this.ImageSet == null) {
            this.reset();
            return -1000;
        }
        int n = this.ImageSet.size();
        if (n <= 0) {
            this.reset();
            return -1000;
        }
        int n2 = this.getSize().width - 2;
        int n3 = this.getSize().height - 2;
        this.column = n2 / 48;
        this.row = n % this.column == 0 ? n / this.column : n / this.column + 1;
        int n4 = this.row * 48;
        if (n4 < n3) {
            n4 = n3;
        }
        this.Album = null;
        this.Album = this.createImage(n2, n4);
        this.imgH = n4;
        this.imgW = n2;
        Graphics graphics = this.Album.getGraphics();
        graphics.setColor(Color.yellow);
        graphics.fillRect(0, 0, n2, n4);
        for (int i = 0; i < n; ++i) {
            int n5 = i / this.column;
            int n6 = i % this.column;
            Image image = this.createImage(new MemoryImageSource(16, 16, (int[])this.ImageSet.elementAt(i), 0, 16));
            graphics.drawImage(image, n6 * 48 + 8, n5 * 48 + 8, 32, 32, null);
        }
        graphics.dispose();
        this._$5355(0);
        this.preIndex = 0;
        this.maxScroll = n4 - n3;
        this.startX = 0;
        this.startY = 0;
        this.repaint();
        return this.maxScroll;
    }

    public Dimension getAlbumLayout() {
        return new Dimension(this.column, this.row);
    }

    public void this_mouseClicked(MouseEvent mouseEvent) {
        if (this.Album == null) {
            return;
        }
        int n = this.getImageIndex(mouseEvent.getX(), mouseEvent.getY());
        if (n < 0) {
            return;
        }
        this._$5355(this.preIndex);
        this._$5355(n);
        this.preIndex = n;
        Graphics graphics = this.getGraphics();
        this.paint(graphics);
        graphics.dispose();
    }

    private void _$5355(int n) {
        if (this.Album == null || this.ImageSet == null || this.ImageSet.size() <= n || n < 0) {
            return;
        }
        int n2 = n / this.column;
        int n3 = n % this.column;
        if (n3 < 0 || n3 >= this.column || n2 < 0 || n2 >= this.row) {
            return;
        }
        n3 *= 48;
        n2 *= 48;
        Graphics graphics = this.Album.getGraphics();
        graphics.setXORMode(Color.red);
        graphics.drawLine(n3 += 4, n2 += 4, n3 + 40, n2);
        graphics.drawLine(n3, n2, n3, n2 + 40);
        graphics.drawLine(n3 + 40, n2 + 40, n3 + 40, n2);
        graphics.drawLine(n3 + 40, n2 + 40, n3, n2 + 40);
        graphics.dispose();
    }

    public int getCurrentIndex() {
        return this.preIndex;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 0, n - 1, 0);
        graphics.drawLine(0, 0, 0, n2 - 1);
        graphics.setColor(Color.white);
        graphics.drawLine(n - 1, n2 - 1, n - 1, 0);
        graphics.drawLine(n - 1, n2 - 1, 0, n2 - 1);
        if (this.Album != null) {
            graphics.drawImage(this.Album, 1, 1, n - 2, n2 - 2, this.startX, this.startY, this.startX + n - 3, this.startY + n2 - 3, null);
        }
    }
}

