
/*
 * Copyright (c) 1998, 1999 Semiotek Inc. All Rights Reserved.
 *
 * This software is the confidential intellectual property of
 * of Semiotek Inc.; it is copyrighted and licensed, not sold.
 * You may use it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation. If you 
 * do not want to use the GPL, you may still use the software after
 * purchasing a proprietary developers license from Semiotek Inc.
 *
 * This software is provided "as is", with NO WARRANTY, not even the 
 * implied warranties of fitness to purpose, or merchantability. You
 * assume all risks and liabilities associated with its use.
 *
 * See the attached License.html file for details, or contact us
 * by e-mail at info@semiotek.com to get a copy.
 */


package org.webmacro.broker;
import org.webmacro.util.*;
import java.util.*;

/**
  * Common interface for both ResourceProvider and ResourceConsumer. All
  * ResourceListeners have a set of types which they listen for.
  */
public interface ResourceListener extends EventListener
{
   /**
     * Get a list of the types that this ResourceListener is interested
     * in. This method will be called when the ResourceListener is 
     * registered with a ResourceBroker. The ResourceBroker will only
     * forward events matching one of the listed types to the Listener.
     * <p>
     * Note that this method should return the same list each time its
     * called by the ResourceBroker. If you wish to change the list of
     * types your listener is intersted in, you should remove it from
     * all ResourceBrokers, change the list, and then re-add it.
     * <p>
     * @see ResourceProvider
     * @see ResourceConsumer
     */
    public String[] getTypes(); 


   /**
     * Called whent he ResourceBroker is starting up. You can initialize
     * your provider at this point. If initialization failed for some 
     * reason you can throw an exception.
     * @param broker the resoruce broker initializing the listener
     * @exception InitException cannot initialize the listener
     */
    public void init(ResourceBroker broker) throws InitException;


   /**
     * Called when the RequestBroker is shutting down. The ResourceListener
     * should save its persistent state and shut down as well.
     */
   public void destroy();

}
