/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Command;

import X10Gimli.Command.Command;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.ValueType;
import java.util.ArrayList;

public final class CaseCommand
extends Command {
    private ArrayList cases = new ArrayList();
    private ArrayList commands = new ArrayList();
    private ValueType val;

    public void setValue(ValueType v) {
        this.val = v;
    }

    public ValueType getValue() {
        return this.val;
    }

    public void setCases(ArrayList a, ArrayList c) {
        if (a != null && c != null) {
            this.cases = a;
            this.commands = c;
        }
    }

    public void addCase(ValueType c, Command com) {
        this.cases.add(c);
        this.commands.add(com);
    }

    public ValueType execute(EnvironmentSmall env) {
        if (env != null) {
            int size = this.cases.size();
            for (int i = 0; i < size; ++i) {
                if (!this.val.applyCondition("==", (ValueType)this.cases.get(i), env).getBoolean()) continue;
                env.executeCommand((Command)this.commands.get(i));
                break;
            }
        }
        return null;
    }

    protected void executionOutput() {
        this.sBuf.append("case ");
        this.sBuf.append(this.val.string);
    }

    public String toX10GIMLI(int depth) {
        this.prepareOutputDepth(depth);
        this.sBuf.append("case ");
        this.sBuf.append(this.val.toX10GIMLI());
        this.sBuf.append(" of\r\n");
        int indent = (depth + 1) * 2;
        int size = this.cases.size();
        for (int i = 0; i < size; ++i) {
            this.sBuf.append(Command.sBytes, 0, indent);
            this.sBuf.append(((ValueType)this.cases.get(i)).toX10GIMLI());
            this.sBuf.append(" : ");
            this.sBuf.append(((Command)this.commands.get(i)).toX10GIMLI(depth + 2));
            this.sBuf.append("\r\n");
        }
        this.sBuf.append(Command.sBytes, 0, indent - 2);
        this.sBuf.append("end\r\n");
        return this.sBuf.toString();
    }
}

