/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Command.Function;

import X10Gimli.Command.FuncCommand;
import X10Gimli.Debug;
import X10Gimli.Interface.BasicGateway;
import X10Gimli.Interface.Gateway.TCPGateway;
import X10Gimli.Interface.InputGateway;
import X10Gimli.Interface.InputListener;
import X10Gimli.Interface.InputOutputGateway;
import X10Gimli.Interface.OutputGateway;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.System.Packet.Packet;
import X10Gimli.System.SystemModel;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueIdent;
import X10Gimli.Value.ValueType;
import java.util.ArrayList;

public class InterfacefunnelCommand
extends FuncCommand {
    private static Class findInterface(String gateway) {
        String commclass = String.valueOf(String.valueOf(new StringBuffer("X10Gimli.Interface.Gateway.").append(gateway).append("Gateway")));
        try {
            Class<?> clazz = Class.forName(commclass);
            return clazz;
        }
        catch (Exception e) {
            Debug.printCallStack("Exception creating external gateway object.", e);
            return null;
        }
    }

    private static boolean existsInterface(String gateway) {
        return InterfacefunnelCommand.findInterface(gateway) != null;
    }

    private void funnelThroughTCP(Object ng, SystemModel m) {
        int count = 0;
        ArrayList g = m.getInputGateways();
        int size = g.size();
        for (int i = 0; i < size; ++i) {
            Object o = g.get(i);
            if (!(o instanceof TCPGateway)) continue;
            ++count;
            TCPGateway t = (TCPGateway)o;
            if (ng instanceof InputGateway) {
                ((InputGateway)ng).addInputListener(t);
                continue;
            }
            if (ng instanceof InputOutputGateway) {
                ((InputOutputGateway)ng).addInputListener(t);
                t.addInputListener(new InputOutputBridge(this, (BasicGateway)ng));
                continue;
            }
            if (!(ng instanceof OutputGateway)) continue;
            t.addInputListener(new InputOutputBridge(this, (BasicGateway)ng));
        }
        if (count == 0) {
            Debug.error(302, "No TCP gateway exists to funnel gateway connection.");
        }
    }

    public ValueType execute(EnvironmentSmall env) {
        this.prepareParams();
        if (this.getNumParams() >= 1 && this.getNumParams() <= 3) {
            ValueType param1 = this.getParam(0);
            SystemModel m = env.getSystemModel();
            if (m != null && param1 instanceof ValueIdent) {
                Class c = InterfacefunnelCommand.findInterface(((ValueIdent)param1).getValueString());
                if (c != null) {
                    try {
                        BasicGateway g = (BasicGateway)c.newInstance();
                        if (this.getNumParams() == 2) {
                            ValueType param2 = this.getParam(1);
                            if (param2 instanceof Value && ((Value)param2).getValueString() == "NULL") {
                                if (g.initialize(null)) {
                                    this.funnelThroughTCP(g, m);
                                }
                            } else if (param2 instanceof Value && g.initialize((Value)param2)) {
                                this.funnelThroughTCP(g, m);
                            } else {
                                Debug.error(303, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Unable to initialize inferface in ").append(this.toString()).append("."))));
                            }
                        } else if (g.initialize(null)) {
                            this.funnelThroughTCP(g, m);
                        } else {
                            Debug.error(303, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Unable to initialize inferface in ").append(this.toString()).append(" with no parameters."))));
                        }
                        if (this.getNumParams() == 3) {
                            ValueIdent s = this.getIdentParam(2);
                            g.setName(s.getValueString());
                        }
                        ValueType valueType = null;
                        return valueType;
                    }
                    catch (Exception e) {
                        Debug.printCallStack("Exception in interface funnel call.", e);
                    }
                }
                Debug.error(108, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Unable to find interface class in ").append(this.toString()).append("."))));
            }
        }
        Debug.error(103, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Expecting interface identifier and paramter in ").append(this.toString()).append("."))));
        return null;
    }

    private class InputOutputBridge
    implements InputListener {
        private BasicGateway bg;

        public InputOutputBridge(InterfacefunnelCommand this$0, BasicGateway bg) {
            this.bg = bg;
        }

        public void receivePacket(Packet evt) {
            if (this.bg instanceof OutputGateway) {
                ((OutputGateway)this.bg).transmitPacket(evt);
            } else if (this.bg instanceof InputOutputGateway) {
                ((InputOutputGateway)this.bg).transmitPacket(evt);
            }
        }
    }
}

