/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Interface.Gateway;

import X10Gimli.Debug;
import X10Gimli.Interface.InputGateway;
import X10Gimli.Native.Joystick;
import X10Gimli.System.Packet.Packet;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueIdent;
import X10Gimli.Value.ValueNumber;

public class JOYGateway
extends InputGateway {
    private Joystick jInput;
    private int lastButtonState = 0;
    private int joyID = 0;

    public JOYGateway() {
        this.sSource = "JOYSTICK";
    }

    public boolean initialize(Value id) {
        if (id instanceof ValueNumber) {
            this.jInput = new Joystick(id.getNumber());
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Successfully activated gateway for joystick port ").append(id.getNumber()).append(".\""))));
            return true;
        }
        Debug.error(100, "\"Numerical joystick port value required to activate gateway.\"");
        return false;
    }

    protected void startQueueThread() {
        super.startQueueThread();
        Thread t = new Thread(new Runnable(){

            public void run() {
                Debug.log(1, "\"Joystick polling thread started.\"");
                while (true) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        Debug.printCallStack("Interrupted sleep in joystick polling thread.", e);
                    }
                    float xPos = JOYGateway.this.jInput.getXPos();
                    float yPos = JOYGateway.this.jInput.getYPos();
                    float zPos = JOYGateway.this.jInput.getZPos();
                    int buttons = JOYGateway.this.jInput.getButtons();
                    if (buttons == JOYGateway.this.lastButtonState) continue;
                    Packet packet = new Packet();
                    if ((buttons & 1) != 0) {
                        packet.addSegment("BUTTON1", new ValueIdent("DOWN"));
                    } else {
                        packet.addSegment("BUTTON1", new ValueIdent("UP"));
                    }
                    if ((buttons & 2) != 0) {
                        packet.addSegment("BUTTON2", new ValueIdent("DOWN"));
                    } else {
                        packet.addSegment("BUTTON2", new ValueIdent("UP"));
                    }
                    if ((buttons & 4) != 0) {
                        packet.addSegment("BUTTON3", new ValueIdent("DOWN"));
                    } else {
                        packet.addSegment("BUTTON3", new ValueIdent("UP"));
                    }
                    if ((buttons & 8) != 0) {
                        packet.addSegment("BUTTON4", new ValueIdent("DOWN"));
                    } else {
                        packet.addSegment("BUTTON4", new ValueIdent("UP"));
                    }
                    packet.setType("JOYSTICK");
                    packet.setSource(JOYGateway.this.sSource);
                    packet.packData();
                    JOYGateway.this.inputReceived(packet);
                    JOYGateway.this.lastButtonState = buttons;
                }
            }
        });
        t.start();
    }
}

