/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Interface.Gateway;

import X10Gimli.Debug;
import X10Gimli.Interface.InputOutputGateway;
import X10Gimli.System.Packet.Packet;
import X10Gimli.System.Packet.PopPacket;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueString;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;

public class POPGateway
extends InputOutputGateway {
    private String serverName = "localhost";
    private int port = 110;
    private Socket pop = null;
    private BufferedReader in = null;
    private OutputStreamWriter out = null;
    private String input;

    public POPGateway() {
        this.sSource = "POP";
    }

    public boolean initialize(Value id) {
        if (id instanceof ValueString) {
            this.serverName = id.getValueString();
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Successfully activated POP gateway for ").append(this.serverName).append(" on port ").append(this.port).append(".\""))));
            return true;
        }
        Debug.error(100, "\"Server address or server/port combination required to initialize SMTP gateway.\"");
        return false;
    }

    public void sendPacket(Packet pack) {
        Packet packet = pack.getPacketType();
        if (packet instanceof PopPacket) {
            PopPacket p = (PopPacket)packet;
            if (p.getCommand().getValueString().equals("CONNECT")) {
                this.connect(p.getUser().getValueString(), p.getPassword().getValueString());
            } else if (p.getCommand().getValueString().equals("LIST")) {
                Vector list = this.getMessageList();
                Packet lpack = new Packet();
                lpack.setType("POP");
                if (list == null) {
                    this.inputReceived(lpack);
                    return;
                }
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    lpack.addSegment("MESSAGE".concat(String.valueOf(String.valueOf(i))), new ValueNumber(Integer.parseInt((String)list.get(i))));
                }
                this.inputReceived(lpack);
            } else if (p.getCommand().getValueString().equals("GET")) {
                Packet message = this.decodeMessage(p.getNumber().getNumber());
                if (message != null) {
                    this.inputReceived(message);
                }
            } else if (p.getCommand().getValueString().equals("HEADER")) {
                Packet header = this.decodeHeader(p.getNumber().getNumber());
                if (header != null) {
                    this.inputReceived(header);
                }
            } else if (p.getCommand().getValueString().equals("DELETE")) {
                this.deleteMessage(p.getNumber().getNumber());
            } else if (p.getCommand().getValueString().equals("DISCONNECT")) {
                this.disconnect();
            }
        }
    }

    public String readInput() {
        try {
            this.input = this.in.readLine();
        }
        catch (Exception e) {
            this.pop = null;
            this.in = null;
            this.out = null;
            Debug.error(302, "Error receiving input from POP.");
        }
        return this.input;
    }

    private void writeOutput(String s) {
        try {
            this.out.write(s);
            this.out.flush();
        }
        catch (Exception e) {
            this.pop = null;
            this.in = null;
            this.out = null;
            Debug.error(302, "Error writeing output to POP.");
        }
    }

    public Vector getMessageList() {
        try {
            if (this.pop != null) {
                this.writeOutput("LIST\n");
                Vector<String> messageNums = new Vector<String>();
                if (!this.readInput().substring(0, 3).equals("+OK")) {
                    Debug.error(302, "Problem reading list of messages from POP.");
                    Vector vector = null;
                    return vector;
                }
                while (!this.readInput().substring(0, 1).equals(".")) {
                    messageNums.add(this.input.substring(0, this.input.indexOf(32)));
                }
                Vector<String> vector = messageNums;
                return vector;
            }
        }
        catch (Exception e) {
            Debug.error(302, "Error occurred while attempting to download message list from POP server.");
        }
        return null;
    }

    public Packet decodeMessage(int num) {
        return this.decodeMessage("".concat(String.valueOf(String.valueOf(num))));
    }

    public Packet decodeMessage(String num) {
        try {
            this.writeOutput(String.valueOf(String.valueOf(new StringBuffer("RETR ").append(num).append("\n"))));
            if (!this.readInput().substring(0, 3).equals("+OK")) {
                Debug.error(302, String.valueOf(String.valueOf(new StringBuffer("Problem reading message ").append(num).append(" from POP."))));
                Packet packet = null;
                return packet;
            }
            Packet p = new Packet();
            p.setType("EMAIL");
            String tag = "";
            String val = "";
            while (!this.readInput().equals("")) {
                if (this.input.length() > 0 && this.input.charAt(0) != ' ' && this.input.charAt(0) != '\t') {
                    tag = this.input.substring(0, this.input.indexOf(58));
                    val = this.input.substring(this.input.indexOf(58) + 1, this.input.length());
                    while (val.length() > 0 && val.charAt(0) == ' ' && this.input.charAt(0) != '\t') {
                        val = val.substring(1, val.length());
                    }
                    p.setSegment(tag, new ValueString(val));
                    continue;
                }
                while (this.input.length() > 0 && this.input.charAt(0) == ' ') {
                    this.input = this.input.substring(1, this.input.length());
                }
                val = String.valueOf(String.valueOf(val)).concat(String.valueOf(String.valueOf(" ".concat(String.valueOf(String.valueOf(this.input))))));
                p.setSegment(tag, new ValueString(val));
            }
            StringBuffer message = new StringBuffer("");
            while (this.readInput().length() != 1 || this.input.length() == 1 && this.input.charAt(0) != '.') {
                message.append(this.input);
                message.append("\r\n");
            }
            if (message.length() > 0) {
                message.setLength(message.length() - 2);
            }
            p.setSegment("MESSAGE", new ValueString(message.toString()));
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Successfully decoded POP message ").append(num).append(".\""))));
            Packet packet = p;
            return packet;
        }
        catch (Exception e) {
            Debug.error(302, String.valueOf(String.valueOf(new StringBuffer("Problem downloading message ").append(num).append(" from POP."))));
            e.printStackTrace();
            return null;
        }
    }

    public Packet decodeHeader(int num) {
        return this.decodeHeader("".concat(String.valueOf(String.valueOf(num))));
    }

    public Packet decodeHeader(String num) {
        try {
            this.writeOutput(String.valueOf(String.valueOf(new StringBuffer("TOP ").append(num).append(" 1\n"))));
            if (!this.readInput().substring(0, 3).equals("+OK")) {
                Debug.error(302, String.valueOf(String.valueOf(new StringBuffer("Problem reading header of message ").append(num).append(" from POP."))));
                Packet packet = null;
                return packet;
            }
            Packet p = new Packet();
            p.setType("EMAILHEADER");
            String tag = "";
            String val = "";
            while (!this.readInput().equals("")) {
                if (this.input.length() > 0 && this.input.charAt(0) != ' ' && this.input.charAt(0) != '\t') {
                    tag = this.input.substring(0, this.input.indexOf(58));
                    val = this.input.substring(this.input.indexOf(58) + 1, this.input.length());
                    while (val.length() > 0 && val.charAt(0) == ' ' && this.input.charAt(0) != '\t') {
                        val = val.substring(1, val.length());
                    }
                    p.setSegment(tag, new ValueString(val));
                    continue;
                }
                while (this.input.length() > 0 && this.input.charAt(0) == ' ') {
                    this.input = this.input.substring(1, this.input.length());
                }
                val = String.valueOf(String.valueOf(val)).concat(String.valueOf(String.valueOf(" ".concat(String.valueOf(String.valueOf(this.input))))));
                p.setSegment(tag, new ValueString(val));
            }
            while (this.readInput().length() != 1 || this.input.length() == 1 && !this.input.substring(0, 1).equals(".")) {
            }
            p.addSegment("NUMBER", new ValueString(num));
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Successfully decoded POP header for message ").append(num).append(".\""))));
            Packet packet = p;
            return packet;
        }
        catch (Exception e) {
            Debug.error(302, String.valueOf(String.valueOf(new StringBuffer("Problem downloading header for message ").append(num).append(" from POP."))));
            e.printStackTrace();
            return null;
        }
    }

    public void deleteMessage(int num) {
        this.deleteMessage("".concat(String.valueOf(String.valueOf(num))));
    }

    public void deleteMessage(String num) {
        try {
            this.writeOutput(String.valueOf(String.valueOf(new StringBuffer("DELE ").append(num).append("\n"))));
            if (!this.readInput().substring(0, 3).equals("+OK")) {
                Debug.error(302, String.valueOf(String.valueOf(new StringBuffer("Problem deleting message ").append(num).append(" from POP."))));
                return;
            }
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Successfully deleted message ").append(num).append(".\""))));
        }
        catch (Exception e) {
            Debug.error(302, String.valueOf(String.valueOf(new StringBuffer("Problem deleting message ").append(num).append(" from POP."))));
            e.printStackTrace();
        }
    }

    public void connect(String user, String password) {
        try {
            this.pop = new Socket(InetAddress.getByName(this.serverName), this.port);
            this.in = new BufferedReader(new InputStreamReader(this.pop.getInputStream()));
            this.out = new OutputStreamWriter(this.pop.getOutputStream());
            if (!this.readInput().substring(0, 3).equals("+OK")) {
                Debug.error(302, "No POP ready on connection.");
                return;
            }
            this.writeOutput(String.valueOf(String.valueOf(new StringBuffer("USER ").append(user).append("\n"))));
            if (!this.readInput().substring(0, 3).equals("+OK")) {
                Debug.error(302, "POP user login command not accepted.");
                return;
            }
            this.writeOutput(String.valueOf(String.valueOf(new StringBuffer("PASS ").append(password).append("\n"))));
            if (!this.readInput().substring(0, 3).equals("+OK")) {
                Debug.error(302, "POP password not accepted.");
                return;
            }
            Debug.log(1, "\"Successfully logged into POP e-mail server.\"");
        }
        catch (Exception e) {
            Debug.error(302, "Error occurred while attempting to connect to POP server.");
        }
    }

    public void disconnect() {
        try {
            if (this.pop != null) {
                this.pop.close();
                this.pop = null;
                this.in = null;
                this.out = null;
                Debug.log(1, "\"Successfully logged out of POP e-mail server.\"");
            }
        }
        catch (Exception e) {
            Debug.error(302, "Error occurred while attempting to disconnect from POP server.");
        }
    }
}

