/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli;

import X10Gimli.Command.AssignCommand;
import X10Gimli.Command.BeginCommand;
import X10Gimli.Command.CaseCommand;
import X10Gimli.Command.Command;
import X10Gimli.Command.DefineCommand;
import X10Gimli.Command.ElseCommand;
import X10Gimli.Command.ForCommand;
import X10Gimli.Command.ForEachCommand;
import X10Gimli.Command.FuncCommand;
import X10Gimli.Command.IfCommand;
import X10Gimli.Command.MotionCommand;
import X10Gimli.Command.NewCommand;
import X10Gimli.Command.ReturnCommand;
import X10Gimli.Command.TriggerCommand;
import X10Gimli.Command.UserCommand;
import X10Gimli.Command.WhileCommand;
import X10Gimli.Debug;
import X10Gimli.Scanner;
import X10Gimli.System.Control;
import X10Gimli.System.Definition;
import X10Gimli.System.Environment;
import X10Gimli.System.Function;
import X10Gimli.System.Mode;
import X10Gimli.System.Switch;
import X10Gimli.System.SystemModel;
import X10Gimli.System.Trigger;
import X10Gimli.Token;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueFunction;
import X10Gimli.Value.ValueIdent;
import X10Gimli.Value.ValueItem;
import X10Gimli.Value.ValueList;
import X10Gimli.Value.ValueOp;
import X10Gimli.Value.ValueString;
import X10Gimli.Value.ValueType;
import java.util.ArrayList;

public class Parser {
    private Token token;
    private Scanner scanner = new Scanner();

    public void setInputFile(String file) {
        this.scanner.initFile(file);
        this.token = this.scanner.nextToken();
    }

    public void setInputString(String input) {
        this.scanner.initString(input);
        this.token = this.scanner.nextToken();
    }

    private void nextToken() {
        this.token = this.scanner.nextToken();
        if (this.token.typePrimary == 32) {
            this.parseError("Invalid token : ".concat(String.valueOf(String.valueOf(this.token.value))), 1);
        }
    }

    private void parseError(String s, int err) {
        Debug.error(200 + err, String.valueOf(String.valueOf(new StringBuffer("(Parser) ").append(s).append(" ==> ").append(this.token.value).append(" ").append(this.token.lineCount).append(":").append(this.token.charCount - this.token.value.length()))));
    }

    private boolean tokenCheck(int prim) {
        return (prim & this.token.typePrimary) != 0;
    }

    private boolean tokenCheck(int prim, int sec) {
        return (prim & this.token.typePrimary) != 0 && (sec & this.token.typeSecondary) != 0;
    }

    private boolean tokenCheck(int prim, String str, int err) {
        if (!this.tokenCheck(prim)) {
            this.parseError(str, err);
        }
        return this.tokenCheck(prim);
    }

    private boolean tokenCheck(int prim, int sec, String str, int err) {
        if (!this.tokenCheck(prim, sec)) {
            this.parseError(str, err);
        }
        return this.tokenCheck(prim, sec);
    }

    private void advanceTokens(int prim, int sec) {
        while (!this.tokenCheck(prim, sec) && !this.tokenCheck(16)) {
            this.nextToken();
        }
    }

    private void advanceTokens(int prim) {
        while (!this.tokenCheck(prim) && !this.tokenCheck(16)) {
            this.nextToken();
        }
    }

    private void advanceTokens(TokenSet tok) {
        this.advanceTokens(tok.prim, tok.sec);
    }

    public SystemModel productionX10Gimli() {
        SystemModel s = new SystemModel();
        this.productionX10Gimli(s);
        return s;
    }

    public String productionImport() {
        return this.productionImport(new TokenSet(0, 0));
    }

    public Definition productionDefinition() {
        return this.productionDefinition(new TokenSet(0, 0));
    }

    public ArrayList productionDefinitionList() {
        ArrayList definitions = new ArrayList();
        this.productionDefinitionList(definitions, new TokenSet(0, 0));
        return definitions;
    }

    public Function productionFunction() {
        return this.productionFunction(new TokenSet(0, 0));
    }

    public Trigger productionTrigger() {
        return this.productionTrigger(new TokenSet(0, 0));
    }

    public Mode productionMode() {
        return this.productionMode(new TokenSet(0, 0));
    }

    public Control productionControl() {
        return this.productionControl(new TokenSet(0, 0));
    }

    public Switch productionSwitch() {
        return this.productionSwitch(new TokenSet(0, 0));
    }

    public Command productionCommand() {
        return this.productionCommand(new TokenSet(0, 0));
    }

    public SystemModel productionX10Gimli(SystemModel model) {
        TokenSet tok = new TokenSet(7, 1250095);
        Debug.log(1, "\"Parsing input...\"");
        if (!this.tokenCheck(4, 1, "Expecting 'X10GIMLI' to begin X10 definition file.", 2)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        tok.setOff(2, 0x100000);
        if (!this.tokenCheck(2, 0x100000, "Expecting title identifier.", 3)) {
            this.advanceTokens(tok);
            model.setTitle("NoTitle");
        } else {
            model.setTitle(this.token.value);
            this.nextToken();
        }
        tok.setOff(0, 8);
        if (!this.tokenCheck(1, 8, String.valueOf(String.valueOf(new StringBuffer("Expecting ';' after title \"").append(model.getTitle()).append("\"."))), 4)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        tok.setOff(0, 197164);
        model.setEnvironment(this.productionX10GimliEnv(tok.copy(tok)));
        tok.setOff(0, 256);
        model.setModes(this.productionModes(tok.copy(tok)));
        tok.setOff(0, 2);
        if (!this.tokenCheck(4, 2, "Expecting 'END' to terminate X10 definition file.", 5)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        tok.setOff(4, 2);
        if (!this.tokenCheck(4, 1, "Expecting 'X10GIMLI' for conclusion of declarations.", 2)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        tok.setOff(1, 4096);
        if (!this.tokenCheck(1, 4096, "Expecting '.' terminator at end of source file.", 6)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        return model;
    }

    private Environment productionX10GimliEnv(TokenSet tok) {
        Environment env = new Environment();
        tok.setOff(0, 0x400000);
        env.setImports(this.productionImports(tok.copy(tok)));
        tok.setOff(0, 4);
        env.setDefinitions(this.productionDefinitions(tok.copy(tok)));
        tok.setOff(0, 8);
        env.setFunctions(this.productionFunctions(tok.copy(tok)));
        tok.setOff(0, 32);
        env.setTriggers(this.productionTriggers(tok.copy(tok)));
        tok.setOff(0, 65536);
        env.setStartCommand(this.productionStartBlock(tok.copy(tok)));
        tok.setOff(0, 512);
        env.setControls(this.productionControls(tok.copy(tok)));
        tok.setOff(0, 131072);
        env.setFinishCommand(this.productionFinishBlock(tok.copy(tok)));
        return env;
    }

    private ArrayList productionImports(TokenSet tok) {
        ArrayList imports = new ArrayList();
        if (this.tokenCheck(4, 0x400000)) {
            this.nextToken();
            this.productionImportList(imports, tok.copy(tok));
        }
        return imports;
    }

    private void productionImportList(ArrayList imports, TokenSet tok) {
        if (this.tokenCheck(8, 4)) {
            imports.add(this.productionImport(tok.copy(tok)));
            this.productionImportList(imports, tok.copy(tok));
        }
    }

    private String productionImport(TokenSet tok) {
        tok.setOn(11, 1049611);
        String name = "NOIMPORT";
        if (!this.tokenCheck(8, 4, "Expecting filename string for import.", 7)) {
            this.advanceTokens(tok);
        } else {
            name = this.token.value;
            this.nextToken();
        }
        tok.setOff(0, 8);
        if (!this.tokenCheck(1, 8, String.valueOf(String.valueOf(new StringBuffer("Expecting ';' to conclude import declaration of \"").append(name).append("\"."))), 4)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        return name;
    }

    private ArrayList productionDefinitions(TokenSet tok) {
        ArrayList definitions = new ArrayList();
        if (this.tokenCheck(4, 4)) {
            this.nextToken();
            this.productionDefinitionList(definitions, tok.copy(tok));
        }
        return definitions;
    }

    private void productionDefinitionList(ArrayList definitions, TokenSet tok) {
        if (this.tokenCheck(2, 0x100000)) {
            definitions.add(this.productionDefinition(tok.copy(tok)));
            this.productionDefinitionList(definitions, tok.copy(tok));
        }
    }

    private Definition productionDefinition(TokenSet tok) {
        tok.setOn(11, 1049611);
        Definition definition = new Definition();
        String name = "NODEFINITION";
        if (!this.tokenCheck(2, 0x100000, "Expecting new identifier for variable definition.", 8)) {
            this.advanceTokens(tok);
        } else {
            name = this.token.value;
            this.nextToken();
        }
        definition.setName(name);
        tok.setOff(8, 1027);
        if (!this.tokenCheck(1, 16, String.valueOf(String.valueOf(new StringBuffer("Expecting '=' in definition of \"").append(name).append("\"."))), 9)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        definition.setValue(this.productionValues(null, tok.copy(tok)));
        tok.setOff(0, 8);
        if (!this.tokenCheck(1, 8, String.valueOf(String.valueOf(new StringBuffer("Expecting ';' to conclude definition of \"").append(name).append("\"."))), 4)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        return definition;
    }

    private ArrayList productionFunctions(TokenSet tok) {
        ArrayList functions = new ArrayList();
        if (this.tokenCheck(4, 8)) {
            this.nextToken();
            this.productionFunctionList(functions, tok.copy(tok));
        }
        return functions;
    }

    private void productionFunctionList(ArrayList functions, TokenSet tok) {
        if (this.tokenCheck(2, 0x100000)) {
            functions.add(this.productionFunction(tok.copy(tok)));
            this.productionFunctionList(functions, tok.copy(tok));
        }
    }

    private Function productionFunction(TokenSet tok) {
        tok.setOn(11, 62698527);
        Function function = new Function();
        if (!this.tokenCheck(2, 0x100000, "Expecting new identifier for new function declaration.", 8)) {
            this.advanceTokens(tok);
        } else {
            function.setName(this.token.value);
            this.nextToken();
        }
        tok.setOff(0, 6);
        function.setIdents(this.productionIdents(tok.copy(tok)));
        tok.setOff(0, 62698512);
        function.setCommand(this.productionCommand(tok.copy(tok)));
        return function;
    }

    private ArrayList productionTriggers(TokenSet tok) {
        ArrayList triggers = new ArrayList();
        if (this.tokenCheck(4, 32)) {
            this.nextToken();
            this.productionTriggerList(triggers, tok.copy(tok));
        }
        return triggers;
    }

    private void productionTriggerList(ArrayList triggers, TokenSet tok) {
        if (this.tokenCheck(2, 0x100000) || this.tokenCheck(1, 2)) {
            triggers.add(this.productionTrigger(tok.copy(tok)));
            this.productionTriggerList(triggers, tok.copy(tok));
        }
    }

    private Trigger productionTrigger(TokenSet tok) {
        Trigger trigger = new Trigger();
        if (this.tokenCheck(2, 0x100000)) {
            trigger.setName(this.token.value);
            this.nextToken();
        }
        if (!this.tokenCheck(1, 2, "Expecting '(' before expression in trigger definition.", 10)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        trigger.setCase(this.productionValues(null, tok.copy(tok)));
        if (!this.tokenCheck(1, 4, "Expecting ')' after expression in trigger definition.", 11)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        if (!this.tokenCheck(4, 16384, "Expecting 'do' before command blcok in trigger definition.", 12)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        trigger.setCommand(this.productionCommand(tok.copy(tok)));
        return trigger;
    }

    private ArrayList productionModes(TokenSet tok) {
        ArrayList modes = new ArrayList();
        this.productionModeList(modes, tok.copy(tok));
        return modes;
    }

    private void productionModeList(ArrayList modes, TokenSet tok) {
        if (this.tokenCheck(4, 256)) {
            modes.add(this.productionMode(tok.copy(tok)));
            this.productionModeList(modes, tok.copy(tok));
        }
    }

    private Mode productionMode(TokenSet tok) {
        Mode mode = new Mode();
        if (!this.tokenCheck(4, 256, "Expecting 'MODE'.", 13)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        if (!this.tokenCheck(2, 0x100000, "Expecting new identifier to define mode name.", 8)) {
            this.advanceTokens(tok);
        } else {
            mode.setName(this.token.value);
            this.nextToken();
        }
        mode.setEnvironment(this.productionX10GimliEnv(tok.copy(tok)));
        return mode;
    }

    private Command productionStartBlock(TokenSet tok) {
        Command command = null;
        if (this.tokenCheck(4, 65536)) {
            this.nextToken();
            command = this.productionCommand(tok.copy(tok));
        }
        return command;
    }

    private Command productionFinishBlock(TokenSet tok) {
        Command command = null;
        if (this.tokenCheck(4, 131072)) {
            this.nextToken();
            command = this.productionCommand(tok.copy(tok));
        }
        return command;
    }

    private ArrayList productionControls(TokenSet tok) {
        ArrayList controls = new ArrayList();
        this.productionControlList(controls, tok.copy(tok));
        return controls;
    }

    private void productionControlList(ArrayList controls, TokenSet tok) {
        if (this.tokenCheck(4, 512)) {
            controls.add(this.productionControl(tok.copy(tok)));
            this.productionControlList(controls, tok.copy(tok));
        }
    }

    private Control productionControl(TokenSet tok) {
        Control control = new Control();
        if (!this.tokenCheck(4, 512, "Expecting 'CONTROL'.", 14)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        if (!this.tokenCheck(1, 64) && this.token.value.equals("<")) {
            this.parseError("Expecting '<' before control identifier.", 15);
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        ArrayList values = new ArrayList();
        this.productionSwitchValueList(values, tok.copy(tok));
        control.setID(values);
        if (!this.tokenCheck(1, 64) && this.token.value.equals(">")) {
            this.parseError("Expecting '>' after control identifier.", 16);
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        control.setSwitches(this.productionSwitches(tok.copy(tok)));
        return control;
    }

    private ArrayList productionSwitches(TokenSet tok) {
        ArrayList switches = new ArrayList();
        this.productionSwitchList(switches, tok.copy(tok));
        return switches;
    }

    private void productionSwitchList(ArrayList switches, TokenSet tok) {
        if (this.tokenCheck(1, 128)) {
            switches.add(this.productionSwitch(tok.copy(tok)));
            this.productionSwitchList(switches, tok.copy(tok));
        }
    }

    private Switch productionSwitch(TokenSet tok) {
        Switch x10switch = new Switch();
        if (!this.tokenCheck(1, 128, "Expecting '[' before switch identifiers.", 17)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        ArrayList values = new ArrayList();
        this.productionSwitchValueList(values, tok.copy(tok));
        x10switch.setID(values);
        if (!this.tokenCheck(1, 256, "Expecting ']' after switch identifiers.", 18)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        x10switch.setCommand(this.productionCommand(tok.copy(tok)));
        return x10switch;
    }

    private ValueType productionSwitchValue(TokenSet tok) {
        return this.productionVariable(tok.copy(tok));
    }

    private void productionSwitchValueList(ArrayList values, TokenSet tok) {
        values.add(this.productionSwitchValue(tok.copy(tok)));
        if (this.tokenCheck(1, 1)) {
            this.nextToken();
            this.productionSwitchValueList(values, tok.copy(tok));
        }
    }

    private void productionCommandList(ArrayList commands, TokenSet tok) {
        if (this.tokenCheck(2, 0x100001) || this.tokenCheck(4, 62698512)) {
            commands.add(this.productionCommand(tok.copy(tok)));
            this.productionCommandList(commands, tok.copy(tok));
        }
    }

    private Command productionCommand(TokenSet tok) {
        if (this.tokenCheck(2, 1)) {
            return this.productionFuncCommand(tok.copy(tok));
        }
        if (this.tokenCheck(2, 0x100000) || this.tokenCheck(8) || this.tokenCheck(2, 2) || this.tokenCheck(1, 1026)) {
            return this.productionIdentCommand(tok.copy(tok));
        }
        if (this.tokenCheck(4, 1024)) {
            return this.productionIfCommand(tok.copy(tok));
        }
        if (this.tokenCheck(4, 8192)) {
            return this.productionWhileCommand(tok.copy(tok));
        }
        if (this.tokenCheck(4, 32768)) {
            return this.productionTriggerCommand(tok.copy(tok));
        }
        if (this.tokenCheck(4, 262144)) {
            return this.productionMotionCommand(tok.copy(tok));
        }
        if (this.tokenCheck(4, 16)) {
            return this.productionBeginCommand(tok.copy(tok));
        }
        if (this.tokenCheck(4, 524288)) {
            return this.productionReturnCommand(tok.copy(tok));
        }
        if (this.tokenCheck(4, 0x100000)) {
            return this.productionNewCommand(tok.copy(tok));
        }
        if (this.tokenCheck(4, 0x200000)) {
            return this.productionDefineCommand(tok.copy(tok));
        }
        if (this.tokenCheck(4, 0x800000)) {
            return this.productionForCommand(tok.copy(tok));
        }
        if (this.tokenCheck(4, 0x1000000)) {
            return this.productionForEachCommand(tok.copy(tok));
        }
        if (this.tokenCheck(4, 0x2000000)) {
            return this.productionCaseCommand(tok.copy(tok));
        }
        this.parseError("Expecting valid command statement.", 19);
        this.advanceTokens(tok);
        return null;
    }

    private Command productionBeginCommand(TokenSet tok) {
        BeginCommand command = new BeginCommand();
        if (this.tokenCheck(4, 16)) {
            this.nextToken();
            this.productionCommandList(command.getCommands(), tok.copy(tok));
            if (!this.tokenCheck(4, 2, "Expecting corresponding 'END' of 'BEGIN' block.", 5)) {
                this.advanceTokens(tok);
            } else {
                this.nextToken();
            }
        } else {
            this.parseError("Expecting a command or command list.", 19);
            this.advanceTokens(tok);
        }
        return command;
    }

    private FuncCommand productionFuncCommand(TokenSet tok) {
        FuncCommand f = this.productionFunctionCall(tok.copy(tok));
        if (!this.tokenCheck(1, 8, String.valueOf(String.valueOf(new StringBuffer("Expecting ';' after function call \"").append(f.getCommand()).append("\"."))), 4)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        return f;
    }

    private IfCommand productionIfCommand(TokenSet tok) {
        IfCommand command = new IfCommand();
        if (!this.tokenCheck(4, 1024, "Expecting 'if' to begin conditional command statement.", 20)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        command.setCondition(this.productionValues(null, tok.copy(tok)));
        if (!this.tokenCheck(4, 2048, "Expecting 'then' after conditional expression in 'if' statement.", 21)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        command.setCommand(this.productionCommand(tok.copy(tok)));
        command.setElseCommand(this.productionElseCommand(tok.copy(tok)));
        return command;
    }

    private ElseCommand productionElseCommand(TokenSet tok) {
        ElseCommand command = new ElseCommand();
        if (this.tokenCheck(4, 4096)) {
            this.nextToken();
            command.setCommand(this.productionCommand(tok.copy(tok)));
        }
        return command;
    }

    private WhileCommand productionWhileCommand(TokenSet tok) {
        WhileCommand command = new WhileCommand();
        if (!this.tokenCheck(4, 8192, "Expecting 'while' statement.", 22)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        command.setCondition(this.productionValues(null, tok.copy(tok)));
        if (!this.tokenCheck(4, 16384, "Expecting 'do' after conditional expression in 'while' statement.", 12)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        command.setCommand(this.productionCommand(tok.copy(tok)));
        return command;
    }

    private TriggerCommand productionTriggerCommand(TokenSet tok) {
        TriggerCommand command = new TriggerCommand();
        if (!this.tokenCheck(4, 32768, "Expecting 'trigger' statement.", 23)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        command.setTrigger(this.productionTrigger(tok.copy(tok)));
        return command;
    }

    private Command productionIdentCommand(TokenSet tok) {
        ValueType ident = new ValueString("NOIDENT");
        if (this.tokenCheck(2, 0x100000) || this.tokenCheck(8) || this.tokenCheck(2, 2) || this.tokenCheck(1, 1026)) {
            ident = this.productionVariable(tok.copy(tok));
        } else {
            this.parseError("Expecting a variable identifier in assignment statement or function call.", 24);
            this.advanceTokens(tok);
        }
        if (this.tokenCheck(1, 16)) {
            AssignCommand command = new AssignCommand();
            command.setIdent(ident);
            this.nextToken();
            command.setAssign(this.productionValues(null, tok.copy(tok)));
            if (!this.tokenCheck(1, 8, "Expecting ';' to complete assignment statement.", 4)) {
                this.advanceTokens(tok);
            } else {
                this.nextToken();
            }
            return command;
        }
        if (ident instanceof ValueFunction) {
            if (!this.tokenCheck(1, 8, "Expecting ';' after function call.", 4)) {
                this.advanceTokens(tok);
            } else {
                this.nextToken();
            }
            return ((ValueFunction)ident).getFunction();
        }
        this.parseError(String.valueOf(String.valueOf(new StringBuffer("Expecting '=' or '(' in identifier expression \"").append(ident).append("\"."))), 25);
        this.advanceTokens(tok);
        return null;
    }

    private Command productionReturnCommand(TokenSet tok) {
        ReturnCommand command = new ReturnCommand();
        if (!this.tokenCheck(4, 524288, "Expecting 'return' statement.", 26)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        command.setValue(this.productionValues(null, tok.copy(tok)));
        if (!this.tokenCheck(1, 8, "Expecting ';' at the end of 'return' statement.", 4)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        return command;
    }

    private MotionCommand productionMotionCommand(TokenSet tok) {
        MotionCommand command = new MotionCommand();
        if (!this.tokenCheck(4, 262144, "Expecting 'motion' statement.", 27)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        command.setID(this.productionVariable(tok.copy(tok)));
        if (this.tokenCheck(2, 0x100000) || this.tokenCheck(8) || this.tokenCheck(2, 2) || this.tokenCheck(1, 1026)) {
            command.setTime(this.productionVariable(tok.copy(tok)));
        }
        tok.setOff(0, 8);
        if (!this.tokenCheck(1, 8, "Expecting ';' after motion trigger identifier and time delay.", 4)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        command.setStartCommand(this.productionStartBlock(tok.copy(tok)));
        command.setFinishCommand(this.productionFinishBlock(tok.copy(tok)));
        return command;
    }

    private Command productionDefineCommand(TokenSet tok) {
        DefineCommand command = new DefineCommand();
        if (!this.tokenCheck(4, 0x200000, "Expecting 'define' statement.", 28)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        command.setDefinition(this.productionDefinition(tok.copy(tok)));
        return command;
    }

    private Command productionNewCommand(TokenSet tok) {
        NewCommand command = new NewCommand();
        if (!this.tokenCheck(4, 0x100000, "Expecting 'new' statement.", 29)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        command.setDefinition(this.productionDefinition(tok.copy(tok)));
        return command;
    }

    private Command productionForCommand(TokenSet tok) {
        ForCommand command = new ForCommand();
        if (!this.tokenCheck(4, 0x800000, "Expecting 'for' statement.", 29)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        if (!this.tokenCheck(2, 0x100000, "Expecting variable identifier for 'for' loop.", 0)) {
            this.advanceTokens(tok);
        } else {
            command.setIdentifier(this.token.value);
            this.nextToken();
        }
        if (!this.tokenCheck(1, 16, "Expecting '=' in definition of 'for' loop.", 9)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        command.setLowValue(this.productionValues(null, tok.copy(tok)));
        if (!this.tokenCheck(4, 0x8000000, "Expecting 'to' in definition of 'for' loop.", 9)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        command.setHighValue(this.productionValues(null, tok.copy(tok)));
        if (!this.tokenCheck(4, 16384, "Expecting 'do' before command block in 'for' loop definition.", 12)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        command.setCommand(this.productionCommand(tok.copy(tok)));
        return command;
    }

    private Command productionForEachCommand(TokenSet tok) {
        ForEachCommand command = new ForEachCommand();
        if (!this.tokenCheck(4, 0x1000000, "Expecting 'foreach' statement.", 29)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        if (!this.tokenCheck(2, 0x100000, "Expecting variable identifier for 'foreach' loop.", 0)) {
            this.advanceTokens(tok);
        } else {
            command.setIdentifier(this.token.value);
            this.nextToken();
        }
        if (!this.tokenCheck(4, 0x4000000, "Expecting 'of' in definition of 'foreach' loop.", 9)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        command.setValue(this.productionValues(null, tok.copy(tok)));
        if (!this.tokenCheck(4, 16384, "Expecting 'do' before command block in 'foreach' loop definition.", 12)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        command.setCommand(this.productionCommand(tok.copy(tok)));
        return command;
    }

    private Command productionCaseCommand(TokenSet tok) {
        CaseCommand command = new CaseCommand();
        if (!this.tokenCheck(4, 0x2000000, "Expecting 'case' statement.", 29)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        command.setValue(this.productionValues(null, tok.copy(tok)));
        if (!this.tokenCheck(4, 0x4000000, "Expecting 'of' in definition of 'case' statement.", 9)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        this.productionCaseList(command, tok.copy(tok));
        return command;
    }

    private void productionCaseList(CaseCommand command, TokenSet tok) {
        if (this.tokenCheck(4, 2)) {
            this.nextToken();
        } else {
            ValueType val = this.productionValues(null, tok.copy(tok));
            if (!this.tokenCheck(1, 8192, String.valueOf(String.valueOf(new StringBuffer("Expecting ':' after case \"").append(val.string).append("\"."))), 0)) {
                this.advanceTokens(tok);
            } else {
                this.nextToken();
            }
            Command comm = this.productionCommand(tok.copy(tok));
            command.addCase(val, comm);
            this.productionCaseList(command, tok.copy(tok));
        }
    }

    private FuncCommand productionFunctionCall(TokenSet tok) {
        String command = "";
        if (!this.tokenCheck(2, 1, "Expecting function identifier in statement.", 30)) {
            this.advanceTokens(tok);
        } else {
            command = this.token.value;
            this.nextToken();
        }
        ArrayList params = this.productionParams(tok.copy(tok));
        return FuncCommand.InitCommand(command, params);
    }

    private ValueType productionValues(ValueOp valueop, TokenSet tok) {
        ValueType value = this.productionVariable(tok.copy(tok));
        if (valueop != null) {
            valueop.setRight(value);
            return this.productionValueList(valueop, tok.copy(tok));
        }
        return this.productionValueList(value, tok.copy(tok));
    }

    private ValueType productionValueList(ValueType valueleft, TokenSet tok) {
        if (this.tokenCheck(1, 608)) {
            ValueOp value = new ValueOp();
            value.setLeft(valueleft);
            value.setOp(this.token.value);
            this.nextToken();
            return this.productionValues(value, tok.copy(tok));
        }
        return valueleft;
    }

    private ArrayList productionParams(TokenSet tok) {
        ArrayList params = new ArrayList();
        if (!this.tokenCheck(1, 2, "Expecting '(' before parameter declaration.", 10)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        if (!this.tokenCheck(1, 4)) {
            this.productionParamList(params, tok.copy(tok));
        }
        if (!this.tokenCheck(1, 4, "Expecting ')' after parameter declaration.", 11)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        return params;
    }

    private void productionParamList(ArrayList params, TokenSet tok) {
        if (this.tokenCheck(2, 0x100001) || this.tokenCheck(8) || this.tokenCheck(2, 2) || this.tokenCheck(1, 1026)) {
            params.add(this.productionParam(tok.copy(tok)));
        } else {
            this.advanceTokens(tok);
        }
        if (this.tokenCheck(1, 1)) {
            this.nextToken();
            this.productionParamList(params, tok.copy(tok));
        }
    }

    private ValueType productionParam(TokenSet tok) {
        return this.productionValues(null, tok.copy(tok));
    }

    private ArrayList productionIdents(TokenSet tok) {
        tok.setOn(0, 5);
        ArrayList idents = new ArrayList();
        if (!this.tokenCheck(1, 2, "Expecting '(' before identifiers in new function declaration.", 10)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        if (!this.tokenCheck(1, 4)) {
            this.productionIdentList(idents, tok.copy(tok));
        }
        tok.setOff(0, 4);
        if (!this.tokenCheck(1, 4, "Expecting ')' after identifiers in new function declaration.", 11)) {
            this.advanceTokens(tok);
        } else {
            this.nextToken();
        }
        return idents;
    }

    private void productionIdentList(ArrayList idents, TokenSet tok) {
        if (!this.tokenCheck(2, 0x100000, "Expecting identifier in new function parameter list.", 8)) {
            this.advanceTokens(tok);
        } else {
            idents.add(Value.getValue(this.token));
            this.nextToken();
        }
        if (this.tokenCheck(1, 1)) {
            this.nextToken();
            this.productionIdentList(idents, tok.copy(tok));
        }
    }

    private ValueType productionVariable(TokenSet tok) {
        ValueType val = null;
        if (this.tokenCheck(8)) {
            val = Value.getValue(this.token);
            this.nextToken();
        } else if (this.tokenCheck(2, 0x100002)) {
            val = ValueIdent.getPreDefined(this.token.value);
            this.nextToken();
            if (this.tokenCheck(1, 2)) {
                if (val != null) {
                    UserCommand command = new UserCommand();
                    command.setCommand(val.getValue(null).getValueString());
                    command.setParams(this.productionParams(tok.copy(tok)));
                    val = new ValueFunction(command);
                } else {
                    this.parseError("Illegal value for function expression.", 33);
                }
            } else {
                val = this.productionVariableItem(val, tok.copy(tok));
            }
        } else if (this.tokenCheck(1, 2)) {
            this.nextToken();
            val = this.productionValues(null, tok.copy(tok));
            if (!this.tokenCheck(1, 4, "Expecting ')' to end value expression.", 11)) {
                this.advanceTokens(tok);
            } else {
                this.nextToken();
            }
            val = this.productionVariableItem(val, tok.copy(tok));
        } else if (this.tokenCheck(1, 1024)) {
            this.nextToken();
            val = new ValueList(this.productionVariables(tok.copy(tok)));
            if (!this.tokenCheck(1, 2048, "Expecting '}' to end list declaration.", 31)) {
                this.advanceTokens(tok);
            } else {
                this.nextToken();
            }
            val = this.productionVariableItem(val, tok.copy(tok));
        } else if (this.tokenCheck(2, 1)) {
            val = new ValueFunction(this.productionFunctionCall(tok.copy(tok)));
        } else {
            this.parseError("Expecting variable or value expression.", 232);
            this.advanceTokens(tok);
        }
        return val;
    }

    private ValueType productionSubVariable(TokenSet tok) {
        ValueType val = null;
        if (this.tokenCheck(8)) {
            val = Value.getValue(this.token);
            this.nextToken();
        } else if (this.tokenCheck(2, 0x100002)) {
            val = ValueIdent.getPreDefined(this.token.value);
            this.nextToken();
            if (this.tokenCheck(1, 2)) {
                if (val != null) {
                    UserCommand command = new UserCommand();
                    command.setCommand(val.getValue(null).getValueString());
                    command.setParams(this.productionParams(tok.copy(tok)));
                    val = new ValueFunction(command);
                } else {
                    this.parseError("Illegal value for function expression.", 33);
                }
            }
        } else if (this.tokenCheck(1, 2)) {
            this.nextToken();
            val = this.productionValues(null, tok.copy(tok));
            if (!this.tokenCheck(1, 4, "Expecting ')' to end value expression.", 11)) {
                this.advanceTokens(tok);
            } else {
                this.nextToken();
            }
        } else if (this.tokenCheck(1, 1024)) {
            this.nextToken();
            val = new ValueList(this.productionVariables(tok.copy(tok)));
            if (!this.tokenCheck(1, 2048, "Expecting '}' to end list declaration.", 31)) {
                this.advanceTokens(tok);
            } else {
                this.nextToken();
            }
        } else if (this.tokenCheck(2, 1)) {
            val = new ValueFunction(this.productionFunctionCall(tok.copy(tok)));
        } else {
            this.parseError("Expecting variable or value expression.", 232);
            this.advanceTokens(tok);
        }
        return val;
    }

    private ArrayList productionVariables(TokenSet tok) {
        ArrayList params = new ArrayList();
        if (this.tokenCheck(2, 0x100000) || this.tokenCheck(2, 1) || this.tokenCheck(8) || this.tokenCheck(2, 2) || this.tokenCheck(1, 1026)) {
            this.productionParamList(params, tok.copy(tok));
        }
        return params;
    }

    private ValueType productionVariableItem(ValueType list, TokenSet tok) {
        if (this.tokenCheck(1, 128)) {
            this.nextToken();
            ValueItem item = new ValueItem(list, this.productionVariable(tok.copy(tok)), 1);
            if (!this.tokenCheck(1, 256, "Expecting ']' after list item expression.", 218)) {
                this.advanceTokens(tok);
            } else {
                this.nextToken();
            }
            return this.productionVariableItem(item, tok.copy(tok));
        }
        if (this.tokenCheck(1, 4096)) {
            this.nextToken();
            ValueIdent ident = new ValueIdent(this.productionSubVariable(tok.copy(tok)).getValue(null).getValueString());
            ValueItem item = new ValueItem(list, ident, 2);
            return this.productionVariableItem(item, tok.copy(tok));
        }
        return list;
    }

    private class TokenSet {
        int prim;
        int sec;

        public TokenSet(int p, int s) {
            this.prim = p;
            this.sec = s;
        }

        public TokenSet copy(TokenSet tok) {
            return new TokenSet(tok.prim, tok.sec);
        }

        public void setOn(int p, int s) {
            this.prim |= p;
            this.sec |= s;
        }

        public void setOff(int p, int s) {
            this.prim &= ~p;
            this.sec &= ~s;
        }
    }
}

