/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import tools.BaseApplet;
import tools.BaseThread;
import tools.Globals;
import tools.TimerThread;
import tools.TypeConverter;
import tools.Var;

public final class VarMonitor {
    private static Hashtable vars = new Hashtable();
    private static long time;
    public static Object INVALID;

    public static void register(String string, Var var, BaseApplet baseApplet, boolean bl) {
        String string2 = var.getName();
        if (string2 == null) {
            return;
        }
        String string3 = String.valueOf(string) + "$" + string2;
        Hashtable hashtable = vars;
        synchronized (hashtable) {
            if (bl) {
                if (vars.get(string3) == null) {
                    vars.put(string3, var);
                } else {
                    System.out.println("duplicate name '" + string2 + "'");
                    vars.clear();
                }
            } else if (vars.get(string3) == var) {
                vars.remove(string3);
            } else {
                vars.clear();
            }
            vars.notifyAll();
        }
        time = System.currentTimeMillis();
    }

    public static void radio(Var var) {
        String string = var.getRadioGroup();
        if (string == null) {
            return;
        }
        var.set(Boolean.TRUE, var.getRadioField());
        Hashtable hashtable = vars;
        synchronized (hashtable) {
            Enumeration enumeration = vars.elements();
            while (enumeration.hasMoreElements()) {
                Var var2 = (Var)enumeration.nextElement();
                if (var2 == var || !string.equals(var2.getRadioGroup())) continue;
                var2.set(Boolean.FALSE, var2.getRadioField());
            }
            return;
        }
    }

    static String[] parseVarName(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = new String[2];
        int n = string.indexOf(46);
        if (n != -1) {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 1);
        } else {
            stringArray[0] = string;
            stringArray[1] = null;
        }
        return stringArray;
    }

    static int globalNumber(String string) {
        if (!string.startsWith("%") || string.length() < 2) {
            return -1;
        }
        return Integer.valueOf(string.substring(1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object get(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = n = !string.startsWith("%") || string.length() < 2 ? -1 : Integer.valueOf(string.substring(1));
        if (n != -1) {
            return Globals.get(n);
        }
        String[] stringArray = VarMonitor.parseVarName(string);
        BaseThread baseThread = (BaseThread)Thread.currentThread();
        String string2 = String.valueOf(baseThread.a._getDocPath()) + "$";
        String string3 = String.valueOf(string2) + stringArray[0];
        long l = System.currentTimeMillis();
        Hashtable hashtable = vars;
        synchronized (hashtable) {
            while (true) {
                if (baseThread.a.thread != baseThread) {
                    return INVALID;
                }
                Var var = (Var)vars.get(string3);
                if (var != null) {
                    return var.get(stringArray[1]);
                }
                Enumeration enumeration = vars.keys();
                while (enumeration.hasMoreElements()) {
                    Var var2;
                    String string4 = (String)enumeration.nextElement();
                    if (!string4.startsWith(string2) || !string.equals((var2 = (Var)vars.get(string4)).getRadioGroup()) || !TypeConverter.toBoolean(var2.get(var2.getRadioField()))) continue;
                    return new String(var2.getName());
                }
                if (System.currentTimeMillis() - Math.max(time, l) > 5000L) break;
                try {
                    vars.wait(250L);
                    continue;
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
        }
        System.out.println("unknown name '" + string + "'");
        baseThread.a.reload();
        return INVALID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void set(String string, Object object) {
        int n;
        if (string == null) {
            return;
        }
        int n2 = n = !string.startsWith("%") || string.length() < 2 ? -1 : Integer.valueOf(string.substring(1));
        if (n != -1) {
            Globals.set(n, object);
            return;
        }
        String[] stringArray = VarMonitor.parseVarName(string);
        BaseThread baseThread = (BaseThread)Thread.currentThread();
        String string2 = String.valueOf(baseThread.a._getDocPath()) + "$";
        String string3 = String.valueOf(string2) + stringArray[0];
        long l = System.currentTimeMillis();
        Hashtable hashtable = vars;
        synchronized (hashtable) {
            while (true) {
                if (baseThread.a.thread != baseThread) {
                    return;
                }
                Var var = (Var)vars.get(string3);
                if (var != null) {
                    var.set(object, stringArray[1]);
                    if (stringArray[1] != null) {
                        if (!stringArray[1].equals(var.getRadioField())) return;
                    }
                    VarMonitor.radio(var);
                    return;
                }
                if (System.currentTimeMillis() - Math.max(time, l) > 5000L) break;
                try {
                    vars.wait(250L);
                    continue;
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
        }
        System.out.println("unknown name '" + string + "'");
        baseThread.a.reload();
    }

    public static void let(String string, String string2) {
        VarMonitor.set(string, VarMonitor.get(string2));
    }

    public static String getString(String string) {
        Object object = VarMonitor.get(string);
        if (object == null) {
            return "";
        }
        if (!(object instanceof Double)) {
            return object.toString();
        }
        return TypeConverter.double2String((Double)object, 2, false, false, false, false);
    }

    public static String getString(String string, int n) {
        Object object = VarMonitor.get(string);
        if (object == null) {
            return "";
        }
        if (!(object instanceof Double)) {
            return object.toString();
        }
        return TypeConverter.double2String((Double)object, n, false, false, false, false);
    }

    public static String getString(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object = VarMonitor.get(string);
        if (object == null) {
            return "";
        }
        if (!(object instanceof Double)) {
            return object.toString();
        }
        return TypeConverter.double2String((Double)object, n, bl, bl2, bl3, bl4);
    }

    public static double getDouble(String string) {
        return TypeConverter.toDouble(VarMonitor.get(string));
    }

    public static double getDouble(String string, int n) {
        if (n < -100) {
            n = -100;
        }
        if (n > 100) {
            n = 100;
        }
        double d = Math.pow(10.0, n);
        return (double)Math.round(TypeConverter.toDouble(VarMonitor.get(string)) * d) / d;
    }

    public static int getInteger(String string) {
        return TypeConverter.toInteger(VarMonitor.get(string));
    }

    public static boolean getBoolean(String string) {
        return TypeConverter.toBoolean(VarMonitor.get(string));
    }

    public static Color getColor(String string) {
        Object object = VarMonitor.get(string);
        if (object == null) {
            return Color.black;
        }
        if (object instanceof Color) {
            return (Color)object;
        }
        return TypeConverter.parseColor(object.toString(), Color.black);
    }

    public static void setNull(String string) {
        VarMonitor.set(string, null);
    }

    public static void setString(String string, String string2) {
        VarMonitor.set(string, string2);
    }

    public static void setDouble(String string, double d) {
        VarMonitor.set(string, new Double(d));
    }

    public static void setInteger(String string, int n) {
        VarMonitor.set(string, new Integer(n));
    }

    public static void setBoolean(String string, boolean bl) {
        VarMonitor.set(string, new Boolean(bl));
    }

    public static void setColor(String string, Color color) {
        VarMonitor.set(string, color);
    }

    public static void setColor(String string, int n, int n2, int n3) {
        VarMonitor.set(string, new Color(n, n2, n3));
    }

    public static void setColor(String string, float f, float f2, float f3) {
        VarMonitor.set(string, new Color(f, f2, f3));
    }

    public static String parseString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) == '%' && n2 < n && Character.isDigit(string.charAt(n2))) {
                int n3;
                Object object;
                StringBuffer stringBuffer2 = new StringBuffer();
                while (n2 < n) {
                    c = string.charAt(n2);
                    if (!Character.isDigit(c)) break;
                    stringBuffer2.append(c);
                    ++n2;
                }
                stringBuffer.append((object = Globals.get(n3 = Integer.valueOf(new String(stringBuffer2)).intValue())) == null ? "" : (!(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false)));
                continue;
            }
            stringBuffer.append(c);
        }
        return new String(stringBuffer);
    }

    public static void link(String string, String string2, String string3) {
        if ("show".equals(string)) {
            VarMonitor.set(String.valueOf(string3) + ".min", null);
            VarMonitor.set(String.valueOf(string3) + ".max", null);
            VarMonitor.set(String.valueOf(string3) + ".step", null);
            String string4 = String.valueOf(string3) + ".step";
            String string5 = String.valueOf(string2) + ".step";
            VarMonitor.set(string4, VarMonitor.get(string5));
            string4 = String.valueOf(string3) + ".min";
            string5 = String.valueOf(string2) + ".min";
            VarMonitor.set(string4, VarMonitor.get(string5));
            string4 = String.valueOf(string3) + ".max";
            string5 = String.valueOf(string2) + ".max";
            VarMonitor.set(string4, VarMonitor.get(string5));
            VarMonitor.set(string3, VarMonitor.get(string2));
        }
        if (string2.equals(string)) {
            VarMonitor.set(string3, VarMonitor.get(string2));
        }
        if (string3.equals(string)) {
            VarMonitor.set(string2, VarMonitor.get(string3));
        }
    }

    public static void animate(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7) {
        if (string2.equals(string)) {
            String string8 = String.valueOf(string3) + ".min";
            VarMonitor.set(string3, VarMonitor.get(string8));
            string8 = String.valueOf(string3) + "Timer";
            TimerThread.doStart(string8, n);
        }
        if ((String.valueOf(string3) + "Timer").equals(string)) {
            String string9;
            double d;
            double d2 = TypeConverter.toDouble(VarMonitor.get(string3));
            String string10 = String.valueOf(string3) + ".step";
            double d3 = TypeConverter.toDouble(VarMonitor.get(string10));
            if ((d2 += d3) > (d = TypeConverter.toDouble(VarMonitor.get(string9 = String.valueOf(string3) + ".max")))) {
                d2 = d;
            }
            VarMonitor.set(string3, new Double(d2));
            if (string4 != null) {
                VarMonitor.set(string4, new Double(d2));
            }
            if (string5 != null) {
                VarMonitor.set(string5, new Double(d2));
            }
            if (string6 != null) {
                VarMonitor.set(string6, new Double(d2));
            }
            if (string7 != null) {
                VarMonitor.set(string7, new Double(d2));
            }
            if (d2 >= d) {
                String string11 = String.valueOf(string3) + "Timer";
                TimerThread.doStop(string11);
            }
        }
    }

    public static void animateReverse(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7) {
        if (string2.equals(string)) {
            String string8 = String.valueOf(string3) + ".max";
            VarMonitor.set(string3, VarMonitor.get(string8));
            string8 = String.valueOf(string3) + "TimerReverse";
            TimerThread.doStart(string8, n);
        }
        if ((String.valueOf(string3) + "TimerReverse").equals(string)) {
            String string9;
            double d;
            double d2 = TypeConverter.toDouble(VarMonitor.get(string3));
            String string10 = String.valueOf(string3) + ".step";
            double d3 = TypeConverter.toDouble(VarMonitor.get(string10));
            if ((d2 -= d3) < (d = TypeConverter.toDouble(VarMonitor.get(string9 = String.valueOf(string3) + ".min")))) {
                d2 = d;
            }
            VarMonitor.set(string3, new Double(d2));
            if (string4 != null) {
                VarMonitor.set(string4, new Double(d2));
            }
            if (string5 != null) {
                VarMonitor.set(string5, new Double(d2));
            }
            if (string6 != null) {
                VarMonitor.set(string6, new Double(d2));
            }
            if (string7 != null) {
                VarMonitor.set(string7, new Double(d2));
            }
            if (d2 <= d) {
                String string11 = String.valueOf(string3) + "TimerReverse";
                TimerThread.doStop(string11);
            }
        }
    }

    static {
        INVALID = new String("INVALID");
    }
}

