/*
 * Decompiled with CFR 0.152.
 */
package addressbook;

import addressbook.GenericAttribute;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Locale;
import java.util.StringTokenizer;

public class Name
extends GenericAttribute {
    String first;
    String middle;
    String major;
    String maiden;
    String nick;

    public Name(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        super(string, string4);
        this.first = this.assignWithDefault(string2);
        this.middle = this.assignWithDefault(string3);
        this.major = this.assignWithDefault(string6);
        this.maiden = this.assignWithDefault(string5);
        this.nick = this.assignWithDefault(string7);
    }

    public Name(String string) throws ParseException {
        this(null, null, null, null, null, null, null);
        this.parseName(string);
    }

    public String getLast() {
        return this.value;
    }

    public String getFirst() {
        return this.first;
    }

    public String getMiddle() {
        return this.middle;
    }

    public String getMajor() {
        return this.major;
    }

    public boolean equals(Object object) {
        if (object instanceof Name) {
            Name name = (Name)object;
            return this.value.equalsIgnoreCase(name.getLast()) && this.first.equalsIgnoreCase(name.getFirst()) && this.middle.equalsIgnoreCase(name.getMiddle()) && this.major.equalsIgnoreCase(name.getMajor());
        }
        return false;
    }

    public int hashCode() {
        return (this.value.toUpperCase() + this.first.toUpperCase() + this.middle.toUpperCase() + this.major.toUpperCase()).hashCode();
    }

    public String toString() {
        if (Locale.getDefault().equals(Locale.US)) {
            return this.first + ' ' + this.value + ' ' + (this.middle.length() > 0 ? this.middle.charAt(0) : (char)' ') + ", " + this.description + " (" + this.nick + ')';
        }
        return this.description + ' ' + this.value + ", " + this.first + ' ' + this.middle + " (" + this.nick + ')';
    }

    public void parseName(String string) throws ParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,", true);
        if (stringTokenizer.hasMoreElements()) {
            this.first = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreElements()) {
                this.value = stringTokenizer.nextToken();
                if (this.value.indexOf(32) == 0 && stringTokenizer.hasMoreElements()) {
                    this.value = stringTokenizer.nextToken();
                }
            } else {
                this.value = this.first;
                this.first = "";
            }
        } else {
            throw new ParseException("Empty string", 0);
        }
    }

    public void saveXML(OutputStream outputStream, String string, int n) throws IOException, UnsupportedEncodingException {
        outputStream.write("<NAME>".getBytes(string));
        this.saveSimpleTag(outputStream, string, "FIRST", this.first);
        this.saveSimpleTag(outputStream, string, "MIDDLE", this.middle);
        this.saveSimpleTag(outputStream, string, "LAST", this.value);
        this.saveSimpleTag(outputStream, string, "MAIDEN", this.maiden);
        this.saveSimpleTag(outputStream, string, "MAJOR", this.major);
        this.saveSimpleTag(outputStream, string, "SALUT", this.description);
        this.saveSimpleTag(outputStream, string, "NICK", this.nick);
        outputStream.write("</NAME>".getBytes(string));
    }
}

