/*
 * Decompiled with CFR 0.152.
 */
package rogatkin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class SendMail {
    protected static final int DEF_TIMEOUT = 2;
    protected static final int DEF_MAILPORT = 25;
    protected static final String PROP_MAILTIMEOUT = "MAILTIMEOUT";
    protected static final String PROP_MAILHOST = "MAILHOST";
    protected static final String PROP_MAILPORT = "MAILPORT";
    protected static final String PROP_POPACCNT = "MAILACCOUNT";
    protected static final SimpleDateFormat PROTOCOL_GMTDATE = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss 'GMT'");
    Properties properties;

    protected static String fixDataLines(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringBuffer stringBuffer2 = new StringBuffer(128);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\r': {
                    break;
                }
                case '\n': {
                    if (stringBuffer2.toString().equals(".")) {
                        stringBuffer.append("..");
                    } else {
                        stringBuffer.append(stringBuffer2);
                    }
                    stringBuffer.append("\r\n");
                    stringBuffer2.setLength(0);
                    break;
                }
                default: {
                    stringBuffer2.append(c);
                }
            }
            ++n;
        }
        if (stringBuffer2.length() > 0) {
            if (stringBuffer2.toString().equals(".")) {
                stringBuffer.append("..");
            } else {
                stringBuffer.append(stringBuffer2);
            }
        }
        stringBuffer.append("\r\n.\r\n");
        return stringBuffer.toString();
    }

    protected static String escapeSpecials(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<' || c == '>') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    public SendMail(Properties properties) {
        this.properties = properties;
    }

    public void send(String string, String string2, String string3, String string4, Properties properties) throws IOException {
        if (this.properties == null) {
            this.properties = System.getProperties();
        }
        String string5 = this.properties.getProperty(PROP_MAILHOST, "Unknown");
        int n = 25;
        try {
            n = Integer.parseInt(this.properties.getProperty(PROP_MAILPORT, "25"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string6 = this.properties.getProperty(PROP_POPACCNT, "Unknown");
        try {
            TextSocket textSocket = new TextSocket(string5, n);
            int n2 = 2;
            try {
                n2 = Integer.parseInt(this.properties.getProperty(PROP_MAILTIMEOUT));
            }
            catch (Exception exception) {
                // empty catch block
            }
            textSocket.setSoTimeout(n2 * 60 * 1000);
            textSocket.getResult();
            textSocket.write("HELO ");
            textSocket.writeLine(string6);
            textSocket.flush();
            if (textSocket.getResult() != 250) {
                throw new IOException("At presenting POP account " + string6 + " a mail server returned code " + textSocket.lastResult());
            }
            textSocket.write("MAIL FROM:<");
            textSocket.write(string);
            if (string.indexOf(64) < 0) {
                textSocket.write("@");
                textSocket.write(string5);
            }
            textSocket.writeLine(">");
            textSocket.flush();
            if (textSocket.getResult() != 250) {
                throw new IOException("At writing from address a mail server returned code " + textSocket.lastResult());
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";,");
            while (stringTokenizer.hasMoreTokens()) {
                textSocket.write("RCPT TO:<");
                textSocket.write(SendMail.escapeSpecials(stringTokenizer.nextToken()));
                textSocket.writeLine(">");
                textSocket.flush();
                if (textSocket.getResult() == 250) continue;
                throw new IOException("At writing to addresses a mail server returned code " + textSocket.lastResult());
            }
            textSocket.writeLine("DATA");
            textSocket.flush();
            textSocket.getResult();
            textSocket.write("Subject: ");
            textSocket.writeLine(string3);
            textSocket.write("From: ");
            textSocket.writeLine(string);
            textSocket.write("To: ");
            textSocket.writeLine(string2);
            textSocket.write("Date: ");
            textSocket.writeLine(PROTOCOL_GMTDATE.format(new Date()));
            textSocket.writeLine("X-Mailer: genuine DemRog\u00ae class library $Revision: 1.4 $");
            if (properties != null) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string7 = (String)enumeration.nextElement();
                    textSocket.writeLine(string7 + ": " + properties.getProperty(string7));
                }
            }
            textSocket.writeLine("");
            if (string4 != null && string4.length() > 0) {
                textSocket.writeLine(SendMail.fixDataLines(string4));
            } else {
                textSocket.writeLine(".");
            }
            textSocket.flush();
            if (textSocket.getResult() != 250) {
                throw new IOException("At writing body a mail server returned code " + textSocket.lastResult());
            }
            textSocket.writeLine("QUIT");
            textSocket.flush();
            textSocket.close();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        timeZone.setID("GMT");
        PROTOCOL_GMTDATE.setTimeZone(timeZone);
    }

    public class TextSocket
    extends Socket {
        protected String m_lastResult;
        protected int m_code;
        protected BufferedReader m_input;
        protected BufferedWriter m_output;

        protected void createStreams() throws IOException {
            this.m_input = new BufferedReader(new InputStreamReader(super.getInputStream()));
            this.m_output = new BufferedWriter(new OutputStreamWriter(super.getOutputStream()));
        }

        TextSocket(String string, int n) throws UnknownHostException, IOException {
            super(string, n);
            this.createStreams();
        }

        public BufferedReader getBufferedInputStream() {
            return this.m_input;
        }

        public BufferedWriter getBufferedOutputStream() {
            return this.m_output;
        }

        public String readLine() throws IOException {
            return this.m_input.readLine();
        }

        public void write(String string) throws IOException {
            this.m_output.write(string, 0, string.length());
        }

        public void writeLine(String string) throws IOException {
            this.write(string);
            this.m_output.newLine();
        }

        public void flush() throws IOException {
            this.m_output.flush();
        }

        public String lastResult() {
            return this.m_lastResult;
        }

        public int lastResultCode() {
            return this.m_code;
        }

        public int getResult() throws IOException {
            this.m_lastResult = this.m_input.readLine();
            if (this.m_lastResult.length() == 0) {
                return -1;
            }
            this.m_code = this.resultCode(this.m_lastResult);
            if (this.m_code != -1 && this.m_lastResult.length() > 3 && this.m_lastResult.charAt(3) == '-') {
                String string;
                while ((string = this.m_input.readLine()).length() != 0) {
                    this.m_lastResult = this.m_lastResult + "\r\n" + string;
                    if (this.resultCode(string) != this.m_code || string.length() <= 3 || string.charAt(3) != ' ') continue;
                    break;
                }
            }
            return this.m_code;
        }

        public int resultCode(String string) {
            int n = 0;
            int n2 = 0;
            while (n2 < 3 && n2 < string.length()) {
                char c = string.charAt(n2);
                if (c < '0' || c > '9') {
                    return -1;
                }
                n = 10 * n + c - 48;
                ++n2;
            }
            return n;
        }

        public boolean isMultilineResult(String string) {
            int n = 0;
            while (n < 3 && n < string.length()) {
                if (string.charAt(n) < '0' || string.charAt(n) > '9') {
                    return true;
                }
                ++n;
            }
            return n < string.length() && string.charAt(n) != ' ';
        }
    }
}

