/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.util.Registry;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SettingsPanel
extends JPanel
implements ActionListener {
    private JCheckBox checkAllowCaching;
    private JCheckBox checkAllowFile;
    private JCheckBox checkAllowCapture;
    private JTextField textMaxCacheSize;
    private JTextField textCacheDir;
    private JPanel grid;
    private JButton commit;
    private JButton restore;

    public SettingsPanel() {
        this.setLayout(new FlowLayout(0));
        this.grid = new JPanel(new GridLayout(6, 2));
        this.checkAllowCaching = new JCheckBox("");
        this.addComp("Allow Caching : ", (Component)this.checkAllowCaching);
        this.textCacheDir = new JTextField("", 12);
        this.addComp("Cache Directory : ", (Component)this.textCacheDir);
        this.textMaxCacheSize = new JTextField("", 5);
        this.addComp("Max Cache Size (MB) : ", (Component)this.textMaxCacheSize);
        this.checkAllowFile = new JCheckBox("");
        this.addComp("Allow File Writing for Applets : ", (Component)this.checkAllowFile);
        this.checkAllowCapture = new JCheckBox("");
        this.addComp("Allow Capture for Applets : ", (Component)this.checkAllowCapture);
        this.commit = new JButton("Commit");
        this.restore = new JButton("Restore");
        this.addComp(this.commit, (Component)this.restore);
        this.commit.addActionListener(this);
        this.restore.addActionListener(this);
        this.add(this.grid);
        this.doRestore();
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.commit) {
            this.doCommit();
        }
        if (source == this.restore) {
            this.doRestore();
        }
    }

    private void doCommit() {
        boolean allowCaching = this.checkAllowCaching.isSelected();
        Registry.set("secure.allowCaching", new Boolean(allowCaching));
        boolean allowFile = this.checkAllowFile.isSelected();
        Registry.set("secure.allowSaveFileFromApplets", new Boolean(allowFile));
        boolean allowCapture = this.checkAllowCapture.isSelected();
        Registry.set("secure.allowCaptureFromApplets", new Boolean(allowCapture));
        Registry.set("secure.cacheDir", this.textCacheDir.getText());
        try {
            int cacheSize = Integer.parseInt(this.textMaxCacheSize.getText());
            Registry.set("secure.maxCacheSizeMB", new Integer(cacheSize));
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog(null, "Invalid Cache Size", "JMF Registry", 1);
        }
        try {
            Registry.commit();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Could not commit", "JMF Registry", 1);
        }
    }

    private void doRestore() {
        Boolean allowCaching = (Boolean)Registry.get("secure.allowCaching");
        Boolean allowFile = (Boolean)Registry.get("secure.allowSaveFileFromApplets");
        Boolean allowCapture = (Boolean)Registry.get("secure.allowCaptureFromApplets");
        String cacheDir = (String)Registry.get("secure.cacheDir");
        Integer cacheSize = (Integer)Registry.get("secure.maxCacheSizeMB");
        this.checkAllowCaching.setSelected(allowCaching != null && allowCaching != false);
        this.checkAllowFile.setSelected(allowFile != null && allowFile != false);
        this.checkAllowCapture.setSelected(allowCapture != null && allowCapture != false);
        if (cacheDir != null) {
            this.textCacheDir.setText(cacheDir);
        }
        if (cacheSize != null) {
            this.textMaxCacheSize.setText(cacheSize.toString());
        }
    }

    private void addComp(String title, Component comp) {
        this.grid.add(new JLabel(title, 4));
        JPanel flowPanel = new JPanel(new FlowLayout(0));
        flowPanel.add(comp);
        this.grid.add(flowPanel);
    }

    private void addComp(Component comp1, Component comp2) {
        JPanel flowPanel = new JPanel(new FlowLayout(1));
        flowPanel.add(comp1);
        this.grid.add(flowPanel);
        flowPanel = new JPanel(new FlowLayout(1));
        flowPanel.add(comp2);
        this.grid.add(flowPanel);
    }
}

