/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.Bitmap;
import com.sun.media.content.application.x_shockwave_flash.ColorTransform;
import com.sun.media.content.application.x_shockwave_flash.DisplayList;
import com.sun.media.content.application.x_shockwave_flash.Matrix;

final class RColor {
    RColor nextActive;
    int order;
    int fillType;
    int visible;
    boolean onActiveList;
    byte index;
    long wideColor;
    int color;
    Matrix ginvMat;
    int[] gcolorRamp;
    Matrix bmInvMat;
    Bitmap bitmap;
    ColorTransform cx;
    boolean cacheValid;
    boolean bmSmooth;
    boolean bmFast;
    int bmDx;
    int bmDy;

    RColor(DisplayList display, int c2) {
        this.fillType = 0;
        this.color = c2;
        if (display.indexedColor) {
            this.index = (byte)display.RGBToIndex(this.color);
        }
        this.wideColor = DisplayList.ExpandColor(this.color);
    }

    RColor(DisplayList display, int type, int nColors, int[] colors, int[] colorRatios, Matrix gradMat, Matrix devMat) {
        int c2;
        this.fillType = type;
        Matrix dMat = new Matrix(devMat);
        if (display.antialias) {
            dMat.a /= 4;
            dMat.d /= 4;
            dMat.b /= 4;
            dMat.c /= 4;
            dMat.tx /= 4;
            dMat.ty /= 4;
        }
        Matrix gMat = new Matrix(gradMat);
        dMat.tx <<= 8;
        dMat.ty <<= 8;
        gMat.tx <<= 8;
        gMat.ty <<= 8;
        this.ginvMat = Matrix.concat(gMat, dMat).invert();
        this.gcolorRamp = new int[257];
        int cr1 = 0;
        int cr2 = colorRatios[0];
        int c1 = c2 = colors[0];
        int ci = 1;
        int i2 = 0;
        while (i2 <= 256) {
            int w2;
            int w1;
            int wT;
            if (i2 > cr2) {
                cr1 = cr2;
                c1 = c2;
                if (ci < nColors) {
                    cr2 = colorRatios[ci];
                    c2 = colors[ci];
                    ++ci;
                } else {
                    cr2 = 256;
                }
            }
            if ((wT = (w1 = (cr2 - i2) / 8) + (w2 = (i2 - cr1) / 8)) > 0) {
                int red = ((c1 >> 16 & 0xFF) * w1 + (c2 >> 16 & 0xFF) * w2) / wT;
                int green = ((c1 >> 8 & 0xFF) * w1 + (c2 >> 8 & 0xFF) * w2) / wT;
                int blue = ((c1 & 0xFF) * w1 + (c2 & 0xFF) * w2) / wT;
                this.gcolorRamp[i2] = 0xFF000000 | red << 16 | green << 8 | blue;
            } else {
                this.gcolorRamp[i2] = c1;
            }
            ++i2;
        }
    }

    void RecalcSolid(DisplayList display, int c2) {
        this.fillType = 0;
        this.color = c2;
        if (display.indexedColor) {
            this.index = (byte)display.RGBToIndex(this.color);
        }
        this.wideColor = DisplayList.ExpandColor(this.color);
    }
}

