/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPReporter;
import com.sun.media.rtp.RTPSinkStream;
import com.sun.media.rtp.RTPTransStats;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.TrueRandom;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPStream;
import javax.media.rtp.SendStream;
import javax.media.rtp.TransmissionStats;
import javax.media.rtp.rtcp.Feedback;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SenderReport;
import javax.media.rtp.rtcp.SourceDescription;

public class SendSSRCInfo
extends SSRCInfo
implements SenderReport,
SendStream {
    boolean inited = false;
    private static final int PACKET_SIZE = 4000;
    protected int packetsize;
    protected Format myformat;
    protected long lastMT = -1L;
    protected long lastTS = -1L;
    protected long lastSeq = -1L;
    protected RTPTransStats stats;
    protected RTCPReporter rtcprep;

    public SendSSRCInfo(SSRCCache cache, int ssrc) {
        super(cache, ssrc);
        this.maxseq = this.baseseq = (int)TrueRandom.rand();
        this.lasttimestamp = (int)TrueRandom.rand();
        this.sender = true;
        this.wassender = true;
        this.sinkstream = new RTPSinkStream();
        this.stats = new RTPTransStats();
    }

    public SendSSRCInfo(SSRCInfo info) {
        super(info);
        this.maxseq = this.baseseq = (int)TrueRandom.rand();
        this.lasttimestamp = (int)TrueRandom.rand();
        this.sender = true;
        this.wassender = true;
        this.sinkstream = new RTPSinkStream();
        this.stats = new RTPTransStats();
    }

    public long getTimeStamp(Buffer b2) {
        if (this.myformat instanceof VideoFormat) {
            if (this.lastTS == -1L) {
                if (b2.getTimeStamp() > 0L) {
                    this.lastTS = (long)((double)System.currentTimeMillis() * Math.random());
                    this.lastMT = b2.getTimeStamp();
                } else {
                    this.lastMT = this.lastTS = System.currentTimeMillis();
                }
                return this.lastTS;
            }
            if ((b2.getFlags() & 0x400) != 0) {
                long retval = this.lastTS;
                if (b2.getTimeStamp() > 0L) {
                    long delta = b2.getTimeStamp() - this.lastMT;
                    this.lastTS += delta / 1000000L * 90L;
                    this.lastMT = b2.getTimeStamp();
                } else {
                    long now = System.currentTimeMillis();
                    long delta = now - this.lastMT;
                    this.lastTS += delta * 90L;
                    this.lastMT = now;
                }
                return retval;
            }
            return this.lastTS;
        }
        if (this.myformat instanceof AudioFormat) {
            if (this.lastTS == -1L) {
                this.lastTS = (long)((double)System.currentTimeMillis() * Math.random());
                return this.lastTS;
            }
            this.lastTS += (long)this.calculateSampleCount(b2);
            return this.lastTS;
        }
        return -1L;
    }

    private int calculateSampleCount(Buffer b2) {
        if (this.myformat == null || this.myformat instanceof VideoFormat) {
            return -1;
        }
        if (this.myformat instanceof AudioFormat) {
            int sampleSizeinBits = ((AudioFormat)this.myformat).getSampleSizeInBits();
            int length = b2.getLength();
            if (this.myformat.getEncoding().equals("dvi/rtp")) {
                length -= 4;
            }
            if (sampleSizeinBits != -1) {
                return length * 8 / sampleSizeinBits;
            }
            if (this.myformat.getEncoding().equals("gsm/rtp")) {
                return length / 33 * 160;
            }
            if (this.myformat.getEncoding().equals("g723/rtp")) {
                return length / 24 * 240;
            }
        }
        return -1;
    }

    public long getSequenceNumber(Buffer b2) {
        if (this.lastSeq == -1L) {
            this.lastSeq = (long)((double)System.currentTimeMillis() * Math.random());
            return this.lastSeq;
        }
        ++this.lastSeq;
        return this.lastSeq;
    }

    protected void setFormat(Format fmt) {
        this.myformat = fmt;
        if (this.sinkstream != null) {
            int rate = 0;
            if (fmt instanceof AudioFormat) {
                if (fmt.getEncoding().equals("ULAW/rtp") || fmt.getEncoding().equals("dvi/rtp")) {
                    rate = (int)((AudioFormat)fmt).getSampleRate() * ((AudioFormat)fmt).getSampleSizeInBits();
                }
                if (fmt.getEncoding().equals("gsm/rtp")) {
                    rate = 13200;
                }
                if (fmt.getEncoding().equals("g723/rtp")) {
                    rate = 6300;
                }
                this.sinkstream.rate = rate;
            }
        } else {
            System.err.println("RTPSinkStream is NULL");
        }
    }

    public long getSenderPacketCount() {
        return this.lastSRpacketcount;
    }

    public long getSenderByteCount() {
        return this.lastSRoctetcount;
    }

    public long getNTPTimeStampMSW() {
        return this.lastSRntptimestamp >> 32;
    }

    public long getNTPTimeStampLSW() {
        return this.lastSRntptimestamp;
    }

    public long getRTPTimeStamp() {
        return this.lastSRrtptimestamp;
    }

    public Feedback getSenderFeedback() {
        SSRCCache cache = this.getSSRCCache();
        Report report = null;
        Vector reports = null;
        Vector feedback = null;
        Feedback reportblk = null;
        try {
            LocalParticipant localpartc = cache.sm.getLocalParticipant();
            reports = localpartc.getReports();
            int i2 = 0;
            while (i2 < reports.size()) {
                report = (Report)reports.elementAt(i2);
                feedback = report.getFeedbackReports();
                int j2 = 0;
                while (j2 < feedback.size()) {
                    reportblk = (Feedback)feedback.elementAt(j2);
                    long ssrc = reportblk.getSSRC();
                    if (ssrc == this.getSSRC()) {
                        return reportblk;
                    }
                    ++j2;
                }
                ++i2;
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public RTPStream getStream() {
        return this;
    }

    public Participant getParticipant() {
        SSRCCache cache = this.getSSRCCache();
        if (this.sourceInfo instanceof LocalParticipant && cache.sm.IsNonParticipating()) {
            return null;
        }
        return this.sourceInfo;
    }

    public void setSourceDescription(SourceDescription[] userdesclist) {
        super.setSourceDescription(userdesclist);
    }

    public void close() {
        try {
            this.stop();
        }
        catch (IOException iOException) {}
        SSRCCache cache = this.getSSRCCache();
        cache.sm.removeSendStream(this);
    }

    public SenderReport getSenderReport() {
        SSRCCache cache = this.getSSRCCache();
        Report report = null;
        Vector reports = null;
        Vector feedback = null;
        Feedback reportblk = null;
        try {
            LocalParticipant localpartc = cache.sm.getLocalParticipant();
            reports = localpartc.getReports();
            int i2 = 0;
            while (i2 < reports.size()) {
                report = (Report)reports.elementAt(i2);
                feedback = report.getFeedbackReports();
                int j2 = 0;
                while (j2 < feedback.size()) {
                    reportblk = (Feedback)feedback.elementAt(j2);
                    long ssrc = reportblk.getSSRC();
                    if (ssrc == this.getSSRC()) {
                        return (SenderReport)report;
                    }
                    ++j2;
                }
                ++i2;
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public DataSource getDataSource() {
        return this.pds;
    }

    public void stop() throws IOException {
        if (this.pds != null) {
            this.pds.stop();
        }
        if (this.sinkstream != null) {
            this.sinkstream.stop();
        }
    }

    public void start() throws IOException {
        if (!this.inited) {
            this.inited = true;
            this.probation = 0;
            this.initsource((int)TrueRandom.rand());
            this.lasttimestamp = (int)TrueRandom.rand();
        }
        if (this.pds != null) {
            this.pds.start();
        }
        if (this.sinkstream != null) {
            this.sinkstream.start();
        }
    }

    protected void createDS() {
    }

    public int setBitRate(int rate) {
        if (this.sinkstream != null) {
            this.sinkstream.rate = rate;
        }
        return rate;
    }

    public TransmissionStats getSourceTransmissionStats() {
        return this.stats;
    }
}

