/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionListener;

public class ProgressDialog
extends Dialog {
    public static final String ACTION_ABORT = " Abort ";
    public static final String ACTION_STOP = " Stop ";
    public static final String ACTION_PAUSE = " Pause ";
    public static final String ACTION_RESUME = "Resume";
    private int nMinPos;
    private int nMaxPos;
    private String strMessage;
    private ActionListener listener;
    private ProgressBar progressBar;
    private Label labelProgress;
    private Button buttonPause;
    private Component component;

    public ProgressDialog(Frame frame, String strTitle, int nMin, int nMax, ActionListener listener) {
        super(frame, strTitle, false);
        this.nMinPos = nMin;
        this.nMaxPos = nMax;
        this.listener = listener;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public ProgressDialog(Frame frame, String strTitle, String strMessage, Component component, ActionListener listener) {
        super(frame, strTitle, false);
        this.strMessage = strMessage;
        this.listener = listener;
        this.component = component;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setCurPos(int nPos) {
        if (this.progressBar != null) {
            this.progressBar.setCurPos(nPos);
            this.labelProgress.setText(this.progressBar.getCurPercent() + "%");
            this.repaint();
        } else {
            this.labelProgress.setText("Saved " + nPos + " seconds...");
        }
    }

    public void setPauseButtonText(String strButton) {
        this.buttonPause.setLabel(strButton);
        this.repaint();
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout());
        ((Component)this).setBackground(Color.lightGray);
        Panel panel = new Panel(new BorderLayout(6, 6));
        if (this.nMaxPos > this.nMinPos) {
            this.add((Component)panel, "Center");
            this.progressBar = new ProgressBar(this.nMinPos, this.nMaxPos);
            panel.add((Component)this.progressBar, "Center");
            this.labelProgress = new Label("100%");
            panel.add((Component)this.labelProgress, "East");
        } else if (this.strMessage != null) {
            this.add((Component)panel, "Center");
            this.labelProgress = new Label(this.strMessage);
            panel.add((Component)this.labelProgress, "North");
            if (this.component != null) {
                Panel panelComp = new Panel(new FlowLayout());
                panel.add((Component)panelComp, "Center");
                panelComp.add(this.component);
            }
        }
        panel = new Panel(new FlowLayout(1));
        this.add((Component)panel, "South");
        Panel panelGrid = new Panel(new GridLayout(1, 0, 6, 6));
        panel.add(panelGrid);
        this.buttonPause = new Button(ACTION_PAUSE);
        this.buttonPause.addActionListener(this.listener);
        panelGrid.add(this.buttonPause);
        Button button = this.strMessage == null ? new Button(ACTION_ABORT) : new Button(ACTION_STOP);
        button.addActionListener(this.listener);
        panelGrid.add(button);
        panel = new Panel();
        this.add((Component)panel, "North");
        this.pack();
        Dimension dimDialog = this.getPreferredSize();
        ((Component)this).setSize(dimDialog);
        Dimension dimScreen = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((dimScreen.width - dimDialog.width) / 2, (dimScreen.height - dimDialog.height) / 2);
        this.setResizable(false);
        if (this.progressBar != null) {
            this.labelProgress.setText(this.progressBar.getCurPercent() + "%");
        }
        this.repaint();
    }
}

