/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import com.sun.media.util.VideoCodecChain;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.media.Buffer;
import javax.media.control.MonitorControl;
import javax.media.format.UnsupportedFormatException;
import javax.media.format.VideoFormat;

public class MonitorAdapter
implements MonitorControl {
    protected VideoCodecChain vcc;
    protected boolean enabled = false;
    protected Component visualComponent;
    protected VideoFormat format;
    protected float inFrameRate;
    protected float previewFrameRate = 1.0f;
    protected Buffer copyBuffer = new Buffer();
    protected long lastPreviewTime;
    protected long previewInterval = 1000000000L;
    protected MouseListener ml;
    protected PopupMenu rateMenu;
    protected int[] frameRates;

    public MonitorAdapter(VideoFormat vf) throws UnsupportedFormatException {
        int[] nArray = new int[11];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 5;
        nArray[4] = 7;
        nArray[5] = 10;
        nArray[6] = 15;
        nArray[7] = 20;
        nArray[8] = 30;
        nArray[9] = 60;
        nArray[10] = 90;
        this.frameRates = nArray;
        this.vcc = new VideoCodecChain(vf);
        if (this.vcc != null) {
            this.format = vf;
            this.inFrameRate = vf.getFrameRate();
            if (this.inFrameRate < 0.0f) {
                this.inFrameRate = 30.0f;
            }
        } else {
            throw new UnsupportedFormatException(vf);
        }
        this.inFrameRate = (float)((int)((double)(this.inFrameRate * 10.0f) + 0.5)) / 10.0f;
    }

    public void process(Buffer buffer) {
        this.doMonitor(buffer);
    }

    protected void doMonitor(Buffer buffer) {
        if (buffer == null || this.previewFrameRate <= 0.0f || this.format == null || buffer.isEOM() || this.visualComponent == null) {
            return;
        }
        if (!this.format.matches(buffer.getFormat())) {
            return;
        }
        this.copyBuffer.setData(this.copyData(buffer.getData()));
        this.copyBuffer.setFlags(buffer.getFlags());
        this.copyBuffer.setFormat(buffer.getFormat());
        this.copyBuffer.setSequenceNumber(buffer.getSequenceNumber());
        this.copyBuffer.setHeader(buffer.getHeader());
        this.copyBuffer.setLength(buffer.getLength());
        this.copyBuffer.setOffset(buffer.getOffset());
        this.copyBuffer.setTimeStamp(buffer.getTimeStamp());
        boolean toDisplay = false;
        long time = this.copyBuffer.getTimeStamp();
        if (time >= this.lastPreviewTime + this.previewInterval || time <= this.lastPreviewTime) {
            this.lastPreviewTime = time;
            toDisplay = true;
        }
        this.vcc.process(this.copyBuffer, toDisplay);
    }

    private Object copyData(Object in) {
        if (in instanceof byte[]) {
            byte[] out = new byte[((byte[])in).length];
            System.arraycopy(in, 0, out, 0, out.length);
            return out;
        }
        if (in instanceof short[]) {
            short[] out = new short[((short[])in).length];
            System.arraycopy(in, 0, out, 0, out.length);
            return out;
        }
        if (in instanceof int[]) {
            int[] out = new int[((int[])in).length];
            System.arraycopy(in, 0, out, 0, out.length);
            return out;
        }
        return in;
    }

    public float setPreviewFrameRate(float value) {
        if (value > this.inFrameRate) {
            value = this.inFrameRate;
        }
        this.previewFrameRate = value;
        this.previewInterval = (long)(1.0E9 / (double)value);
        return value;
    }

    public Component getControlComponent() {
        if (this.vcc != null) {
            if (this.visualComponent == null) {
                this.visualComponent = this.vcc.getVisualComponent();
                if (this.visualComponent != null) {
                    this.addPopupMenu(this.visualComponent);
                }
            }
            return this.visualComponent;
        }
        return null;
    }

    private void addPopupMenu(Component visual) {
        MenuItem mi;
        this.rateMenu = new PopupMenu("Monitor Rate");
        1 rateSelect = new 1();
        visual.add(this.rateMenu);
        int lastAdded = 0;
        int i2 = 0;
        while (i2 < this.frameRates.length) {
            if ((float)this.frameRates[i2] < this.inFrameRate) {
                mi = new MenuItem(String.valueOf(this.frameRates[i2]) + " fps");
                this.rateMenu.add(mi);
                mi.addActionListener(rateSelect);
                lastAdded = this.frameRates[i2];
            }
            ++i2;
        }
        if ((float)lastAdded < this.inFrameRate) {
            mi = new MenuItem(String.valueOf(this.inFrameRate) + " fps");
            this.rateMenu.add(mi);
            mi.addActionListener(rateSelect);
        }
        this.ml = new 2();
        visual.addMouseListener(this.ml);
    }

    public void finalize() {
        if (this.visualComponent != null) {
            this.visualComponent.remove(this.rateMenu);
            this.visualComponent.removeMouseListener(this.ml);
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            block2: {
                String action = ae.getActionCommand();
                int space = action.indexOf(" ");
                String rateString = action.substring(0, space);
                try {
                    int rate = Integer.parseInt(rateString);
                    MonitorAdapter.this.setPreviewFrameRate(rate);
                }
                catch (Throwable t) {
                    if (!(t instanceof ThreadDeath)) break block2;
                    throw (ThreadDeath)t;
                }
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseAdapter {
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                MonitorAdapter.this.rateMenu.show(MonitorAdapter.this.visualComponent, me.getX(), me.getY());
            }
        }

        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                MonitorAdapter.this.rateMenu.show(MonitorAdapter.this.visualComponent, me.getX(), me.getY());
            }
        }

        public void mouseClicked(MouseEvent me) {
            if (me.isPopupTrigger()) {
                MonitorAdapter.this.rateMenu.show(MonitorAdapter.this.visualComponent, me.getX(), me.getY());
            }
        }

        /* synthetic */ 2() {
        }
    }
}

