/*
 * Decompiled with CFR 0.152.
 */
package rtp;

import com.sun.media.rtp.util.Signed;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.ReceiverReportEvent;
import javax.media.rtp.event.RemoteEvent;
import javax.media.rtp.event.SenderReportEvent;
import javax.media.rtp.event.TimeoutEvent;
import javax.media.rtp.rtcp.ReceiverReport;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SenderReport;
import rtp.RTPStreamWindow;
import rtp.ReceiverReportWindow;
import rtp.SDESWindow;
import rtp.SenderReportWindow;

public class RTPParticipantWindow
extends Frame
implements ReceiveStreamListener,
RemoteListener,
ActionListener {
    SessionManager mgr;
    Vector recvstreamlist;
    Participant mypartc;
    List recvlistgui;
    List reportlistgui;
    Vector reportlist;
    private static final int ADD = 1;
    private static final int DELETE = 2;
    Vector children;
    Vector repchildren;
    SDESWindow sdes;

    public RTPParticipantWindow(SessionManager mgr, Participant partc) {
        super("Participant");
        this.mgr = mgr;
        this.mypartc = partc;
        ((Component)this).setFont(new Font("Helvetica", 0, 14));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 2;
        c2.anchor = 18;
        c2.weightx = 1.0;
        c2.weighty = 1.0;
        this.setLayout(gridbag);
        Label p2 = new Label("CName");
        gridbag.setConstraints(p2, c2);
        this.add(p2);
        TextField t = new TextField(this.mypartc.getCNAME());
        c2.gridwidth = 0;
        gridbag.setConstraints(t, c2);
        t.setEditable(false);
        this.add(t);
        Label p1 = new Label("Streams");
        c2.gridwidth = -1;
        gridbag.setConstraints(p1, c2);
        this.add((Component)p1, c2);
        this.recvlistgui = new List(5);
        this.recvlistgui.setBackground(Color.white);
        c2.gridwidth = 0;
        gridbag.setConstraints(this.recvlistgui, c2);
        this.add(this.recvlistgui);
        this.recvstreamlist = this.mypartc.getStreams();
        if (this.recvstreamlist.size() == 0) {
            this.recvlistgui.addItem("PASSIVE PARTICIPANT: NO STREAMS");
            this.recvlistgui.setEnabled(false);
        }
        if (this.recvstreamlist.size() > 0) {
            int i2 = 0;
            while (i2 < this.recvstreamlist.size()) {
                String type = null;
                RTPStream stream = (RTPStream)this.recvstreamlist.elementAt(i2);
                if (stream instanceof ReceiveStream) {
                    type = "REMOTE: RECV STREAM ";
                }
                Participant owner = ((RTPStream)this.recvstreamlist.elementAt(i2)).getParticipant();
                this.recvlistgui.addItem(String.valueOf(type) + ": " + owner.getCNAME());
                ++i2;
            }
            this.recvlistgui.addActionListener(this);
        }
        this.sdes = new SDESWindow(this.mypartc.getSourceDescription());
        c2.gridwidth = 0;
        gridbag.setConstraints(this.sdes, c2);
        this.add((Component)this.sdes, c2);
        this.reportlist = this.mypartc.getReports();
        Label p22 = new Label("Latest Report sent by SSRCs of Participant");
        c2.gridwidth = -1;
        gridbag.setConstraints(p22, c2);
        this.add((Component)p22, c2);
        this.reportlistgui = new List(3);
        this.reportlistgui.setBackground(Color.white);
        c2.gridwidth = 0;
        gridbag.setConstraints(this.reportlistgui, c2);
        this.add(this.reportlistgui);
        this.reportlistgui.addActionListener(this);
        int i3 = 0;
        while (i3 < this.reportlist.size()) {
            Report report = (Report)this.reportlist.elementAt(i3);
            long ssrc = report.getSSRC();
            if (ssrc < 0L) {
                ssrc = Signed.UnsignedInt((int)ssrc);
            }
            this.reportlistgui.addItem(new Long(ssrc).toString());
            ++i3;
        }
        ((Component)this).setSize(550, 600);
        this.show();
        this.children = new Vector();
        this.repchildren = new Vector();
        this.addWindowListener(new 1());
        mgr.addReceiveStreamListener(this);
        mgr.addRemoteListener(this);
    }

    public void close() {
        int i2 = 0;
        while (i2 < this.children.size()) {
            ((RTPStreamWindow)this.children.elementAt(i2)).close();
            ++i2;
        }
        int j2 = 0;
        while (j2 < this.repchildren.size()) {
            Object window = this.repchildren.elementAt(j2);
            if (window instanceof SenderReportWindow) {
                ((SenderReportWindow)window).close();
            }
            if (window instanceof ReceiverReportWindow) {
                ((ReceiverReportWindow)window).close();
            }
            ++j2;
        }
        this.dispose();
    }

    public void actionPerformed(ActionEvent event) {
        Frame child;
        List sourcelist = (List)event.getSource();
        int index = sourcelist.getSelectedIndex();
        if (sourcelist == this.recvlistgui) {
            RTPStream chosen = (RTPStream)this.recvstreamlist.elementAt(index);
            child = new RTPStreamWindow(this.mgr, chosen);
            this.children.addElement(child);
        }
        if (sourcelist == this.reportlistgui) {
            Report chosenreport = (Report)this.reportlist.elementAt(index);
            if (chosenreport instanceof ReceiverReport) {
                child = new ReceiverReportWindow((ReceiverReport)chosenreport);
                this.repchildren.addElement(child);
            }
            if (chosenreport instanceof SenderReport) {
                child = new SenderReportWindow((SenderReport)chosenreport);
                this.repchildren.addElement(child);
            }
        }
    }

    public void update(ReceiveStreamEvent event) {
        Participant sender = null;
        ReceiveStream stream = null;
        if (event instanceof NewReceiveStreamEvent) {
            stream = ((NewReceiveStreamEvent)event).getReceiveStream();
            if (stream == null) {
                return;
            }
            sender = stream.getParticipant();
            if (sender != this.mypartc) {
                return;
            }
            this.updaterecvlist(1, stream);
        }
        if (event instanceof TimeoutEvent) {
            stream = ((TimeoutEvent)event).getReceiveStream();
            if (stream == null) {
                return;
            }
            sender = stream.getParticipant();
            if (sender != this.mypartc) {
                return;
            }
            this.updaterecvlist(2, stream);
        }
        if (event instanceof ByeEvent) {
            stream = ((ByeEvent)event).getReceiveStream();
            if (stream == null) {
                return;
            }
            sender = stream.getParticipant();
            if (sender != this.mypartc) {
                return;
            }
            this.updaterecvlist(2, stream);
        }
    }

    public void update(RemoteEvent event) {
        String item;
        long ssrc;
        int i2;
        Participant sender = null;
        Object stream = null;
        if (event instanceof ReceiverReportEvent && this.mypartc.getStreams().size() == 0) {
            ReceiverReport report = ((ReceiverReportEvent)event).getReport();
            if (report == null) {
                return;
            }
            sender = report.getParticipant();
            if (sender == null) {
                return;
            }
            if (sender != this.mypartc) {
                return;
            }
            if (this.sdes != null) {
                this.sdes.update(report.getSourceDescription());
            }
            this.reportlist = sender.getReports();
            i2 = 0;
            i2 = 0;
            while (i2 < this.reportlist.size()) {
                Report currreport = (Report)this.reportlist.elementAt(i2);
                ssrc = currreport.getSSRC();
                if (ssrc < 0L) {
                    ssrc = Signed.UnsignedInt((int)ssrc);
                }
                if (this.reportlistgui != null) {
                    item = this.reportlistgui.getItem(i2);
                    if (item != null) {
                        this.reportlistgui.replaceItem(new Long(ssrc).toString(), i2);
                    } else {
                        this.reportlistgui.addItem(new Long(ssrc).toString());
                    }
                }
                ++i2;
            }
        }
        if (event instanceof SenderReportEvent && this.mypartc.getStreams().size() > 0) {
            SenderReport reports = ((SenderReportEvent)event).getReport();
            if (reports == null) {
                return;
            }
            sender = reports.getParticipant();
            if (sender != this.mypartc) {
                return;
            }
            if (this.sdes != null) {
                this.sdes.update(reports.getSourceDescription());
            }
            this.reportlist = sender.getReports();
            i2 = 0;
            i2 = 0;
            while (i2 < this.reportlist.size()) {
                Report currreports = (Report)this.reportlist.elementAt(i2);
                ssrc = currreports.getSSRC();
                if (ssrc < 0L) {
                    ssrc = Signed.UnsignedInt((int)ssrc);
                }
                if (this.reportlistgui != null) {
                    item = this.reportlistgui.getItem(i2);
                    if (item != null) {
                        this.reportlistgui.replaceItem(new Long(ssrc).toString(), i2);
                    } else {
                        this.reportlistgui.addItem(new Long(ssrc).toString());
                    }
                }
                ++i2;
            }
        }
    }

    public void updaterecvlist(int mode, ReceiveStream newstream) {
        if (newstream == null) {
            return;
        }
        int count = 0;
        String cname = null;
        block0 : switch (mode) {
            case 1: {
                cname = newstream.getParticipant().getCNAME();
                count = this.recvlistgui.getItemCount();
                int i2 = 0;
                while (i2 < count) {
                    if (this.recvlistgui.getItem(i2).equals(cname)) {
                        return;
                    }
                    ++i2;
                }
                this.recvstreamlist.addElement(newstream);
                if (!(newstream instanceof ReceiveStream)) break;
                this.recvlistgui.addItem("REMOTE: RECV STREAM " + newstream.getParticipant().getCNAME());
                break;
            }
            case 2: {
                cname = newstream.getParticipant().getCNAME();
                count = this.recvlistgui.getItemCount();
                int i3 = 0;
                while (i3 < count) {
                    if (this.recvlistgui.getItem(i3).equals(cname)) {
                        this.recvlistgui.delItem(i3);
                        this.recvstreamlist.removeElement(newstream);
                        break block0;
                    }
                    ++i3;
                }
                break;
            }
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e2) {
            int i2 = 0;
            while (i2 < RTPParticipantWindow.this.children.size()) {
                ((RTPStreamWindow)RTPParticipantWindow.this.children.elementAt(i2)).close();
                ++i2;
            }
            int j2 = 0;
            while (j2 < RTPParticipantWindow.this.repchildren.size()) {
                Object window = RTPParticipantWindow.this.repchildren.elementAt(j2);
                if (window instanceof SenderReportWindow) {
                    ((SenderReportWindow)window).close();
                }
                if (window instanceof ReceiverReportWindow) {
                    ((ReceiverReportWindow)window).close();
                }
                ++j2;
            }
            RTPParticipantWindow.this.dispose();
        }

        /* synthetic */ 1() {
        }
    }
}

