/*
 * Decompiled with CFR 0.152.
 */
package rtp;

import com.sun.media.rtp.util.Signed;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.media.rtp.rtcp.Feedback;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SenderReport;
import rtp.RTCPFeedbackWindow;
import rtp.SDESWindow;

public class SenderReportWindow
extends Frame
implements ActionListener {
    SenderReport mysr;
    Button rb;
    Button sf;
    RTCPFeedbackWindow child;
    RTCPFeedbackWindow childsf;
    TextField tfntpmsw;
    TextField tfntplsw;
    TextField tfrtp;
    TextField tfpktcnt;
    TextField tfbytecnt;
    SDESWindow sdes;
    Vector reportblks;
    Feedback feedback;

    public SenderReportWindow(SenderReport sr) {
        super("RTCP Sender Report");
        this.mysr = sr;
        ((Component)this).setFont(new Font("Helvetica", 0, 14));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 2;
        c2.anchor = 18;
        c2.gridwidth = 0;
        this.setLayout(gridbag);
        this.sdes = new SDESWindow(sr.getSourceDescription());
        gridbag.setConstraints(this.sdes, c2);
        this.add(this.sdes);
        Label p1 = new Label("SSRC of Report Sender");
        c2.gridwidth = -1;
        gridbag.setConstraints(p1, c2);
        this.add(p1);
        long ssrc = sr.getSSRC();
        if (ssrc < 0L) {
            ssrc = Signed.UnsignedInt((int)ssrc);
        }
        String ssrcstr = new Long(ssrc).toString();
        TextField t1 = new TextField(ssrcstr);
        t1.setEditable(false);
        c2.gridwidth = 0;
        gridbag.setConstraints(t1, c2);
        this.add((Component)t1, c2);
        Label p2 = new Label("NTPTimeStampLSW in secs.");
        c2.gridwidth = -1;
        gridbag.setConstraints(p2, c2);
        this.add(p2);
        this.tfntplsw = new TextField();
        this.tfntplsw.setEditable(false);
        c2.gridwidth = 0;
        gridbag.setConstraints(this.tfntplsw, c2);
        this.add((Component)this.tfntplsw, c2);
        Label p3 = new Label("NTPTimeStampMSW in secs");
        c2.gridwidth = -1;
        gridbag.setConstraints(p3, c2);
        this.add(p3);
        this.tfntpmsw = new TextField();
        this.tfntpmsw.setEditable(false);
        c2.gridwidth = 0;
        gridbag.setConstraints(this.tfntpmsw, c2);
        this.add((Component)this.tfntpmsw, c2);
        Label px = new Label("RTPTimeStamp in RTPtime");
        c2.gridwidth = -1;
        gridbag.setConstraints(px, c2);
        this.add(px);
        this.tfrtp = new TextField();
        this.tfrtp.setEditable(false);
        c2.gridwidth = 0;
        gridbag.setConstraints(this.tfrtp, c2);
        this.add((Component)this.tfrtp, c2);
        Label p4 = new Label("Sender Byte Count, no. bytes");
        c2.gridwidth = -1;
        gridbag.setConstraints(p4, c2);
        this.add(p4);
        this.tfbytecnt = new TextField();
        this.tfbytecnt.setEditable(false);
        c2.gridwidth = 0;
        gridbag.setConstraints(this.tfbytecnt, c2);
        this.add((Component)this.tfbytecnt, c2);
        Label p5 = new Label("Sender Packet Count, no. packets");
        c2.gridwidth = -1;
        gridbag.setConstraints(p5, c2);
        this.add(p5);
        this.tfpktcnt = new TextField();
        this.tfpktcnt.setEditable(false);
        c2.gridwidth = 0;
        gridbag.setConstraints(this.tfpktcnt, c2);
        this.add((Component)this.tfpktcnt, c2);
        this.printSenderInfo(sr);
        this.rb = new Button("View Report Blocks in this SR");
        c2.gridwidth = -1;
        gridbag.setConstraints(this.rb, c2);
        this.rb.addActionListener(this);
        this.reportblks = sr.getFeedbackReports();
        if (this.reportblks.size() == 0) {
            this.rb.setEnabled(false);
        }
        this.add(this.rb);
        this.sf = new Button("View Report Blocks sent by me for this SSRC");
        c2.gridwidth = -1;
        gridbag.setConstraints(this.sf, c2);
        this.sf.addActionListener(this);
        this.feedback = sr.getSenderFeedback();
        if (this.feedback == null) {
            this.sf.setEnabled(false);
        }
        this.add(this.sf);
        this.pack();
        this.show();
        this.addWindowListener(new 1());
    }

    public void update(Report sr) {
        this.printSenderInfo(sr);
        this.sdes.update(sr.getSourceDescription());
    }

    public void printSenderInfo(Report sr) {
        if (((SenderReport)sr).getNTPTimeStampMSW() < 0L) {
            ((TextComponent)this.tfntpmsw).setText(this.toUnsignedStr(((SenderReport)sr).getNTPTimeStampMSW()));
        } else {
            ((TextComponent)this.tfntpmsw).setText(new Long(((SenderReport)sr).getNTPTimeStampMSW()).toString());
        }
        if (((SenderReport)sr).getNTPTimeStampLSW() < 0L) {
            ((TextComponent)this.tfntplsw).setText(this.toUnsignedStr(((SenderReport)sr).getNTPTimeStampLSW()));
        } else {
            ((TextComponent)this.tfntplsw).setText(new Long(((SenderReport)sr).getNTPTimeStampLSW()).toString());
        }
        if (((SenderReport)sr).getRTPTimeStamp() < 0L) {
            ((TextComponent)this.tfrtp).setText(this.toUnsignedStr(((SenderReport)sr).getRTPTimeStamp()));
        } else {
            ((TextComponent)this.tfrtp).setText(new Long(((SenderReport)sr).getRTPTimeStamp()).toString());
        }
        if (((SenderReport)sr).getSenderPacketCount() < 0L) {
            ((TextComponent)this.tfpktcnt).setText(this.toUnsignedStr(((SenderReport)sr).getSenderPacketCount()));
        } else {
            ((TextComponent)this.tfpktcnt).setText(new Long(((SenderReport)sr).getSenderPacketCount()).toString());
        }
        if (((SenderReport)sr).getSenderByteCount() < 0L) {
            ((TextComponent)this.tfbytecnt).setText(this.toUnsignedStr(((SenderReport)sr).getSenderByteCount()));
        } else {
            ((TextComponent)this.tfbytecnt).setText(new Long(((SenderReport)sr).getSenderByteCount()).toString());
        }
    }

    private String toUnsignedStr(long value) {
        long lval = Signed.UnsignedInt((int)value);
        return new Long(lval).toString();
    }

    public void actionPerformed(ActionEvent evt) {
        Button source = (Button)evt.getSource();
        if (source == this.rb) {
            this.child = new RTCPFeedbackWindow(this.reportblks);
        }
        if (source == this.sf) {
            Vector<Feedback> reportlist = new Vector<Feedback>(1);
            reportlist.addElement(this.feedback);
            this.childsf = new RTCPFeedbackWindow(reportlist);
        }
    }

    public void close() {
        if (this.child != null) {
            this.child.close();
        }
        if (this.childsf != null) {
            this.childsf.close();
        }
        this.dispose();
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e2) {
            if (SenderReportWindow.this.child != null) {
                SenderReportWindow.this.child.close();
            }
            if (SenderReportWindow.this.childsf != null) {
                SenderReportWindow.this.childsf.close();
            }
            SenderReportWindow.this.dispose();
        }

        /* synthetic */ 1() {
        }
    }
}

