/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;

public class MP3InputStream
extends DataInputStream {
    private static int bufferIntSize = 433;
    private static int headerstring;
    private static int[] dataBuffer;
    private static int wordPtr;
    private static int bitindex;
    private static short crc;
    private static int offset;
    private static int checksum;
    private static int framesize;
    private static int nSlots;
    private static long flen;
    private static int[][] frequencies;
    public static final int INITIAL_SYNC = 0;
    public static final int STRICT_SYNC = 1;
    public static final int MPEG1 = 1;
    public static final int MPEG2 = 2;
    public static final int fourtyfour_point_one = 0;
    public static final int fourtyeight = 1;
    public static final int thirtytwo = 2;
    public static final int stereo = 0;
    public static final int joint_stereo = 1;
    public static final int dual_channel = 2;
    public static final int single_channel = 3;
    public static final int both = 0;
    public static final int left = 1;
    public static final int right = 2;
    public static final int downmix = 3;
    private static boolean single_ch_mode;
    private static int current_frame_number;
    private static int last_frame_number;
    private int syncword;
    public static ID3Tag ID3TagInfo;
    long file_length;
    private String mp3filename;

    public MP3InputStream(String string, String string2) throws IOException {
        super(new FileInputStream(string));
        this.mp3filename = string;
        this.file_length = this.available();
        ID3TagInfo = new ID3Tag(string, string2);
    }

    public static String Track_name() {
        return MP3InputStream.ID3TagInfo.Track_name;
    }

    public static String Artist_name() {
        return MP3InputStream.ID3TagInfo.Artist_name;
    }

    public static String Album_name() {
        return MP3InputStream.ID3TagInfo.Album_name;
    }

    public static String Year() {
        return MP3InputStream.ID3TagInfo.Year;
    }

    public static String Comment() {
        return MP3InputStream.ID3TagInfo.Comment;
    }

    public static String Genre() {
        return MP3InputStream.ID3TagInfo.Genre;
    }

    public boolean readMP3Frame(int n) {
        int[] nArray = new int[4 * bufferIntSize];
        boolean bl = true;
        try {
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = this.readUnsignedByte();
                ++n2;
            }
            wordPtr = 0;
            bitindex = 0;
        }
        catch (IOException iOException) {
            bl = false;
            System.out.println("Error : " + iOException.toString());
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            MP3InputStream.dataBuffer[n3] = (nArray[n4] << 24) + (nArray[n4 + 1] << 16) + (nArray[n4 + 2] << 8) + nArray[n4 + 3];
            ++n3;
            n4 += 4;
        }
        return bl;
    }

    public static int current_headervalue() {
        return headerstring;
    }

    public static int get_bits(int n) {
        int n2 = 0;
        int n3 = bitindex + n;
        int[] nArray = new int[18];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        nArray[8] = 255;
        nArray[9] = 511;
        nArray[10] = 1023;
        nArray[11] = 2047;
        nArray[12] = 4095;
        nArray[13] = 8191;
        nArray[14] = 16383;
        nArray[15] = Short.MAX_VALUE;
        nArray[16] = 65535;
        nArray[17] = 131071;
        int[] nArray2 = nArray;
        if (n3 <= 32) {
            n2 = dataBuffer[wordPtr] >> 32 - n3 & nArray2[n];
            if ((bitindex += n) == 32) {
                bitindex = 0;
                ++wordPtr;
            }
            return n2;
        }
        short s = (short)dataBuffer[wordPtr];
        n2 = s << 16;
        short s2 = (short)(dataBuffer[++wordPtr] >> 16);
        n2 += s2 << 16 >>> 16;
        n2 >>= 48 - n3;
        bitindex = n3 - 32;
        return n2 &= nArray2[n];
    }

    public int current_frame() {
        return current_frame_number;
    }

    public int last_frame() {
        return last_frame_number;
    }

    public boolean get_header(int n) {
        boolean bl;
        boolean bl2;
        do {
            try {
                headerstring = this.readInt();
                MP3Globals.DebugPrint("Header read is " + headerstring);
            }
            catch (EOFException eOFException) {
                bl = false;
                this.reset();
                System.out.println("EOF Error : " + eOFException.toString());
            }
            catch (IOException iOException) {
                bl = false;
                System.out.println("EOF Error : " + iOException.toString());
            }
            bl = true;
            if (n == 0) {
                bl2 = (headerstring & 0xFFF00000) == -1048576;
            } else {
                boolean bl3 = (headerstring & 0xFFF80C00) != this.syncword || (headerstring & 0xC0) == 192 != single_ch_mode ? false : (bl2 = true);
            }
            if (bl2) continue;
            bl = this.SetFilePointer(-3);
        } while (!bl2 && bl);
        if (!bl) {
            return false;
        }
        if (last_frame_number < ++current_frame_number) {
            last_frame_number = current_frame_number;
        }
        return true;
    }

    static int swap_int32(int n) {
        return n << 24 | n << 8 & 0xFF0000 | n >> 8 & 0xFF00 | n >> 24;
    }

    void set_syncword(int n) {
        this.syncword = n & 0xFFFFFF3F;
        single_ch_mode = (n & 0xC0) == 192;
    }

    public long file_size() {
        flen = this.length();
        return flen;
    }

    public boolean SetFilePointer(int n) {
        boolean bl = true;
        long l = this.getFilePointer();
        if (l != -1L) {
            this.seek(l + (long)n);
        } else {
            bl = false;
        }
        return bl;
    }

    public void reset() {
        try {
            this.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Error : " + iOException.toString());
            return;
        }
    }

    public void seek(long l) {
        int n = (int)this.getFilePointer();
        try {
            if (l < 0L) {
                this.close();
                this.skipBytes((int)((long)n - l));
                return;
            }
            this.skipBytes((int)l);
            return;
        }
        catch (IOException iOException) {
            System.err.println("EOF - " + iOException.toString());
            return;
        }
    }

    long length() {
        return this.file_length;
    }

    long getFilePointer() {
        try {
            return this.length() - (long)this.available();
        }
        catch (IOException iOException) {
            System.err.println("EOF- " + iOException.toString());
            return -1L;
        }
    }

    static {
        dataBuffer = new int[bufferIntSize];
        frequencies = new int[][]{{22050, 24000, 16000, 1}, {44100, 48000, 32000, 1}};
        current_frame_number = -1;
        last_frame_number = -1;
    }
}

