/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletException;
import stec.iws.AdminContext;
import stec.iws.AdminUtils;
import stec.iws.IOManager;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public class AdminHosts {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";

    protected static void displayHostEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("host_entry");
        Hashtable hashtable = adminContext.data;
        String string = adminContext.template;
        string = Utils.getItem(IOManager.getHandler(iws.basedir, string));
        string = DString.replace(string, "%error_message%", adminContext.error_message.toString());
        Object object = hashtable.get("hostname");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%hostname%", (String)object);
        object = hashtable.get("root_directory");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%root_directory%", (String)object);
        object = hashtable.get("key");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%key%", (String)object);
        AdminUtils.sendItem(adminContext.response, string);
    }

    protected static void displayHosts(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("hosts");
        AdminUtils.displayList(adminContext);
    }

    protected static void doHostEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("host_entry");
        String string = AdminUtils.getAction(adminContext);
        if (string == null) {
            if (AdminHosts.verifyHostEntry(adminContext)) {
                AdminHosts.updateHostEntry(adminContext);
                adminContext.setForm("hosts");
                AdminUtils.displayList(adminContext);
                return;
            }
        } else {
            if (string.equals("help")) {
                AdminUtils.help(adminContext, "hosts", "#entry");
                return;
            }
            if (string.equals("ok")) {
                if (AdminHosts.verifyHostEntry(adminContext)) {
                    AdminHosts.updateHostEntry(adminContext);
                    adminContext.setForm("hosts");
                    AdminUtils.displayList(adminContext);
                    return;
                }
            } else if (string.equals("cancel")) {
                adminContext.setForm("hosts");
                AdminUtils.displayList(adminContext);
                return;
            }
        }
        AdminHosts.displayHostEntry(adminContext);
    }

    protected static void doHosts(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("hosts");
        if (AdminUtils.doListAction(adminContext)) {
            return;
        }
        if (adminContext.action.equals("add")) {
            AdminHosts.displayHostEntry(adminContext);
            return;
        }
        if (adminContext.action.equals("edit")) {
            if (AdminUtils.doEdit(adminContext)) {
                AdminHosts.parseHostEntry(adminContext);
                AdminHosts.displayHostEntry(adminContext);
                return;
            }
        } else {
            AdminUtils.displayList(adminContext);
        }
    }

    protected static Hashtable getHostEntry(AdminContext adminContext, Hashtable hashtable) {
        Object v = hashtable.get("key");
        if (v == null) {
            return hashtable;
        }
        String string = (String)v;
        hashtable.put("key", string);
        hashtable.put("hostname", string);
        String string2 = (String)hashtable.get("entry");
        hashtable.put("root_directory", string2);
        return hashtable;
    }

    protected static void parseHostEntry(AdminContext adminContext) {
        Hashtable hashtable = adminContext.data;
        AdminHosts.getHostEntry(adminContext, hashtable);
    }

    protected static void updateHostEntry(AdminContext adminContext) throws IOException, ServletException {
        Hashtable hashtable = adminContext.data;
        String string = (String)hashtable.get("hostname");
        String string2 = (String)hashtable.get("root_directory");
        hashtable = AdminUtils.getSessionData(adminContext, "hosts");
        hashtable.put(string, string2);
        AdminUtils.putSessionData(adminContext, "hosts", hashtable);
    }

    protected static boolean verifyHostEntry(AdminContext adminContext) throws IOException, ServletException {
        String string;
        Hashtable hashtable = AdminHosts.getHostEntry(adminContext, AdminUtils.getFormData(adminContext, "hosts"));
        adminContext.error_message.setLength(0);
        Hashtable hashtable2 = adminContext.data;
        String string2 = "";
        String string3 = adminContext.request.getParameter("key");
        if (string3 != null) {
            string2 = string3;
            hashtable2.put("key", string2);
        }
        if ((string3 = adminContext.request.getParameter("hostname")) == null) {
            adminContext.error_message.append("Hostname is required.<br>");
            string3 = hashtable.get("hostname");
            if (string3 != null) {
                hashtable2.put("hostname", string3);
            }
        } else {
            string = DString.trim(string3);
            if (string.length() == 0) {
                adminContext.error_message.append("Hostname is required.<br>");
                string3 = hashtable.get("hostname");
                if (string3 != null) {
                    hashtable2.put("hostname", string3);
                }
            } else if (string2.equals(string)) {
                hashtable2.put("hostname", string);
            } else if (AdminUtils.getFormEntry(adminContext, "hosts", string) != null) {
                adminContext.error_message.append("Hostname already exists.<br>");
                string3 = hashtable.get("hostname");
                if (string3 != null) {
                    hashtable2.put("hostname", string3);
                }
            } else {
                hashtable2.put("hostname", string);
            }
        }
        if ((string3 = adminContext.request.getParameter("root_directory")) == null) {
            adminContext.error_message.append("Root Directory is required.<br>");
            string3 = hashtable.get("root_directory");
            if (string3 != null) {
                hashtable2.put("root_directory", string3);
            }
        } else {
            string = DString.trim(string3);
            if (string.length() == 0) {
                adminContext.error_message.append("Root Directory is required.<br>");
                string3 = hashtable.get("root_directory");
                if (string3 != null) {
                    hashtable2.put("root_directory", string3);
                }
            } else {
                File file;
                if (!Utils.isAbsolute(string)) {
                    string = Utils.concatPaths(iws.basedir, string);
                }
                if (!(file = new File(string)).exists()) {
                    adminContext.error_message.append("Root Directory does not exist.<br>");
                } else if (!file.isDirectory()) {
                    adminContext.error_message.append("Root Directory must be a directory.<br>");
                } else {
                    hashtable2.put("root_directory", string3);
                }
            }
        }
        return adminContext.error_message.length() <= 0;
    }
}

