/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import stec.iws.FileIOHandler;
import stec.iws.IOHandler;
import stec.lang.QuickSort;

public class FileCache {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";
    private int maxSize;
    private int currentSize;
    private Hashtable ht = new Hashtable();
    private Vector v = new Vector();

    public FileCache(int n) {
        this.maxSize = n;
    }

    private byte[] addItem(String string, IOHandler iOHandler) throws IOException {
        byte[] byArray = this.getFile(iOHandler);
        int n = (int)iOHandler.length();
        Item item = new Item();
        item.bytes = byArray;
        item.lastModified = iOHandler.lastModified();
        item.fname = string;
        item.lastAccessed = System.currentTimeMillis();
        this.makeSpace(n);
        this.currentSize += n;
        this.ht.put(string, item);
        this.v.addElement(item);
        return byArray;
    }

    public synchronized int available() {
        return this.maxSize - this.currentSize;
    }

    public synchronized boolean canCache(IOHandler iOHandler) {
        return iOHandler.length() <= (long)this.maxSize;
    }

    public synchronized int capacity() {
        return this.maxSize;
    }

    public synchronized byte[] get(IOHandler iOHandler) throws IOException {
        String string = iOHandler.getCanonicalPath();
        Object v = this.ht.get(string);
        int n = (int)iOHandler.length();
        if (v == null) {
            if (n > this.maxSize) {
                return null;
            }
            return this.addItem(string, iOHandler);
        }
        Item item = (Item)v;
        if (iOHandler.lastModified() != item.lastModified || n != item.bytes.length) {
            this.currentSize -= item.bytes.length;
            this.ht.remove(string);
            this.v.removeElement(item);
            if (n > this.maxSize) {
                return null;
            }
            return this.addItem(string, iOHandler);
        }
        item.lastAccessed = System.currentTimeMillis();
        return item.bytes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getFile(IOHandler iOHandler) throws IOException {
        byte[] byArray;
        BufferedInputStream bufferedInputStream;
        block7: {
            byte[] byArray2;
            block6: {
                bufferedInputStream = new BufferedInputStream(iOHandler.getInputStream());
                try {
                    int n = (int)iOHandler.length();
                    byte[] byArray3 = new byte[n];
                    if (iOHandler instanceof FileIOHandler) {
                        n -= bufferedInputStream.read(byArray3);
                    } else {
                        int n2 = 0;
                        while (n > 0) {
                            int n3 = bufferedInputStream.read(byArray3, n2, n);
                            n2 += n3;
                            n -= n3;
                        }
                    }
                    if (n != 0) {
                        byArray2 = null;
                        Object var5_9 = null;
                        if (bufferedInputStream == null) return byArray2;
                        break block6;
                    }
                    byArray = byArray3;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var5_11 = null;
                    if (bufferedInputStream == null) throw throwable;
                    ((FilterInputStream)bufferedInputStream).close();
                    throw throwable;
                }
            }
            ((FilterInputStream)bufferedInputStream).close();
            return byArray2;
        }
        Object var5_10 = null;
        if (bufferedInputStream == null) return byArray;
        ((FilterInputStream)bufferedInputStream).close();
        return byArray;
    }

    private void makeSpace(int n) {
        int n2 = this.maxSize - this.currentSize;
        if (n > n2) {
            QuickSortFileCacheItems quickSortFileCacheItems = new QuickSortFileCacheItems();
            int n3 = this.v.size();
            Object[] objectArray = new Item[n3];
            this.v.copyInto(objectArray);
            objectArray = quickSortFileCacheItems.sort((Item[])objectArray);
            int n4 = 0;
            while (n4 < n3) {
                if (this.currentSize >= n) {
                    return;
                }
                Object object = objectArray[n4];
                this.currentSize -= ((Item)object).bytes.length;
                this.v.removeElement(object);
                this.ht.remove(((Item)object).fname);
                ++n4;
            }
        }
    }

    public synchronized void remove(IOHandler iOHandler) throws IOException {
        String string = iOHandler.getCanonicalPath();
        Object v = this.ht.get(string);
        if (v != null) {
            this.v.removeElement(v);
            this.ht.remove(string);
        }
    }

    public synchronized void resize(int n) {
        if (n < this.maxSize) {
            this.makeSpace(this.maxSize - n);
        }
        this.maxSize = n;
    }

    public synchronized int size() {
        return this.currentSize;
    }

    class Item {
        String fname;
        long lastAccessed;
        byte[] bytes;
        long lastModified;

        Item() {
        }
    }

    class QuickSortFileCacheItems
    extends QuickSort {
        QuickSortFileCacheItems() {
        }

        public int compare(Object object, Object object2) {
            return (int)(((Item)object).lastAccessed - ((Item)object2).lastAccessed);
        }

        public int count(Object object) {
            return ((Item[])object).length;
        }

        public Object extract(Object object, int n) {
            Item[] itemArray = (Item[])object;
            return itemArray[n];
        }

        public Object replace(Object object, int n, Object object2) {
            Item[] itemArray = (Item[])object;
            itemArray[n] = (Item)object2;
            return itemArray;
        }

        public Item[] sort(Item[] itemArray) {
            return (Item[])super.sort(itemArray);
        }
    }
}

