/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import stec.iws.RequestHandler;
import stec.iws.RequestInputStream;
import stec.iws.Session;
import stec.iws.Utils;
import stec.iws.iws;

public class Request
implements HttpServletRequest {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";
    protected String auth_type;
    protected String auth_user;
    protected String auth_password;
    protected String https;
    protected String location;
    protected String instance_id;
    protected String server_software;
    protected String remote_host;
    protected String remote_addr;
    protected String server_name;
    protected int server_port;
    protected String request_method;
    protected String request_uri;
    protected String query_string;
    protected String script_name;
    protected String base_uri;
    protected String server_protocol;
    protected String path_translated;
    protected String local_addr;
    protected String path_info;
    protected Hashtable attributes = new Hashtable();
    protected Hashtable headers = new Hashtable();
    protected Hashtable params;
    private boolean inputRead = false;
    protected Cookie[] cookies;
    protected RequestInputStream requestInputStream;
    protected BufferedReader servletReader;
    protected int sessionSource = 0;
    protected Session session;
    protected String sessionID;
    protected int whichInputStream = 0;
    protected static final int NONE = 0;
    protected static final int SERVLET_READER = 1;
    protected static final int SERVLET_INPUT_STREAM = 2;
    protected RequestHandler handler;

    protected Request(RequestHandler requestHandler) {
        this.handler = requestHandler;
        this.requestInputStream = new RequestInputStream(this);
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public String getAuthType() {
        return this.auth_type;
    }

    public String getCharacterEncoding() {
        return Utils.parseCharacterEncoding(this.getContentType());
    }

    public int getContentLength() {
        String string = (String)this.headers.get("Content-Length");
        if (string == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public String getContentType() {
        return (String)this.headers.get("Content-Type");
    }

    protected static final String getCookieSessionId(Cookie[] cookieArray) {
        if (cookieArray == null || cookieArray.length == 0) {
            return null;
        }
        int n = 0;
        while (n < cookieArray.length) {
            if (cookieArray[n].getName().equals(iws.sessionName)) {
                return cookieArray[n].getValue();
            }
            ++n;
        }
        return null;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public long getDateHeader(String string) {
        String string2 = (String)this.headers.get(string);
        if (string2 == null) {
            return -1L;
        }
        return Utils.parseDate(string2);
    }

    public String getHeader(String string) {
        return (String)this.headers.get(string);
    }

    public Enumeration getHeaderNames() {
        return this.headers.keys();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.whichInputStream == 1) {
            throw new IllegalStateException("getReader() has been called.");
        }
        this.whichInputStream = 2;
        this.inputRead = true;
        return this.requestInputStream;
    }

    public int getIntHeader(String string) {
        String string2 = (String)this.headers.get(string);
        if (string2 == null) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    public String getLocalAddr() {
        return this.local_addr;
    }

    public String getMethod() {
        return this.request_method;
    }

    public String getParameter(String string) {
        this.parseParams();
        Object v = this.params.get(string);
        if (v == null) {
            return null;
        }
        return ((String[])v)[0];
    }

    public Enumeration getParameterNames() {
        this.parseParams();
        return this.params.keys();
    }

    public String[] getParameterValues(String string) {
        this.parseParams();
        Object v = this.params.get(string);
        if (v == null) {
            return null;
        }
        return (String[])v;
    }

    public String getPathInfo() {
        return this.path_info;
    }

    public String getPathTranslated() {
        return this.path_translated;
    }

    public String getProtocol() {
        return this.server_protocol;
    }

    public String getQueryString() {
        return this.query_string;
    }

    public BufferedReader getReader() throws IOException {
        if (this.whichInputStream == 2) {
            throw new IllegalStateException("getInputStream() has been called.");
        }
        if (this.servletReader == null) {
            this.servletReader = new BufferedReader(new InputStreamReader((InputStream)((Object)this.requestInputStream), Utils.parseCharacterEncoding(this.getContentType())));
            this.whichInputStream = 1;
            this.inputRead = true;
        }
        return this.servletReader;
    }

    public String getRealPath(String string) {
        try {
            return Utils.translatePath(this.server_name, string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getRemoteAddr() {
        return this.remote_addr;
    }

    public String getRemoteHost() {
        return this.remote_host;
    }

    public String getRemoteUser() {
        return (String)this.headers.get("Remote-User");
    }

    protected int getRequest() throws Exception {
        String string;
        String string2;
        String string3 = null;
        try {
            string3 = this.requestInputStream._readLine();
        }
        catch (IOException iOException) {
            return 0;
        }
        if (string3 == null) {
            return 0;
        }
        if (string3.length() == 0) {
            return 0;
        }
        int n = string3.indexOf(32);
        if (n == -1) {
            return -1;
        }
        this.request_method = string3.substring(0, n);
        int n2 = string3.lastIndexOf(32);
        if (n2 == -1) {
            return -1;
        }
        this.request_uri = string2 = string3.substring(n + 1, n2);
        n = string2.indexOf(63);
        if (n != -1) {
            this.query_string = string2.substring(n + 1);
            string2 = string2.substring(0, n);
        }
        this.base_uri = string2;
        this.script_name = string2 = Utils.decodeURL(Utils.normalizeURI(string2));
        this.server_protocol = string3.substring(n2 + 1);
        while (true) {
            if (iws.shutdown) {
                return -1;
            }
            string3 = this.requestInputStream._readLine();
            if (string3 == null) {
                return -1;
            }
            if (string3.length() == 0) break;
            n = string3.indexOf(58);
            if (n == -1) continue;
            String string4 = string3.substring(0, n);
            string = string3.substring(n + 1).trim();
            this.headers.put(Request.normalizeName(string4), string);
        }
        this.local_addr = string = InetAddress.getLocalHost().getHostAddress();
        String string5 = (String)this.headers.get("Host");
        if (string5 == null) {
            string5 = iws.dns_lookup ? InetAddress.getLocalHost().getHostName() : string;
            this.server_port = iws.port;
        } else {
            n = string5.indexOf(58);
            if (n == -1) {
                this.server_port = iws.port;
            } else {
                string = string5.substring(n + 1);
                try {
                    this.server_port = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.server_port = -1;
                }
                string5 = string5.substring(0, n);
            }
        }
        this.server_name = string5;
        this.path_translated = Utils.translatePath(this.server_name, string2);
        this.remote_addr = string = this.handler.socket.getInetAddress().getHostAddress();
        if (iws.dns_lookup) {
            string = this.handler.socket.getInetAddress().getHostName();
        }
        this.remote_host = string;
        this.server_software = "Servertec-IWS/1.6";
        this.cookies = Utils.parseCookieHeader(this.getHeader("Cookie"));
        this.sessionID = Request.getCookieSessionId(this.cookies);
        if (this.sessionID == null) {
            this.sessionID = Request.getUrlSessionId(Utils.getParameters(this));
            if (this.sessionID != null) {
                this.sessionSource = 1;
            }
        } else {
            this.sessionSource = 2;
        }
        if (this.sessionID != null) {
            this.session = (Session)iws.sessionContext.getSession(this.sessionID);
            if (this.session == null) {
                this.sessionID = null;
                this.sessionSource = 0;
            } else if (this.session.isValid()) {
                this.session.access();
                this.instance_id = this.sessionID;
            } else {
                this.session = null;
                this.sessionID = null;
                this.sessionSource = 0;
            }
        }
        this.requestInputStream.setBytesAvailable(this.getContentLength());
        return 1;
    }

    public String getRequestURI() {
        if (this.request_uri != null) {
            return this.request_uri;
        }
        if (this.getPathInfo() == null) {
            return this.getServletPath();
        }
        return String.valueOf(this.getServletPath()) + this.getPathInfo();
    }

    public String getRequestedSessionId() {
        return this.sessionID;
    }

    public String getScheme() {
        if (this.https != null) {
            if (this.https.equalsIgnoreCase("on")) {
                return "https";
            }
            if (this.https.equalsIgnoreCase("off")) {
                return "http";
            }
        }
        if (this.getServerPort() == 443) {
            return "https";
        }
        return "http";
    }

    public String getServerName() {
        return this.server_name;
    }

    public int getServerPort() {
        return this.server_port;
    }

    public String getServletPath() {
        return this.script_name;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean bl) {
        if (this.session != null) {
            return this.session;
        }
        if (this.sessionID != null) {
            this.session = (Session)iws.sessionContext.getSession(this.sessionID);
            if (this.session != null) {
                return this.session;
            }
        }
        if (bl) {
            this.session = iws.sessionContext.createSession(this.handler);
            return this.session;
        }
        return null;
    }

    private static final String getUrlSessionId(String string) {
        if (string == null) {
            return null;
        }
        try {
            Hashtable hashtable = HttpUtils.parseQueryString((String)string);
            Object v = hashtable.get(iws.sessionName);
            if (v == null) {
                return null;
            }
            return ((String[])v)[0];
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    protected void init(Socket socket) throws Exception {
        this.requestInputStream._init(new BufferedInputStream(socket.getInputStream()));
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.sessionSource == 2;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.sessionSource == 1;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        if (this.sessionID == null) {
            return false;
        }
        return iws.sessionContext.getSession(this.sessionID) != null;
    }

    private static String normalizeName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (bl) {
                c = Character.toUpperCase(c);
                bl = false;
            } else {
                c = Character.toLowerCase(c);
            }
            stringBuffer.append(c);
            if (c == '-') {
                bl = true;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected void parseParams() {
        if (this.params != null) {
            return;
        }
        String string = this.getMethod();
        if (string.equals("GET")) {
            String string2 = Utils.getParameters(this);
            if (string2 == null) {
                this.params = new Hashtable();
                return;
            }
            this.params = HttpUtils.parseQueryString((String)string2);
            return;
        }
        if (string.equals("POST")) {
            String string3 = Utils.getParameters(this);
            Hashtable hashtable = string3 == null ? new Hashtable() : HttpUtils.parseQueryString((String)string3);
            if (this.inputRead) {
                this.params = hashtable;
                return;
            }
            this.inputRead = true;
            ServletInputStream servletInputStream = null;
            try {
                servletInputStream = this.getInputStream();
            }
            catch (Exception exception) {
                this.params = hashtable;
                return;
            }
            this.params = HttpUtils.parsePostData((int)this.getContentLength(), (ServletInputStream)servletInputStream);
            if (this.params == null) {
                this.params = new Hashtable();
            }
            this.params = Utils.mergeParameters(this.params, hashtable);
            return;
        }
        this.params = new Hashtable();
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    protected void reset() {
        this.auth_type = null;
        this.auth_user = null;
        this.auth_password = null;
        this.https = null;
        this.location = null;
        this.instance_id = null;
        this.server_software = null;
        this.remote_host = null;
        this.remote_addr = null;
        this.server_name = null;
        this.server_port = -1;
        this.request_method = null;
        this.request_uri = null;
        this.query_string = null;
        this.script_name = null;
        this.base_uri = null;
        this.server_protocol = null;
        this.path_translated = null;
        this.local_addr = null;
        this.cookies = null;
        this.attributes.clear();
        this.headers.clear();
        this.params = null;
        this.inputRead = false;
        this.servletReader = null;
        this.whichInputStream = 0;
        this.sessionSource = 0;
        this.session = null;
        this.sessionID = null;
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }
}

