/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import stec.iws.Realm;
import stec.iws.ServletContextImpl;
import stec.iws.Utils;
import stec.iws.iws;

public class ServletManager {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";
    protected Hashtable servletContexts = new Hashtable();
    protected Hashtable realmContexts = new Hashtable();

    ServletManager() {
    }

    private static String _getFilter(String string) {
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? "." : string.substring(n).toLowerCase();
        Object v = iws.aliases.get(string2);
        if (v == null) {
            return null;
        }
        return (String)v;
    }

    protected void destroyRealms() {
        if (this.realmContexts == null) {
            return;
        }
        Hashtable hashtable = this.realmContexts;
        synchronized (hashtable) {
            Enumeration enumeration = this.realmContexts.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    ((ServletContextImpl)enumeration.nextElement()).servlet.destroy();
                }
                catch (Exception exception) {
                    iws.logger.log(exception);
                }
            }
            return;
        }
    }

    protected void destroyServlets() {
        if (this.servletContexts == null) {
            return;
        }
        Hashtable hashtable = this.servletContexts;
        synchronized (hashtable) {
            Enumeration enumeration = this.servletContexts.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    ((ServletContextImpl)enumeration.nextElement()).servlet.destroy();
                }
                catch (Exception exception) {
                    iws.logger.log(exception);
                }
            }
            return;
        }
    }

    protected static String findFilter(String string) {
        String string2;
        while ((string2 = ServletManager._getFilter(string)) == null || !string2.startsWith("filter:")) {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
                continue;
            }
            int n = string.lastIndexOf(47);
            if (n == -1) {
                return null;
            }
            string = string.substring(0, n + 1);
        }
        return string;
    }

    protected static String findRealm(String string) {
        Object v;
        while ((v = iws.resources.get(string)) == null) {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
                continue;
            }
            int n = string.lastIndexOf(47);
            if (n == -1) {
                return null;
            }
            string = string.substring(0, n + 1);
        }
        return string;
    }

    protected static String findServlet(String string) {
        String string2;
        Object v;
        while ((v = iws.aliases.get(string)) == null || !(string2 = (String)v).startsWith("servlet:")) {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
                continue;
            }
            int n = string.lastIndexOf(47);
            if (n == -1) {
                return null;
            }
            string = string.substring(0, n + 1);
        }
        return string;
    }

    protected static String getFilter(String string) {
        String string2;
        while ((string2 = ServletManager._getFilter(string)) == null || !string2.startsWith("filter:")) {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
                continue;
            }
            int n = string.lastIndexOf(47);
            if (n == -1) {
                return null;
            }
            string = string.substring(0, n + 1);
        }
        return string2.substring("filter:".length());
    }

    protected static String getMime(String string) {
        Object v = iws.aliases.get(string);
        if (v == null) {
            return null;
        }
        String string2 = (String)v;
        if (string2.startsWith("mime:")) {
            return string2.substring("mime:".length());
        }
        return null;
    }

    protected static String getRealm(String string) {
        Object v;
        while ((v = iws.resources.get(string)) == null) {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
                continue;
            }
            int n = string.lastIndexOf(47);
            if (n == -1) {
                return null;
            }
            string = string.substring(0, n + 1);
        }
        return (String)v;
    }

    protected static String getServlet(String string) {
        String string2;
        Object v;
        while ((v = iws.aliases.get(string)) == null || !(string2 = (String)v).startsWith("servlet:")) {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
                continue;
            }
            int n = string.lastIndexOf(47);
            if (n == -1) {
                return null;
            }
            string = string.substring(0, n + 1);
        }
        return string2.substring("servlet:".length());
    }

    public boolean isRealmLoaded(String string) {
        return this.realmContexts.containsKey(string);
    }

    public boolean isServletLoaded(String string) {
        return this.servletContexts.containsKey(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ServletContextImpl loadRealm(String string) throws Exception {
        Hashtable hashtable = this.realmContexts;
        synchronized (hashtable) {
            Hashtable hashtable2;
            Object object = this.realmContexts.get(string);
            if (object != null) {
                return (ServletContextImpl)object;
            }
            object = iws.realms.get(string);
            if (object == null) {
                return null;
            }
            String string2 = (String)object;
            int n = string2.indexOf(63);
            if (n == -1) {
                hashtable2 = new Hashtable();
            } else {
                hashtable2 = Utils.decodeParameters(string2.substring(n + 1));
                string2 = string2.substring(0, n);
            }
            Class<?> clazz = Class.forName(string2);
            object = clazz.newInstance();
            ServletContextImpl servletContextImpl = new ServletContextImpl((Servlet)((Realm)((Object)object)), hashtable2);
            servletContextImpl.servlet.init((ServletConfig)servletContextImpl);
            this.realmContexts.put(string, servletContextImpl);
            return servletContextImpl;
        }
    }

    public ServletContextImpl loadServlet(String string) throws Exception {
        return this.loadServlet(string, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ServletContextImpl loadServlet(String string, Hashtable hashtable) throws Exception {
        Hashtable hashtable2 = this.servletContexts;
        synchronized (hashtable2) {
            Hashtable hashtable3;
            Object object = this.servletContexts.get(string);
            if (object != null) {
                return (ServletContextImpl)object;
            }
            object = iws.servlets.get(string);
            if (object == null) {
                return null;
            }
            String string2 = (String)object;
            int n = string2.indexOf(63);
            if (n == -1) {
                hashtable3 = new Hashtable();
            } else {
                hashtable3 = Utils.decodeParameters(string2.substring(n + 1));
                string2 = string2.substring(0, n);
            }
            if (hashtable != null) {
                hashtable3 = Utils.mergeParameters(hashtable3, hashtable);
            }
            Class<?> clazz = Class.forName(string2);
            object = clazz.newInstance();
            ServletContextImpl servletContextImpl = new ServletContextImpl((Servlet)object, hashtable3);
            servletContextImpl.servlet.init((ServletConfig)servletContextImpl);
            this.servletContexts.put(string, servletContextImpl);
            return servletContextImpl;
        }
    }

    public void unloadRealm(String string) throws Exception {
        Object v = this.realmContexts.remove(string);
        if (v == null) {
            return;
        }
        ServletContextImpl servletContextImpl = (ServletContextImpl)v;
        servletContextImpl.servlet.destroy();
    }

    public void unloadServlet(String string) throws Exception {
        Object v = this.servletContexts.remove(string);
        if (v == null) {
            return;
        }
        ServletContextImpl servletContextImpl = (ServletContextImpl)v;
        servletContextImpl.servlet.destroy();
    }
}

