/*
 * @(#)HeadersServlet.java
 *
 * Copyright (c) 1998-1999 Servertec. All Rights Reserved.
 *
 * This software is the proprietary and confidential property of Servertec.
 * Use only in accordance with the terms of the license agreement.
 *
 * SERVERTEC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SERVERTEC SHALL NOT BE LIABLE FOR ANY
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.util.Enumeration;
import java.io.IOException;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletException;

import stec.iws.Utils;

public class HeadersServlet extends HttpServlet
{
    public void service(HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException
    {
        _response.setContentType("text/html");

        ServletOutputStream out = _response.getOutputStream();

        out.println("<html>");
        out.println("<head><title>Display Headers</title></head>");
        out.println("<body>");
        
        server_variables(out, _request);
        headers(out, _request);
        
        out.println("</body>");
        out.println("</html>");
        out.close();
    }
    
    protected static void server_variables(ServletOutputStream out, HttpServletRequest _request) throws IOException
    {
        out.println("<h1>Server Variables:</h1>");
        
        out.println("<lit>");
        
        out.println("AUTH_TYPE = [" + _request.getAuthType() + "]<br>");
        out.println("REQUEST_METHOD = [" + _request.getMethod() + "]<br>");
        out.println("PATH_INFO = [" + _request.getPathInfo() + "]<br>");
        out.println("PATH_TRANSLATED = [" + _request.getPathTranslated() + "]<br>");
        out.println("QUERY_STRING = [" + _request.getQueryString() + "]<br>");
        out.println("REQUEST_URI = [" + _request.getRequestURI() + "]<br>");
        out.println("SCRIPT_NAME = [" + _request.getServletPath() + "]<br>");
        //out.println("LOCAL_ADDR = [" + _request.getLocalAddr() + "]<br>");
        out.println("SERVER_PROTOCOL = [" + _request.getProtocol() + "]<br>");
        out.println("REMOTE_ADDR = [" + _request.getRemoteAddr() + "]<br>");
        out.println("REMOTE_HOST = [" + _request.getRemoteHost() + "]<br>");
        out.println("HTTPS = [" + _request.getScheme() + "]<br>");
        out.println("SERVER_NAME = [" + _request.getServerName() + "]<br>");
        out.println("SERVER_PORT = [" + _request.getServerPort() + "]<br>");

        out.println("</lit>");
    }
    
    protected static void headers(ServletOutputStream out, HttpServletRequest _request) throws IOException
    {
        out.println("<h1>Headers:</h1>");
        
        out.println("<lit>");

        String key;
        String value;
        
        Enumeration vars = _request.getHeaderNames();
        while(vars.hasMoreElements())
        {
            key = (String)vars.nextElement();
            value = _request.getHeader(key);
            out.println(key + " = [" + value + "]<br>");
        }

        out.println("</lit>");
    }

    public String getServletInfo()
    {
        return "HeadersServlet";
    }
}
