/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.SystemColor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class DProperties {
    VectorString keys;
    VectorString values;

    public DProperties(int n) {
        this.keys = new VectorString(n);
        this.values = new VectorString(n);
    }

    public DProperties() {
        this(64);
    }

    public void list(PrintStream printStream) {
        for (int i = 0; i < this.keys.size(); ++i) {
            printStream.println(String.valueOf(new StringBuffer(String.valueOf(this.keys.elementAt(i))).append("=").append(this.values.elementAt(i))));
        }
    }

    public String getProperty(String string, String string2) {
        int n = this.keys.indexOf(string);
        if (n == -1) {
            return string2;
        }
        return this.values.elementAt(n);
    }

    public String get(String string, String string2) {
        if (string2.equals("null")) {
            string2 = null;
        }
        return this.getProperty(string, string2);
    }

    public int get(String string, int n) {
        try {
            String string2 = this.get(string, String.valueOf(n));
            int n2 = Integer.valueOf(string2);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public boolean get(String string, boolean bl) {
        try {
            String string2 = this.get(string, String.valueOf(bl));
            boolean bl2 = Boolean.valueOf(string2);
            return bl2;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public VectorString get(String string, String string2, String string3) {
        VectorString vectorString = new VectorString(3);
        int n = this.keys.indexOf(string);
        if (n == -1) {
            if (string2 != null) {
                vectorString.addElement(string2);
            }
            if (string3 != null) {
                vectorString.addElement(string3);
            }
            return vectorString;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.values.elementAt(n), " ,:\t\n\r", false);
        int n2 = stringTokenizer.countTokens();
        while (stringTokenizer.hasMoreTokens()) {
            vectorString.addElement(stringTokenizer.nextToken());
        }
        return vectorString;
    }

    public static String colorToString(Color color) {
        return Integer.toString(color.getRGB());
    }

    public static Color stringToColor(String string) {
        int n = ColorList.getIndex(string);
        if (n == -1) {
            try {
                int n2 = Integer.valueOf(string);
                int n3 = n2 >> 16 & 0xFF;
                int n4 = n2 >> 8 & 0xFF;
                int n5 = n2 & 0xFF;
                Color color = new Color(n3, n4, n5);
                return color;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return Color.lightGray;
            }
        }
        return ColorList.getColor(n);
    }

    public String get(String string, Color color) {
        return this.get(string, DProperties.colorToString(color));
    }

    public String get(String string, SystemColor systemColor) {
        return this.get(string, DProperties.colorToString(systemColor));
    }

    public String get(String string, Style style) {
        return this.get(string, style.getString());
    }

    public void putItem(String string) {
        int n = string.indexOf("=");
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            if (string2 != null) {
                this.keys.addElement(string2);
                if (string3 == null) {
                    string3 = "";
                }
                this.values.addElement(string3);
            }
        }
    }

    public int load(String string, String string2) {
        String string3 = Path.merge(string, string2);
        int n = 0;
        try {
            FileReader fileReader = new FileReader(string3);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string4 = "";
            while (string4 != null) {
                try {
                    string4 = bufferedReader.readLine();
                    if (string4 == null || string4.startsWith("#")) continue;
                    this.putItem(string4);
                    ++n;
                }
                catch (IOException iOException) {
                    string4 = null;
                }
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(String.valueOf(string3).concat(" not found"));
        }
        return n;
    }

    public void put(String string) {
        this.keys.addElement(string);
        this.values.addElement((String)null);
    }

    public void put(String string, String string2) {
        this.keys.addElement(string);
        this.values.addElement(string2);
    }

    public void put(String string, int n) {
        this.put(string, new Integer(n).toString());
    }

    public void put(String string, boolean bl) {
        this.put(string, new Boolean(bl).toString());
    }

    public void put(String string, Style style) {
        this.put(string, style.getString());
    }

    public void put(String string, Color color) {
        this.put(string, DProperties.colorToString(color));
    }

    public int save(String string, String string2) {
        int n = 0;
        String string3 = Path.merge(string, string2);
        try {
            FileWriter fileWriter = new FileWriter(string3);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            int n2 = this.keys.size();
            for (int i = 0; i < n2; ++i) {
                String string4 = this.keys.elementAt(i);
                String string5 = this.values.elementAt(i);
                if (string5 != null) {
                    string4 = String.valueOf(new StringBuffer(String.valueOf(string4)).append("=").append(string5));
                }
                bufferedWriter.write(string4, 0, string4.length());
                bufferedWriter.newLine();
                ++n;
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Error writing ".concat(String.valueOf(string3)));
        }
        return n;
    }

    public static boolean delete(String string, String string2) {
        return new File(string, string2).delete();
    }
}

