/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;

class Raw {
    short width;
    short height;
    byte bottomToTop;
    byte compression;
    byte colorModel;
    byte palette;
    byte transparent;
    byte version = 0;
    int[] code;
    static final byte BTRUE = 1;
    static final byte BFALSE = 0;
    static final byte UNCOMPRESSED = 0;
    static final byte RLE = 1;
    static final byte DIRECT = 0;
    static final byte INDEXED = 1;

    public Raw() {
        this.bottomToTop = 0;
        this.palette = 0;
        this.compression = 0;
        this.colorModel = 1;
        this.transparent = 0;
    }

    public Raw(int[] nArray, int n, int n2) {
        this();
        this.width = (short)n;
        this.height = (short)n2;
        this.code = nArray;
    }

    public Raw(byte[] byArray) {
        this.width = (short)(Raw.unsigned(byArray[0]) * 256 + Raw.unsigned(byArray[1]));
        this.height = (short)(Raw.unsigned(byArray[2]) * 256 + Raw.unsigned(byArray[3]));
        this.bottomToTop = byArray[4];
        this.compression = byArray[5];
        this.colorModel = byArray[6];
        this.palette = byArray[7];
        this.transparent = byArray[8];
        this.version = byArray[9];
        int n = this.width * this.height;
        this.code = new int[n];
        int n2 = 0;
        int n3 = 10;
        while (n2 < n) {
            int n4;
            if (this.colorModel == 0) {
                n4 = Raw.unsigned(byArray[n3]) << 24 | (Raw.unsigned(byArray[n3 + 1]) << 16) + (Raw.unsigned(byArray[n3 + 2]) << 8) + Raw.unsigned(byArray[n3 + 3]);
                n3 += 4;
            } else {
                n4 = Raw.unsigned(byArray[n3++]);
            }
            this.code[n2++] = n4;
        }
    }

    public int getPalette() {
        return Raw.unsigned(this.palette);
    }

    public int getModel() {
        return Raw.unsigned(this.colorModel);
    }

    public int getTransparent() {
        return Raw.unsigned(this.transparent);
    }

    public int getCompression() {
        return Raw.unsigned(this.compression);
    }

    public boolean isInversed() {
        return this.bottomToTop == 1;
    }

    public boolean isIndexed() {
        return this.colorModel == 1;
    }

    public int[] UnRLE() {
        int[] nArray = this.code;
        return nArray;
    }

    public int[] getPixels() {
        switch (this.compression) {
            case 1: {
                return this.UnRLE();
            }
        }
        return this.code;
    }

    public byte[] getBytes() {
        int n = this.width * this.height;
        if (this.colorModel == 0) {
            n *= 4;
        }
        System.out.println("getBytes enter - code size ".concat(String.valueOf(n)));
        byte[] byArray = new byte[n + 10];
        try {
            byArray[0] = Raw.signed(this.width / 256);
            byArray[1] = Raw.signed(this.width - byArray[1] * 256);
            byArray[2] = Raw.signed(this.height / 256);
            byArray[3] = Raw.signed(this.height - byArray[3] * 256);
            byArray[4] = this.bottomToTop;
            byArray[5] = this.compression;
            byArray[6] = this.colorModel;
            byArray[7] = this.palette;
            byArray[8] = this.transparent;
            byArray[9] = this.version;
            int[] nArray = this.bottomToTop == 1 ? Raw.invert(this.code, this.width, this.height) : this.code;
            if (this.colorModel == 1) {
                for (int i = 0; i < n; ++i) {
                    byArray[10 + i] = Raw.signed(nArray[i]);
                }
            } else {
                int n2 = 10;
                for (int i = 0; i < n; ++i) {
                    int n3 = nArray[i];
                    byArray[n2++] = Raw.signed(n3 >> 24 & 0xFF);
                    byArray[n2++] = Raw.signed(n3 >> 16 & 0xFF);
                    byArray[n2++] = Raw.signed(n3 >> 8 & 0xFF);
                    byArray[n2++] = Raw.signed(n3 & 0xFF);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        return byArray;
    }

    static int unsigned(byte by) {
        if (by < 0) {
            return by + 256;
        }
        return by;
    }

    static byte signed(int n) {
        return n < 128 ? (byte)n : (byte)(n - 256);
    }

    static int[] invert(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n * n2];
        int n3 = n2 - 1;
        for (int i = 0; i < n2; ++i) {
            int n4 = i * n + 6;
            int n5 = (n3 - i) * n;
            for (int j = 0; j < n; ++j) {
                nArray2[n5 + j] = nArray[n4 + j];
            }
        }
        return nArray2;
    }

    public Image getImage() {
        MemoryImageSource memoryImageSource;
        if (this.colorModel == 1) {
            ColorModel colorModel = new PaletteShaded().getColorModel();
            memoryImageSource = new MemoryImageSource((int)this.width, (int)this.height, colorModel, this.getPixels(), 0, (int)this.width);
        } else {
            memoryImageSource = new MemoryImageSource(this.width, this.height, this.getPixels(), 0, this.width);
        }
        return Toolkit.getDefaultToolkit().createImage(memoryImageSource);
    }

    public static Image getImage(byte[] byArray) {
        int n = byArray[0] + byArray[1] * 256;
        int n2 = byArray[2] + byArray[3] * 256;
        PaletteShaded paletteShaded = new PaletteShaded();
        paletteShaded.setTransparent(Raw.unsigned(byArray[8]));
        ColorModel colorModel = paletteShaded.getColorModel();
        MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, colorModel, byArray, 10, n, new Hashtable());
        return Toolkit.getDefaultToolkit().createImage(memoryImageSource);
    }

    public int size() {
        return this.code.length + 10;
    }

    void load(String string) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
            this.width = dataInputStream.readShort();
            this.height = dataInputStream.readShort();
            this.bottomToTop = dataInputStream.readByte();
            this.compression = dataInputStream.readByte();
            this.colorModel = dataInputStream.readByte();
            this.palette = dataInputStream.readByte();
            this.transparent = dataInputStream.readByte();
            this.version = dataInputStream.readByte();
            int n = this.width * this.height;
            this.code = new int[n];
            for (int i = 0; i < n; ++i) {
                this.code[i] = this.colorModel == 0 ? dataInputStream.readInt() : Raw.unsigned(dataInputStream.readByte());
            }
            if (this.bottomToTop == 1) {
                this.code = Raw.invert(this.code, this.width, this.height);
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

