// ReportSummaryTask.h: interface for the ReportSummaryTask class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_REPORTSUMMARYTASK_H__29F6C77D_5A6E_4CE8_9CD8_B438BF6F1B43__INCLUDED_)
#define AFX_REPORTSUMMARYTASK_H__29F6C77D_5A6E_4CE8_9CD8_B438BF6F1B43__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <atask\Task.h>
#include <atask\Synchronization.h>
#include "Philosopher.h"

class ReportSummaryTask : public Task  
{
public:
	struct UpdateParams {
		PhilosopherId id;
		PhilosopherState state;
		Milliseconds time;
	};

	Entry<UpdateParams> update;
	Entry0 end;
	MsgEntry msg_entry;

	ReportSummaryTask();
	~ReportSummaryTask();

protected:
	Priority priority();
	void body();
	size_t virtual_sizeof();
private:
	struct PhilosopherStateSummary {
		int count;
		Milliseconds time;
	};
	typedef PhilosopherStateSummary Summary[N_PHILOSOPHERS][nPhilosopherState];

	bool initialize_window(int cmdShow);
	void initialize_window_controls();
	void message_loop(Summary summary);
	void update_control
		(PhilosopherId id, PhilosopherState state, PhilosopherStateSummary &total);

	static LRESULT CALLBACK window_proc
		(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

	HINSTANCE hInstance;
	HWND hWnd;
	HFONT font;

	class WindowClass;
};

#endif // !defined(AFX_REPORTSUMMARYTASK_H__29F6C77D_5A6E_4CE8_9CD8_B438BF6F1B43__INCLUDED_)
