// TableTop.cpp: implementation of the TableTop class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TableTop.h"
#include "ForkServerTask.h"

//////////////////////////////////////////////////////////////////////
// Static Definitions
//////////////////////////////////////////////////////////////////////

static ForkServerTask fork_server;

//////////////////////////////////////////////////////////////////////
// Member Functions
//////////////////////////////////////////////////////////////////////

void TableTop::grab_forks(PhilosopherId id)
{
	fork_server.request_and_wait[id]();
}

void TableTop::release_forks(PhilosopherId id)
{
	fork_server.release(id);
}

void TableTop::end_diner(Task* philo_ptrs[])
{
	Task* task_ptrs[N_PHILOSOPHERS + 2];

	for (int ix = 0; ix < N_PHILOSOPHERS; ix++) {
		task_ptrs[ix] = philo_ptrs[ix];
	}
	task_ptrs[N_PHILOSOPHERS] = &fork_server;
	task_ptrs[N_PHILOSOPHERS + 1] = NULL;
	// Terminate philosophers and fork server
	terminate_all(task_ptrs);
}

