/*
 * Copyright (C) 2001 Advanced Software Engineering Limited.
 *
 * This file is part of the ChartDirector software. Usage of this file is
 * subjected to the ChartDirector license agreement. See the LICENSE.TXT
 * file that comes with the ChartDirector software release, or visit
 * Advanced Software Engineering's web site at www.advsofteng.com or 
 * email to support@advsofteng.com for information.
 *
 */
 
#ifndef PLANE_HDR
#define PLANE_HDR


#include "drawobj.h"


const double NoValue = +1.7e308;


class DataSet 
{
public :
	~DataSet() {}
	virtual void setData(int noOfPoints, const double *data) = 0;
	virtual void setDataName(const char *name) = 0;
	virtual void setDataColor(int dataColor, int edgeColor = LineColor, 
		int shadowColor = -1, int shadowEdgeColor = -1) = 0;
	virtual void setUseYAxis2(bool b = true) = 0;

	virtual void setLineWidth(int w) = 0;

	virtual void setDataLabelFormat(const char *formatString) = 0;
	virtual TextStyle *setDataLabelStyle(const char *font = 0, double fontSize = 8, 
		int fontColor = TextColor, double fontAngle = 0) = 0;
};


class LegendBox;
class XYChart;

class Layer
{
public :
	virtual void destroy() = 0;
	virtual ~Layer() {}
	virtual void setSize(int x, int y, int w, int h) = 0;
	virtual void set3D(int d = -1, int zGap = 0) = 0;
	virtual void set3D(int xDepth, int yDepth, int xGap, int yGap) = 0;
	virtual void setLineWidth(int w) = 0;

	enum DataCombineMethod { Overlay, Stack, Depth, Side };
	virtual void setDataCombineMethod(DataCombineMethod m) = 0;
	virtual DataSet *addDataSet(int noOfPoints, const double *d, int color = -1, const char *name = 0) = 0;

	virtual double getMinX() = 0;
	virtual double getMaxX() = 0;
	virtual double getMaxY(bool yAxis = true) = 0;
	virtual double getMinY(bool yAxis = true) = 0;
	virtual int getDepthX() = 0;
	virtual int getDepthY() = 0;

	virtual int getXCoor(double v) = 0;
	virtual int getYCoor(double v, bool yAxis = true) = 0;

	virtual void layout(XYChart *c, int *autoColor) = 0;
	virtual void paint(XYChart *c) = 0;

	virtual void setDataLabelFormat(const char *formatString) = 0;
	virtual TextStyle *setDataLabelStyle(const char *font = 0, double fontSize = 8, 
		int fontColor = TextColor, double fontAngle = 0) = 0;

	virtual void setAggregateLabelFormat(const char *formatString) = 0;
	virtual TextStyle *setAggregateLabelStyle(const char *font = 0, double fontSize = 8, 
		int fontColor = TextColor, double fontAngle = 0) = 0;

};


#endif