import sys
ver = sys.version[:3]
if ver == "1.5" :
	import pychartdir15
	dll = pychartdir15
elif ver == "1.6" :
	import pychartdir16
	dll = pychartdir16
elif ver == "2.0" :
	import pychartdir20
	dll = pychartdir20
elif ver == "2.1" :
	import pychartdir21
	dll = pychartdir21
else :
	import pychartdir15
	dll = pychartdir15

#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to libgraphics.h
#///////////////////////////////////////////////////////////////////////////////////
BottomLeft = 1
BottomCenter = 2
BottomRight = 3	
Left = 4
Center = 5
Right = 6
TopLeft = 7
TopCenter = 8
TopRight = 9
Top = TopCenter
Bottom = BottomCenter

class TTFText :
	NoAntiAlias = 0
	AntiAlias = 1
	AutoAntiAlias = 2
	def __init__(self, this, parent) :
		self.this = this
		self.parent = parent
	def __del__(self) :
		dll.callMethod("DrawArea.close", self.parent.this, self.this)
	def getWidth(self) :
		return dll.callMethod("TTFText.getWidth", self.this)
	def getHeight(self) :
		return dll.callMethod("TTFText.getHeight", self.this)
	def getLineHeight(self) :
		return dll.callMethod("TTFText.getLineHeight", self.this)
	def getLineDistance(self) :
		return dll.callMethod("TTFText.getLineDistance", self.this)
	def draw(self, x, y, color, alignment) :
		dll.callMethod("TTFText.draw", self.this, x, y, color, alignment)

class DrawArea :
	TryPalette = 0
	ForcePalette = 1
	NoPalette = 2
	Quantize = 0
	OrderedDither = 1
	ErrorDiffusion = 2
	def __init__(self, this = None) :
		if this == None :
			self.own_this = 1
			self.this = dll.callMethod("DrawArea.create")
		else :
			self.own_this = 0
			self.this = this
	def __del__(self) :
		if self.own_this :
			dll.callMethod("DrawArea.destroy", self.this)
	def setSize(self, width, height, bgColor = 0xffffff) :
		dll.callMethod("DrawArea.setSize", self.this, width, height, bgColor)
	def getWidth(self) :
		return dll.callMethod("DrawArea.getWidth", self.this)
	def getHeight(self) :
		return dll.callMethod("DrawArea.getHeight", self.this)
	def setBgColor(self, c) :
		dll.callMethod("DrawArea.setBgColor", self.this, c)
	def pixel(self, x, y, c) :
		dll.callMethod("DrawArea.pixel", self.this, x, y, c)
	def getPixel(self, x, y) :
		return dll.callMethod("DrawArea.getPixel", self.this, x, y)
	def hline(self, x1, x2, y, c) :
		dll.callMethod("DrawArea.hline", self.this, x1, x2, y, c)
	def vline(self, y1, y2, x, c) :
		dll.callMethod("DrawArea.vline", self.this, y1, y2, x, c)
	def line(self, x1, y1, x2, y2, c, lineWidth = 1) :
		dll.callMethod("DrawArea.line", self.this, x1, y1, x2, y2, c, lineWidth)
	def arc(self, cx, cy, rx, ry, a1, a2, c) :
		dll.callMethod("DrawArea.arc", self.this, cx, cy, rx, ry, a1, a2, c)
	def rect(self, x1, y1, x2, y2, edgeColor, fillColor) :
		dll.callMethod("DrawArea.rect", self.this, x1, y1, x2, y2, edgeColor, fillColor)
	def polygon(self, points, edgeColor, fillColor) :
		dll.callMethod("DrawArea.polygon", self.this, 
			map(lambda a: a[0], points), map(lambda a: a[1], points), len(points), edgeColor, fillColor)
	def surface(self, x1, y1, x2, y2, depthX, depthY, edgeColor, fillColor) :
		dll.callMethod("DrawArea.surface", self.this, x1, y1, x2, y2, depthX, depthY, edgeColor, fillColor)
	def sector(self, cx, cy, rx, ry, a1, a2, edgeColor, fillColor) :
		dll.callMethod("DrawArea.sector", self.this, cx, cy, rx, ry, a1, a2, edgeColor, fillColor)
	def cylinder(self, cx, cy, rx, ry, a1, a2, depthX, depthY, edgeColor, fillColor) :
		dll.callMethod("DrawArea.cylinder", self.this, cx, cy, rx, ry, a1, a2, depthX, depthY, edgeColor, fillColor)
	def circle(self, cx, cy, rx, ry, edgeColor, fillColor) :
		dll.callMethod("DrawArea.circle", self.this, cx, cy, rx, ry, edgeColor, fillColor)
	def fill(self, x, y, color, borderColor = None) :
		if borderColor == None :
			dll.callMethod("DrawArea.fill", self.this, x, y, color)
		else :
			self.fill2(x, y, color, borderColor)
	def fill2(self, x, y, color, borderColor) :
		dll.callMethod("DrawArea.fill2", self.this, x, y, color, borderColor)
	def text(self, str, font, fontSize,	x, y, color) :
		dll.callMethod("DrawArea.text", self.this, str, font, fontSize, x, y, color)
	def text2(self, str, font, fontIndex, fontHeight, fontWidth, angle, vertical, x, y, color, alignment = TopLeft) :
		dll.callMethod("DrawArea.text2", self.this, str, font, fontIndex, fontHeight, fontWidth, angle, vertical, x, y, color, alignment)
	def text3(self, str, font, fontSize) :
		return TTFText(dll.callMethod("DrawArea.text3", self.this, str, font, fontSize), self)
	def text4(self, text, font, fontIndex, fontHeight, fontWidth, angle, vertical) :
		return TTFText(dll.callMethod("DrawArea.text4", self.this, text, font, fontIndex, fontHeight, fontWidth, angle, vertical), self)
	def merge(self, d, x, y, align, transparency) :
		dll.callMethod("DrawArea.merge", self.this, d.this, x, y, align, transparency)
	def tile(self, d, transparency) :
		dll.callMethod("DrawArea.tile", self.this, d.this, transparency)
	def loadGIF(self, filename) :
		return dll.callMethod("DrawArea.loadGIF", self.this, filename)
	def loadPNG(self, filename) :
		return dll.callMethod("DrawArea.loadPNG", self.this, filename)
	def loadJPG(self, filename) :
		return dll.callMethod("DrawArea.loadJPG", self.this, filename)
	def loadWMP(self, filename) :
		return dll.callMethod("DrawArea.loadWMP", self.this, filename)
	def load(self, filename) :
		return dll.callMethod("DrawArea.load", self.this, filename)
	def out(self, filename) :
		return dll.callMethod("DrawArea.out", self.this, filename)
	def outGIF(self, filename) :
		return dll.callMethod("DrawArea.outGIF", self.this, filename)
	def outPNG(self, filename) :
		return dll.callMethod("DrawArea.outPNG", self.this, filename)
	def outJPG(self, filename, quality = 80) :
		return dll.callMethod("DrawArea.outJPG", self.this, filename, quality)
	def outWMP(self, filename) :
		return dll.callMethod("DrawArea.outWMP", self.this, filename)
	def outGIF2(self) :
		return dll.callMethod("DrawArea.outGIF2", self.this)
	def outPNG2(self) :
		return dll.callMethod("DrawArea.outPNG2", self.this)
	def outJPG2(self, quality = 80) :
		return dll.callMethod("DrawArea.outJPG2", self.this, quality)
	def outWMP2(self) :
		return dll.callMethod("DrawArea.outWMP2", self.this)
	def setPaletteMode(self, p) :
		dll.callMethod("DrawArea.setPaletteMode", self.this, p)
	def setDitherMethod(self, m) :
		dll.callMethod("DrawArea.setDitherMethod", self.this, m)
	def setTransparentColor(self, c) :
		dll.callMethod("DrawArea.setTransparentColor", self.this, c)
	def setAntiAliasText(self, a) :
		dll.callMethod("DrawArea.setAntiAliasText", self.this, a)
	def setInterlace(self, i) :
		dll.callMethod("DrawArea.setInterlace", self.this, i)
	def setColorTable(self, colors, offset) :
		dll.callMethod("DrawArea.setColorTable", self.this, colors, len(colors), offset)
	def getARGBColor(self, c) :
		return dll.callMethod("DrawArea.getARGBColor", self.this, c)

#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to drawobj.h
#///////////////////////////////////////////////////////////////////////////////////
Transparent = 0xff000000
Palette = 0xffff0000
BackgroundColor = 0xffff0000 
LineColor = 0xffff0001
TextColor = 0xffff0002
DataColor = 0xffff0008

class TextStyle :
	def __init__(self, this) :
		self.this = this
	def setFontStyle(self, font, fontIndex = 0) :
		dll.callMethod("TextStyle.setFontStyle", self.this, font, fontIndex)
	def setFontSize(self, fontHeight, fontWidth = 0) :
		dll.callMethod("TextStyle.setFontSize", self.this, fontHeight, fontWidth)
	def setFontAngle(self, angle, vertical = 0) :
		dll.callMethod("TextStyle.setFontAngle", self.this, angle, vertical)
	def setFontColor(self, color) :
		dll.callMethod("TextStyle.setFontColor", self.this, color)
	def setBackground(self, color, edgeColor = Transparent) :
		dll.callMethod("TextStyle.setBackground", self.this, color, edgeColor)
	def setMargin2(self, leftMargin, rightMargin, topMargin, bottomMargin) :
		dll.callMethod("TextStyle.setMargin2", self.this, 
			leftMargin, rightMargin, topMargin, bottomMargin)
	def setMargin(self, m) :
		dll.callMethod("TextStyle.setMargin", self.this, m)

class Box :
	def __init__(self, this) :
		self.this = this
	def setPos(self, x, y) :
		dll.callMethod("Box.setPos", self.this, x, y)
	def setSize(self, w, h) :
		dll.callMethod("Box.setSize", self.this, w, h)
	def setBackground(self, color, edgeColor = Transparent) :
		dll.callMethod("Box.setBackground", self.this, color, edgeColor)

class TextBox(Box, TextStyle) :
	def __init__(self, this) :
		self.this = this
	def setText(self, text) :
		dll.callMethod("TextBox.setText", self.this, text)
	def setAlignment(self, a) :
		dll.callMethod("TextBox.setAlignment", self.this, a)
	def setBackground(self, color, edgeColor = Transparent) :
		dll.callMethod("TextBox.setBackground", self.this,  color, edgeColor)

class Line : 
	def __init__(self, this) :
		self.this = this
	def setPos(self, x1, y1, x2, y2) :
		dll.callMethod("Line.setPos", self.this, x1, y1, x2, y2)
	def setColor(self, c) :
		dll.callMethod("Line.setColor", self.this, c)
	def setWidth(self, w) :
		dll.callMethod("Line.setWidth", self.this, w)

#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to basechart.h
#///////////////////////////////////////////////////////////////////////////////////
class LegendBox(TextBox) :
	def __init__(self, this) :
		self.this = this
	def addKey(self, text, color) :
		dll.callMethod("LegendBox.addKey", self.this, text, color)

class BaseChart :
	PNG = 0
	GIF = 1
	JPG = 2
	WMP = 3
	def __del__(self) :
		dll.callMethod("BaseChart.destroy", self.this)
	#//////////////////////////////////////////////////////////////////////////////////////
	#//	set overall chart
	#//////////////////////////////////////////////////////////////////////////////////////
	def setSize(self, width, height) :
		dll.callMethod("BaseChart.setSize", self.this, width, height)
	def setBorder(self, color) :
		dll.callMethod("BaseChart.setBorder", self.this, color)
	def setWallpaper(self, img) :
		dll.callMethod("BaseChart.setWallpaper", self.this, img)
	def setBgImage(self, img, align = Center) :
		dll.callMethod("BaseChart.setBgImage", self.this, img, align)
	def addTitle2(self, alignment, text, font = "", fontSize = 12, fontColor = TextColor, 
		bgColor = Transparent, edgeColor = Transparent) :
		return TextBox(dll.callMethod("BaseChart.addTitle2", self.this, 
			alignment, text, font, fontSize, fontColor, bgColor, edgeColor))
	def addTitle(self, text, font = "", fontSize = 12, fontColor = TextColor, 
		bgColor = Transparent, edgeColor = Transparent) :
		return TextBox(dll.callMethod("BaseChart.addTitle", self.this, 
			text, font, fontSize, fontColor, bgColor, edgeColor))
	def addLegend(self, x, y, vertical = 1, font = "", fontSize = 10) :
		return LegendBox(dll.callMethod("BaseChart.addLegend", self.this, 
			x, y, vertical, font, fontSize))
	def getLegend(self) :
		return LegendBox(dll.callMethod("BaseChart.getLegend", self.this))
	#//////////////////////////////////////////////////////////////////////////////////////
	#//	drawing primitives
	#//////////////////////////////////////////////////////////////////////////////////////
	def getDrawArea(self) :
		return DrawArea(dll.callMethod("BaseChart.getDrawArea", self.this))
	def addDrawObj(self, obj) :
		dll.callMethod("BaseChart.addDrawObj", obj.this)
		return obj
	def addText(self, x, y, text, font = "", fontSize = 8, fontColor = TextColor, 
		alignment = TopLeft, angle = 0, vertical = 0) :
		return TextBox(dll.callMethod("BaseChart.addText", self.this,
			x, y, text, font, fontSize, fontColor, alignment, angle, vertical))
	def addLine(self, x1, y1, x2, y2, color = LineColor, lineWidth = 1) :
		return Line(dll.callMethod("BaseChart.addLine", self.this,
			x1, y1, x2, y2, color, lineWidth))
	#//////////////////////////////////////////////////////////////////////////////////////
	#//	color management methods
	#//////////////////////////////////////////////////////////////////////////////////////
	def setColor(self, paletteEntry, color) :
		dll.callMethod("BaseChart.setColor", self.this, paletteEntry, color)
	def setColors(self, colors) :
		if len(colors) <= 0 or colors[-1] != -1 :
			colors = colors + [-1]
		dll.callMethod("BaseChart.setColors", self.this, colors)
	def setColors2(self, paletteEntry, colors) :
		if len(colors) <= 0 or colors[-1] != -1 :
			colors = colors + [-1]
		dll.callMethod("BaseChart.setColors2", self.this, paletteEntry, colors)
	def getColor(self, paletteEntry) :
		return dll.callMethod("BaseChart.getColor", self.this, paletteEntry)
	#//////////////////////////////////////////////////////////////////////////////////////
	#//	chart creation methods
	#//////////////////////////////////////////////////////////////////////////////////////
	def layout(self) :
		dll.callMethod("BaseChart.layout", self.this)
	def makeChart(self, filename) :
		return dll.callMethod("BaseChart.makeChart", self.this, filename)
	def makeChart2(self, format) :
		return dll.callMethod("BaseChart.makeChart2", self.this, format)

defaultPalette = [
	0xffffff, 0x000000, 0x000000, 0x808080, 
	0x808080, 0x808080, 0x808080, 0x808080,
	0xff0000, 0x00ff00, 0x0000ff, 0xffff00, 
	0xff00ff, 0x66ffff,	0xffcc33, 0xcccccc, 
	0x9966ff, 0x339966, 0x999900, 0xcc3300,	
	0x99cccc, 0x006600, 0x660066, 0xcc9999,
	-1
]

whiteOnBlackPalette = [
	0x000000, 0xffffff, 0xffffff, 0x808080, 
	0x808080, 0x808080, 0x808080, 0x808080,
	0xff0000, 0x00ff00, 0x0000ff, 0xffff00, 
	0xff00ff, 0x66ffff,	0xffcc33, 0xcccccc, 
	0x9966ff, 0x339966, 0x999900, 0xcc3300,	
	0x99cccc, 0x006600, 0x660066, 0xcc9999,
	-1
]

transparentPalette = [ 
	0xffffff, 0x000000, 0x000000, 0x808080, 
	0x808080, 0x808080, 0x808080, 0x808080,
	0x80ff0000, 0x8000ff00, 0x800000ff, 0x80ffff00, 
	0x80ff00ff, 0x8066ffff,	0x80ffcc33, 0x80cccccc, 
	0x809966ff, 0x80339966, 0x80999900, 0x80cc3300,
	0x8099cccc, 0x80006600, 0x80660066, 0x80cc9999,
	-1
]

#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to piechart.h
#///////////////////////////////////////////////////////////////////////////////////
class Sector :
	def __init__(self, this) :
		self.this = this
	def setExplode(self, distance = -1) :
		dll.callMethod("Sector.setExplode", self.this, distance)
	def setLabelFormat(self, formatString) :
		dll.callMethod("Sector.setLabelFormat", self.this, formatString)
	def setLabelStyle(self, font = "", fontSize = 8, fontColor = TextColor) :
		return TextBox(dll.callMethod("Sector.setLabelStyle", self.this, font, fontSize, fontColor))
	def setLabelPos(self, pos, joinLineColor = Transparent) :
		dll.callMethod("Sector.setLabelPos", self.this, pos, joinLineColor)

class PieChart(BaseChart) :
	def __init__(self, width, height, bgColor = BackgroundColor, edgeColor = Transparent) :
		self.this = dll.callMethod("PieChart.create", width, height, bgColor, edgeColor)
	def setPieSize(self, x, y, r) :
		dll.callMethod("PieChart.setPieSize", self.this, x, y, r)
	def set3D(self, depth = -1, angle = -1, shadowMode = 0) :
		dll.callMethod("PieChart.set3D", self.this, depth, angle, shadowMode)
	def setStartAngle(self, startAngle, clockWise = 1) :
		dll.callMethod("PieChart.setStartAngle", self.this, startAngle, clockWise)
	def setLabelFormat(self, formatString) :
		dll.callMethod("PieChart.setLabelFormat", self.this, formatString)
	def setLabelStyle(self, font, fontSize = 8, fontColor = TextColor) :
		return TextBox(dll.callMethod("PieChart.setLabelStyle", self.this, font,
			fontSize, fontColor))
	def setLabelPos(self, pos, joinLineColor = Transparent) :
		dll.callMethod("PieChart.setLabelPos", self.this, pos, joinLineColor)
	def setData(self, data, labels = []) :
		dll.callMethod("PieChart.setData", self.this, len(data), data, labels)
	def sector(self, sectorNo) :
		return Sector(dll.callMethod("PieChart.sector", self.this, sectorNo))

#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to axis.h
#///////////////////////////////////////////////////////////////////////////////////
class BaseAxis :
	def __init__(self, this) :
		self.this = this
	def setLabelStyle(self, font, fontSize = 8, fontColor = TextColor, fontAngle = 0) :
		return TextBox(dll.callMethod("BaseAxis.setLabelStyle", self.this, font, fontSize, fontColor, fontAngle))
	def setLabelGap(self, d) :
		dll.callMethod("BaseAxis.setLabelGap", self.this, d)
	def setTitle(self, text, font = "arialbd.ttf", fontSize = 8, fontColor = TextColor) :
		return TextBox(dll.callMethod("BaseAxis.setTitle", self.this, text, font, fontSize, fontColor))
	def setTitlePos(self, alignment, titleGap = 6) :
		dll.callMethod("BaseAxis.setTitlePos", self.this, alignment, titleGap)
	def setColors(self, axisColor, labelColor = TextColor, titleColor = -1, tickColor = -1) :
		dll.callMethod("BaseAxis.setColors", self.this, axisColor, labelColor, titleColor, tickColor)
	def setTickLength(self, majorTickLen, minorTickLen = None) :
		if minorTickLen == None :
			dll.callMethod("BaseAxis.setTickLength", self.this, majorTickLen)
		else :
			self.setTickLength2(majorTickLen, minorTickLen)
	def setTickLength2(self, majorTickLen, minorTickLen) :
		dll.callMethod("BaseAxis.setTickLength2", self.this, majorTickLen, minorTickLen)
	def getCoor(self, v) :
		return dll.callMethod("BaseAxis.getCoor", self.this, v)
	def getLength(self) :
		return dll.callMethod("BaseAxis.getLength", self.this)

class XAxis(BaseAxis) :
	def __init__(self, this) :
		self.this = this
	def setLabels(self, labels) :
		return TextBox(dll.callMethod("XAxis.setLabels", self.this, len(labels), labels))
	def setIndent(self, indent) :
		dll.callMethod("XAxis.setIndent", self.this, indent)

class Mark(TextStyle) :
	def __init__(self, this) :
		self.this = this
	def setValue(self, value) :
		dll.callMethod("Mark.setValue", self.this, value)
	def setMarkColor(self, lineColor, textColor = -1, tickColor = -1) :
		dll.callMethod("Mark.setMarkColor", self.this, lineColor, textColor, tickColor)
	def setLineWidth(self, w) :
		dll.callMethod("Mark.setLineWidth", self.this, w)

class YAxis(BaseAxis) :
	def __init__(self, this) :
		self.this = this
	def addMark(self, value, lineColor, text = "", font = "", fontSize = 8) :
		return Mark(dll.callMethod("YAxis.addMark", self.this, value, lineColor, text, font, fontSize))
	def addZone(self, startValue, endValue, color) :
		dll.callMethod("YAxis.addZone", self.this, startValue, endValue, color)
	def setLinearScale(self, lowerLimit, upperLimit, tickInc = 0) :
		dll.callMethod("YAxis.setLinearScale", self.this, lowerLimit, upperLimit, tickInc)
	def setLogScale(self, logScale = 1) :
		dll.callMethod("YAxis.setLogScale", self.this, logScale)
	def setLogScale2(self, lowerLimit, upperLimit, tickInc = 0) :
		dll.callMethod("YAxis.setLogScale2", self.this, lowerLimit, upperLimit, tickInc)
	def setAutoScale(self, topExtension = 0, bottomExtension = 0) :
		dll.callMethod("YAxis.setAutoScale", self.this, topExtension, bottomExtension)
	def setTickDensity(self, tickDensity) :
		dll.callMethod("YAxis.setTickDensity", self.this, tickDensity)
	def setTopMargin(self, topMargin) :
		dll.callMethod("YAxis.setTopMargin", self.this, topMargin)
	def setLabelFormat(self, formatString) :
		dll.callMethod("YAxis.setLabelFormat", self.this, formatString)

#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to layer.h
#///////////////////////////////////////////////////////////////////////////////////
NoValue = +1.7e308

class DataSet :
	def __init__(self, this) :
		self.this = this
	def setData(self, data) :
		dll.callMethod("DataSet.setData", self.this, len(data), data)
	def setDataName(self, name) :
		dll.callMethod("DataSet.setDataName", self.this, name)
	def setDataColor(self, dataColor, edgeColor = LineColor, shadowColor = -1, shadowEdgeColor = -1) :
		dll.callMethod("DataSet.setDataColor", self.this, dataColor, edgeColor, shadowColor, shadowEdgeColor)
	def setUseYAxis2(self, b = 1) :
		dll.callMethod("DataSet.setUseYAxis2", self.this, b)
	def setLineWidth(self, w) :
		dll.callMethod("DataSet.setLineWidth", self.this, w)
	def setDataLabelFormat(self, formatString) :
		dll.callMethod("DataSet.setDataLabelFormat", self.this, formatString)
	def setDataLabelStyle(self, font = "", fontSize = 8, fontColor = TextColor, fontAngle = 0) :
		return TextStyle(dll.callMethod("DataSet.setDataLabelStyle", self.this, font, fontSize, fontColor, fontAngle))

class Layer :
	Overlay = 0
	Stack = 1
	Depth = 2
	Side = 3
	def __init__(self, this) :
		self.this = this
	def setSize(self, x, y, w, h) :
		dll.callMethod("Layer.setSize", self.this, x, y, w, h)
	def set3D(self, d = -1, zGap = 0) :
		dll.callMethod("Layer.set3D", self.this, d, zGap)
	def set3D2(self, xDepth, yDepth, xGap, yGap) :
		dll.callMethod("Layer.set3D2", self.this, xDepth, yDepth, xGap, yGap)
	def setLineWidth(self, w) :
		dll.callMethod("Layer.setLineWidth", self.this, w)
	def setDataCombineMethod(self, m) :
		dll.callMethod("Layer.setDataCombineMethod", self.this, m)
	def addDataSet(self, data, color = -1, name = "") :
		return DataSet(dll.callMethod("Layer.addDataSet", self.this, len(data), data, color, name))
	def getMinX(self) :
		return dll.callMethod("Layer.getMinX", self.this)
	def getMaxX(self) :
		return dll.callMethod("Layer.getMaxX", self.this)
	def getMaxY(self, yAxis = 1) :
		return dll.callMethod("Layer.getMaxY", self.this, yAxis)
	def getMinY(self, yAxis = 1) :
		return dll.callMethod("Layer.getMinY", self.this, yAxis)
	def getDepthX(self) :
		return dll.callMethod("Layer.getDepthX", self.this)
	def getDepthY(self) :
		return dll.callMethod("Layer.getDepthY", self.this)
	def getXCoor(self, v) :
		return dll.callMethod("Layer.getXCoor", self.this, v)
	def getYCoor(self, v, yAxis = 1) :
		return dll.callMethod("Layer.getYCoor", self.this, v, yAxis)
	def setDataLabelFormat(self, formatString) :
		dll.callMethod("Layer.setDataLabelFormat", self.this, formatString)
	def setDataLabelStyle(self, font = "", fontSize = 8, fontColor = TextColor, fontAngle = 0) :
		return TextStyle(dll.callMethod("Layer.setDataLabelStyle", self.this, font, fontSize, fontColor, fontAngle))
	def setAggregateLabelFormat(self, formatString) :
		dll.callMethod("Layer.setAggregateLabelFormat", self.this, formatString)
	def setAggregateLabelStyle(self, font = "", fontSize = 8, fontColor = TextColor, fontAngle = 0) :
		return TextStyle(dll.callMethod("Layer.setAggregateLabelStyle", self.this, font, fontSize, fontColor, fontAngle))

#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to barlayer.h
#///////////////////////////////////////////////////////////////////////////////////
class BarLayer(Layer) :
	def __init__(self, this) :
		self.this = this
	def setBarGap(self, barGap, subBarGap = 0.2) :
		dll.callMethod("BarLayer.setBarGap", self.this, barGap, subBarGap)

#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to linelayer.h
#///////////////////////////////////////////////////////////////////////////////////
class LineLayer(Layer) :
	def __init__(self, this) :
		self.this = this

#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to arealayer.h
#///////////////////////////////////////////////////////////////////////////////////
class AreaLayer(Layer) :
	def __init__(self, this) :
		self.this = this

#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to hloclayer.h
#///////////////////////////////////////////////////////////////////////////////////
class HLOCLayer(Layer) :
	def __init__(self, this) :
		self.this = this

#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to xychart.h
#///////////////////////////////////////////////////////////////////////////////////
class PlotArea :
	def __init__(self, this) :
		self.this = this
	def setBackground(self, color, altBgColor = -1, edgeColor = LineColor) :
		dll.callMethod("PlotArea.setBackground", self.this, color, altBgColor, edgeColor)
	def setBackground2(self, img, align = Center) :
		dll.callMethod("PlotArea.setBackground2", self.this, img, align)
	def setGridColor(self, hGridColor, vGridColor = Transparent) :
		dll.callMethod("PlotArea.setGridColor", self.this, hGridColor, vGridColor)

class XYChart(BaseChart) :
	def __init__(self, width, height, bgColor = BackgroundColor, edgeColor = Transparent) :
		self.this = dll.callMethod("XYChart.create", width, height, bgColor, edgeColor)
	def yAxis(self) :
		return YAxis(dll.callMethod("XYChart.yAxis", self.this))
	def yAxis2(self) :
		return YAxis(dll.callMethod("XYChart.yAxis2", self.this))
	def syncYAxis(self, slope = 1, intercept = 0) :
		dll.callMethod("XYChart.syncYAxis", self.this, slope, intercept)
	def setYAxisOnRight(self, b) :
		dll.callMethod("XYChart.setYAxisOnRight", self.this, b)
	def xAxis(self) :
		return XAxis(dll.callMethod("XYChart.xAxis", self.this))
	def xAxis2(self) :
		return XAxis(dll.callMethod("XYChart.xAxis2", self.this))
	def setPlotArea(self, x, y, width, height, bgColor = Transparent, altBgColor = -1, 
		edgeColor = LineColor, hGridColor = 0xc0c0c0, vGridColor = Transparent) :
		return PlotArea(dll.callMethod("XYChart.setPlotArea", self.this, 
			x, y, width, height, bgColor, altBgColor, edgeColor, hGridColor, vGridColor))
	def addBarLayer(self, data = None, color = -1, name = "", depth = 0) :
		if data != None :
			return BarLayer(dll.callMethod("XYChart.addBarLayer", self.this, len(data), data, color, name, depth))
		else :
			return self.addBarLayer2()
	def addBarLayer2(self, dataCombineMethod = Layer.Side, depth = 0) :
		return BarLayer(dll.callMethod("XYChart.addBarLayer2", self.this, dataCombineMethod, depth))
	def addLineLayer(self, data = None, color = -1, name = "", depth = 0) :
		if data != None :
			return LineLayer(dll.callMethod("XYChart.addLineLayer", self.this, len(data), data, color, name, depth))
		else :
			return self.addLineLayer2()
	def addLineLayer2(self, dataCombineMethod = Layer.Overlay, depth = 0) :
		return LineLayer(dll.callMethod("XYChart.addLineLayer2", self.this, dataCombineMethod, depth))
	def addAreaLayer(self, data = None, color = -1, name = "", depth = 0) :
		if data != None :
			return AreaLayer(dll.callMethod("XYChart.addAreaLayer", self.this, len(data), data, color, name, depth))
		else :
			return self.addAreaLayer2()
	def addAreaLayer2(self, dataCombineMethod = Layer.Stack, depth = 0) :
		return AreaLayer(dll.callMethod("XYChart.addAreaLayer2", self.this, dataCombineMethod, depth))
	def addHLOCLayer(self, highData = None, lowData = [], openData = [], closeData = [], color = -1) :
		if highData != None :
			return HLOCLayer(dll.callMethod("XYChart.addHLOCLayer", self.this, 
				max(map(len, [highData, lowData, openData, closeData])), highData, lowData, openData, closeData, color))
		else :
			return self.addHLOCLayer2()
	def addHLOCLayer2(self) :
		return HLOCLayer(dll.callMethod("XYChart.addHLOCLayer2", self.this))

#///////////////////////////////////////////////////////////////////////////////////
#//	bindings to chartdir.h
#///////////////////////////////////////////////////////////////////////////////////
def getCopyright() :
	return dll.callMethod("getCopyright")

def getVersion() :
	return dll.callMethod("getVersion")

def getDescription() :
	return dll.callMethod("getDescription")
